/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.bundles;

import adalid.commons.i18n.EnglishLinguist;
import adalid.commons.i18n.Linguist;
import adalid.commons.i18n.SpanishLinguist;
import adalid.commons.util.BitUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Bundle {
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale SPANISH = Locale.forLanguageTag("es");
    public static final Locale PORTUGUESE = Locale.forLanguageTag("pt");
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{ENGLISH, SPANISH};
    private static final Linguist[] SUPPORTING_LINGUISTS = new Linguist[]{new EnglishLinguist(), new SpanishLinguist()};
    private static final Logger logger = Logger.getLogger(Bundle.class);
    private static final String BASE_NAME = Bundle.class.getName();
    private static final ResourceBundle[] RESOURCE_BUNDLES = new ResourceBundle[]{ResourceBundle.getBundle(BASE_NAME, ENGLISH), ResourceBundle.getBundle(BASE_NAME, SPANISH)};
    private static final Locale defaultLocale = SUPPORTED_LOCALES[0];
    private static final Linguist defaultLinguist = SUPPORTING_LINGUISTS[0];
    private static final ResourceBundle defaultResourceBundle = RESOURCE_BUNDLES[0];
    private static final ResourceBundle specialResourceBundle = ResourceBundle.getBundle(BASE_NAME, Locale.forLanguageTag("adalid"));
    private static Locale locale;
    private static Linguist linguist;
    private static ResourceBundle resourceBundle;

    private static void initialise() {
        locale = defaultLocale;
        linguist = defaultLinguist;
        resourceBundle = defaultResourceBundle;
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }

    public static boolean isSupportedLocale(Locale locale) {
        return locale != null && ArrayUtils.contains((Object[])SUPPORTED_LOCALES, (Object)locale);
    }

    private static int indexOfLocale(Locale locale) {
        return locale == null ? -1 : ArrayUtils.indexOf((Object[])SUPPORTED_LOCALES, (Object)locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale newLocale) {
        if (newLocale == null) {
            logger.warn((Object)("null value for locale parameter; falling back to " + String.valueOf(defaultLocale)));
            Bundle.initialise();
        } else if (newLocale.equals(locale)) {
            logger.trace((Object)("Locale " + String.valueOf(newLocale) + " already set."));
        } else if (Bundle.isSupportedLocale(newLocale)) {
            try {
                logger.trace((Object)("Change of Locale (from \"" + String.valueOf(locale) + "\" to \"" + String.valueOf(newLocale) + "\")"));
                locale = newLocale;
                linguist = Bundle.getLinguist(newLocale);
                resourceBundle = Bundle.getResourceBundle(newLocale);
            }
            catch (MissingResourceException e) {
                logger.warn((Object)("Locale " + String.valueOf(newLocale) + " bundle missing; falling back to " + String.valueOf(defaultLocale)));
                Bundle.initialise();
            }
        } else {
            logger.warn((Object)("Locale " + String.valueOf(newLocale) + " not supported yet; falling back to " + String.valueOf(defaultLocale)));
            Bundle.initialise();
        }
    }

    public static Linguist getLinguist() {
        return linguist;
    }

    public static Linguist getLinguist(Locale locale) {
        int index = Bundle.indexOfLocale(locale);
        return index == -1 ? linguist : SUPPORTING_LINGUISTS[index];
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        int index = Bundle.indexOfLocale(locale);
        return index == -1 ? resourceBundle : RESOURCE_BUNDLES[index];
    }

    public static boolean getBoolean(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return BitUtils.valueOf(trimmed);
    }

    public static String getString(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return trimmed == null ? key : trimmed;
    }

    public static String getTrimmedToEmptyString(String key) {
        String trimmed = Bundle.getTrimmedToNullString(key);
        return trimmed == null ? "" : trimmed;
    }

    public static String getTrimmedToNullString(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String string = Bundle.getTrimmedToNullString(key, resourceBundle);
        if (string == null) {
            string = Bundle.getTrimmedToNullString(key, specialResourceBundle);
        }
        return string;
    }

    public static String getTrimmedToNullString(String key, Locale locale) {
        return StringUtils.isBlank((String)key) ? null : Bundle.getTrimmedToNullString(key, Bundle.getResourceBundle(locale));
    }

    private static String getTrimmedToNullString(String key, ResourceBundle rb) {
        String string = Bundle.getUntrimmedString(key, rb);
        return StringUtils.trimToNull((String)string);
    }

    public static String getUntrimmedString(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        String string = Bundle.getUntrimmedString(key, resourceBundle);
        if (string == null) {
            string = Bundle.getUntrimmedString(key, specialResourceBundle);
        }
        return string;
    }

    public static String getUntrimmedString(String key, Locale locale) {
        return StringUtils.isBlank((String)key) ? null : Bundle.getUntrimmedString(key, Bundle.getResourceBundle(locale));
    }

    private static String getUntrimmedString(String key, ResourceBundle rb) {
        try {
            String string = rb.getString(key);
            return string == null || string.isEmpty() ? null : string;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static {
        Bundle.initialise();
    }
}

