/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.i18n;

import adalid.commons.util.StrUtils;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public interface Linguist {
    public Set<String> getArticles();

    public Set<String> getConjunctions();

    public Set<String> getPrepositions();

    default public String prune(String noun) {
        String trimmed = StringUtils.trimToNull((String)noun);
        if (trimmed == null) {
            return noun;
        }
        String[] words = trimmed.contains(" ") ? StringUtils.split((String)trimmed) : StringUtils.splitByCharacterTypeCamelCase((String)trimmed);
        Set<String> conjunctions = this.getConjunctions();
        Set<String> prepositions = this.getPrepositions();
        ArrayList<String> list = new ArrayList<String>();
        for (String word : words) {
            String lc = word.toLowerCase();
            if (conjunctions.contains(lc) || prepositions.contains(lc)) continue;
            list.add(word);
        }
        return list.isEmpty() ? noun : StringUtils.join(list, (String)" ");
    }

    default public boolean equalAfterNormalization(String noun, String anotherNoun) {
        return StringUtils.isNotBlank((String)noun) && StringUtils.isNotBlank((String)anotherNoun) && StrUtils.diacriticless(this.prune(noun)).toLowerCase().equals(StrUtils.diacriticless(this.prune(anotherNoun)).toLowerCase());
    }

    public String capitalize(String var1);

    public boolean isPlural(String var1);

    public boolean isSingular(String var1);

    public String pluralOf(String var1);

    public String pluralOfMultiwordExpression(String var1);

    public String singularOf(String var1);

    public String singularOfMultiwordExpression(String var1);
}

