/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class SpanishNoun {
    static final String[] articles = new String[]{"al", "del", "el", "la", "las", "lo", "los", "un", "una", "unas", "uno", "unos"};
    static final String[] conjunctions = new String[]{"aunque", "como", "conque", "cuando", "donde", "e", "empero", "entonces", "ergo", "incluso", "luego", "mas", "mientras", "ni", "o", "ora", "pero", "porque", "pues", "que", "sea", "si", "sino", "siquiera", "u", "y", "ya"};
    static final String[] prepositions = new String[]{"a", "ante", "bajo", "con", "contra", "de", "del", "desde", "durante", "en", "entre", "excepto", "hacia", "hasta", "mediante", "para", "por", "salvo", "seg\u00fan", "sin", "so", "sobre", "tras", "versus", "via"};
    private static final List<String> lowerCaseWords = new ArrayList<String>();
    private static final HashMap<String, Object> irregularSingulars = new HashMap(100);
    private static final HashMap<String, Object> irregularPlurals = new HashMap(100);

    public static Set<String> getArticles() {
        return Set.of(articles);
    }

    public static Set<String> getConjunctions() {
        return Set.of(conjunctions);
    }

    public static Set<String> getPrepositions() {
        return Set.of(prepositions);
    }

    public static String capitalize(String noun) {
        if (StringUtils.isBlank((String)noun)) {
            return noun;
        }
        char[] separators = new char[]{'-', '/'};
        Object[] split = StringUtils.split((String)noun);
        for (int i = 0; i < split.length; ++i) {
            String word = split[i].toLowerCase();
            split[i] = SpanishNoun.lowerCaseWords_contains(word) ? word : WordUtils.capitalize((String)word, (char[])separators);
        }
        return StringUtils.join((Object[])split, (char)' ');
    }

    private static boolean lowerCaseWords_contains(String word) {
        if (!lowerCaseWords.contains(word)) {
            String[] split;
            for (String term : split = StringUtils.split((String)word, (char)'/')) {
                if (lowerCaseWords.contains(term)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPlural(String word) {
        if (StringUtils.isBlank((String)word)) {
            return false;
        }
        int length = (word = word.trim().toLowerCase()).length();
        if (length <= 1) {
            return false;
        }
        if (irregularPlurals.containsKey(word)) {
            return true;
        }
        if (irregularSingulars.containsKey(word)) {
            return false;
        }
        return word.charAt(length - 1) == 's';
    }

    public static boolean isSingular(String word) {
        if (StringUtils.isBlank((String)word)) {
            return false;
        }
        int length = (word = word.trim().toLowerCase()).length();
        if (length <= 1) {
            return true;
        }
        if (irregularSingulars.containsKey(word)) {
            return true;
        }
        if (irregularPlurals.containsKey(word)) {
            return false;
        }
        return word.charAt(length - 1) != 's';
    }

    public static String pluralOf(String word) {
        if (StringUtils.isBlank((String)word)) {
            return word;
        }
        int length = (word = word.trim().toLowerCase()).length();
        if (length <= 1) {
            return word;
        }
        if (SpanishNoun.isPlural(word)) {
            return word;
        }
        Object singularLookup = irregularSingulars.get(word);
        if (singularLookup != null) {
            if (singularLookup instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)singularLookup;
                return (String)arrayList.get(0);
            }
            return (String)singularLookup;
        }
        char lastLetter = word.charAt(length - 1);
        if ("aeiou".indexOf(lastLetter) >= 0) {
            return word + "s";
        }
        if (lastLetter == 'z') {
            return word.substring(0, length - 1) + "ces";
        }
        return word + "es";
    }

    public static String singularOf(String word) {
        if (StringUtils.isBlank((String)word)) {
            return word;
        }
        int length = (word = word.trim().toLowerCase()).length();
        if (length <= 1) {
            return word;
        }
        if (SpanishNoun.isSingular(word)) {
            return word;
        }
        Object pluralLookup = irregularPlurals.get(word);
        if (pluralLookup != null) {
            if (pluralLookup instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)pluralLookup;
                return (String)arrayList.get(0);
            }
            return (String)pluralLookup;
        }
        char lastLetter = word.charAt(length - 1);
        if (lastLetter != 's') {
            return word;
        }
        char secondLast = word.charAt(length - 2);
        if (secondLast != 'e' || length <= 3) {
            return word.substring(0, length - 1);
        }
        char thirdLast = word.charAt(length - 3);
        if (thirdLast == 'c') {
            return word.substring(0, length - 3) + "z";
        }
        return word.substring(0, length - 1);
    }

    public static String pluralOfMultiwordExpression(String mwe) {
        if (StringUtils.isNotBlank((String)mwe)) {
            Object[] tokens = StringUtils.split((String)mwe);
            if (tokens.length == 1) {
                return SpanishNoun.pluralOf(tokens[0]);
            }
            if (tokens.length > 1) {
                for (int i = 0; i < tokens.length && !ArrayUtils.contains((Object[])prepositions, (Object)((String)tokens[i]).toLowerCase()); ++i) {
                    tokens[i] = SpanishNoun.pluralOf((String)tokens[i]);
                }
                return StringUtils.join((Object[])tokens, (char)' ');
            }
        }
        return mwe;
    }

    static {
        lowerCaseWords.addAll(Arrays.asList(articles));
        lowerCaseWords.addAll(Arrays.asList(conjunctions));
        lowerCaseWords.addAll(Arrays.asList(prepositions));
        irregularSingulars.put("lunes", "lunes");
        irregularSingulars.put("martes", "martes");
        irregularSingulars.put("mi\u00e9rcoles", "mi\u00e9rcoles");
        irregularSingulars.put("jueves", "jueves");
        irregularSingulars.put("viernes", "viernes");
        for (String key : irregularSingulars.keySet()) {
            Object value = irregularSingulars.get(key);
            if (!(value instanceof String)) continue;
            irregularPlurals.put(value.toString(), key);
        }
    }
}

