/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.properties;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.properties.SortedProperties;
import adalid.commons.util.FilUtils;
import adalid.commons.util.LogUtils;
import adalid.commons.util.LongUtils;
import adalid.commons.util.ThrowableUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class Dictionary {
    static final Logger logger = Logger.getLogger(Dictionary.class);
    static final String USER_DIR = System.getProperty("user.dir");
    static final String FILE_SEP = System.getProperty("file.separator");
    static final String PROPERTIES_SUFFIX = ".properties";
    static final String DEFAULT_DICTIONARY_DIR = FilUtils.getUserDirPath("src", "main", "resources", "dictionary");
    private static int errorCount;
    private static int warningCount;
    private static Level _infoLevel;
    private static boolean _fairInfoLevel;
    private final String simpleName;
    private final String fileName;
    private final String filePath;
    private final String lineSeparator;
    private final boolean scrutinize;
    private final Map<String, String> map = new TreeMap<String, String>();
    private final Properties properties;
    private final Set<String> errors = new TreeSet<String>();
    private final Set<String> warnings = new TreeSet<String>();

    public static Level getInfoLevel() {
        return _infoLevel;
    }

    public static void setInfoLevel(Level level) {
        _infoLevel = LogUtils.check(level, Level.OFF, Level.INFO);
        _fairInfoLevel = LogUtils.fair(_infoLevel);
    }

    public static boolean isValidNumericCode(String value) {
        return LongUtils.valueOf(value, (Long)0L) != 0L;
    }

    public static void printSummary() {
        if (warningCount > 0) {
            logger.warn((Object)("warnings=" + warningCount));
        }
        if (errorCount > 0) {
            logger.warn((Object)("errors=" + errorCount));
        }
    }

    public static int getErrorCount() {
        return errorCount;
    }

    public static int getWarningCount() {
        return warningCount;
    }

    public static void reset() {
        errorCount = 0;
        warningCount = 0;
    }

    Dictionary(Class<?> clazz, String folder, String subfolder, String separator, boolean check) {
        this.simpleName = clazz.getSimpleName();
        this.fileName = this.simpleName + PROPERTIES_SUFFIX;
        this.filePath = this.folder(folder) + this.subfolder(subfolder) + this.fileName;
        this.lineSeparator = StringUtils.isBlank((String)separator) ? System.lineSeparator() : separator;
        this.scrutinize = check;
        this.properties = this.loadProperties();
        this.log(true);
        this.check();
    }

    private String folder(String folder) {
        return StringUtils.isBlank((String)folder) ? DEFAULT_DICTIONARY_DIR : folder.trim();
    }

    private String subfolder(String subfolder) {
        return StringUtils.isBlank((String)subfolder) ? FILE_SEP : FILE_SEP + subfolder.trim() + FILE_SEP;
    }

    private Properties loadProperties() {
        SortedProperties sortedProperties = new SortedProperties();
        File file = new File(this.filePath);
        if (file.isFile()) {
            try (FileInputStream inStream = new FileInputStream(file.getPath());){
                sortedProperties.load(inStream);
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
        return sortedProperties;
    }

    private void check() {
        if (this.scrutinize) {
            for (Object key : this.properties.keySet()) {
                String value = this.properties.getProperty(String.valueOf(key));
                if (Dictionary.isValidNumericCode(value)) continue;
                if (StringUtils.isBlank((String)value)) {
                    this.warn("property " + this.simpleName + " [" + String.valueOf(key) + "] value is missing");
                    continue;
                }
                this.warn("\"" + value + "\" is an invalid numeric code; property " + this.simpleName + " [" + String.valueOf(key) + "] value will be replaced");
            }
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        Object previousValue = this.properties.setProperty(key, value);
        if (this.scrutinize && previousValue != null && !previousValue.equals(value)) {
            if (StringUtils.isBlank((String)String.valueOf(previousValue))) {
                this.warn("assigning value to property " + this.simpleName + " [" + key + "]");
            } else {
                this.warn("replacing value of property " + this.simpleName + " [" + key + "]");
            }
        }
        this.putProperty(key, value);
        return previousValue;
    }

    public String putProperty(String key, String value) {
        String previousKey = this.map.put(value, key);
        if (this.scrutinize && previousKey != null && !previousKey.equals(key)) {
            int c = key.compareTo(previousKey);
            String k1 = c < 0 ? key : previousKey;
            String k2 = c < 0 ? previousKey : key;
            this.error("\"" + value + "\" is the same numeric code for properties " + this.simpleName + " [" + k1 + "] and [" + k2 + "]");
        }
        return previousKey;
    }

    public void store() {
        PropertiesHandler.storeProperties(this.properties, this.filePath, null, this.lineSeparator);
        this.log(false);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    private void log(boolean initializing) {
        String path = StringUtils.substringAfter((String)this.filePath, (String)USER_DIR).replace(FILE_SEP, "/");
        if (this.properties.isEmpty()) {
            if (initializing) {
                this.info("initializing " + path);
            } else {
                this.warn("file " + path + " is empty");
            }
        } else {
            this.info("file " + path + " has " + this.properties.size() + " properties");
        }
    }

    private void info(String message) {
        if (_fairInfoLevel) {
            logger.log((Priority)_infoLevel, (Object)message);
        }
    }

    private void warn(String message) {
        if (this.warnings.add(message)) {
            ++warningCount;
            logger.warn((Object)message);
        }
    }

    private void error(String message) {
        if (this.errors.add(message)) {
            ++errorCount;
            logger.error((Object)message);
        }
    }

    static {
        _infoLevel = Level.OFF;
    }
}

