/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.properties;

import adalid.commons.properties.BootstrappingFile;
import adalid.commons.properties.SortedProperties;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.FilUtils;
import adalid.commons.util.ThrowableUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PropertiesHandler {
    private static final Logger logger = Logger.getLogger(PropertiesHandler.class);
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String BOOTSTRAPPING_FILE_NAME = BootstrappingFile.getName();
    private static final String BOOTSTRAPPING_FILE_PATH = USER_DIR + FILE_SEP + BOOTSTRAPPING_FILE_NAME;
    private static final String USER_VELOCITY_RESOURCES_DIR = USER_DIR + FILE_SEP + "resources" + FILE_SEP + "velocity";
    private static final String PRIVATE_FILE_NAME = "private.properties";
    private static final String PRIVATE_FILE_PATH = USER_DIR + FILE_SEP + "nbproject" + FILE_SEP + "private" + FILE_SEP + "private.properties";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final Pattern startsWithWordCharacter = Pattern.compile("^\\w+");
    private static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrappingProperties();
    private static final String PREFERRED_FILE_ENCODING_KEY = "preferred.file.encoding";
    private static final String ROOT_FOLDER_KEY = "root.folder";
    private static final String VELOCITY_FOLDER_KEY = "velocity.folder";
    private static final String VELOCITY_FILE_KEY = "velocity.properties.file";
    private static final String VELOCITY_SUP_FILE_KEY = "velocity.supplementary.properties.file";
    private static final Charset preferred_file_encoding = PropertiesHandler.preferredFileEncoding();
    private static final File root_folder = PropertiesHandler.rootFolder();
    private static final File velocity_properties_file = PropertiesHandler.velocityPropertiesFile();
    private static final File velocity_supplementary_properties_file = PropertiesHandler.velocitySupplementaryPropertiesFile();
    private static final Properties velocity_supplementary_properties = PropertiesHandler.loadProperties(velocity_supplementary_properties_file);
    private static final File[] velocity_folders = PropertiesHandler.velocityFolders();
    private static final File[] platforms_folders = PropertiesHandler.platformsFolders();

    public static boolean missingBootstrappingProperties() {
        return bootstrapping == null || bootstrapping.isEmpty() || preferred_file_encoding == null || root_folder == null || velocity_properties_file == null || velocity_supplementary_properties_file == null || velocity_folders == null || velocity_folders.length == 0 || platforms_folders == null || platforms_folders.length == 0;
    }

    private static ExtendedProperties getBootstrappingProperties() {
        ExtendedProperties properties = PropertiesHandler.getExtendedProperties(BOOTSTRAPPING_FILE_PATH, Level.DEBUG);
        return properties == null || properties.isEmpty() ? PropertiesHandler.getResourceAsExtendedProperties("/" + BOOTSTRAPPING_FILE_NAME) : properties;
    }

    public static ExtendedProperties getPrivateProperties() {
        ExtendedProperties properties = PropertiesHandler.getExtendedProperties(PRIVATE_FILE_PATH, Level.DEBUG);
        return properties == null || properties.isEmpty() ? PropertiesHandler.getResourceAsExtendedProperties("/private.properties") : properties;
    }

    public static Properties getResourceAsProperties(String resource) {
        return PropertiesHandler.getResourceAsProperties(resource, Level.ERROR);
    }

    public static Properties getResourceAsProperties(String resource, Level badFileLogLevel) {
        return PropertiesHandler.getResourceAsProperties(resource, badFileLogLevel, Level.INFO);
    }

    public static Properties getResourceAsProperties(String resource, Level badFileLogLevel, Level goodFileLogLevel) {
        if (StringUtils.isBlank((String)resource)) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream stream = PropertiesHandler.class.getResourceAsStream(resource);){
            if (stream == null) {
                logger.log((Priority)badFileLogLevel, (Object)("resource " + resource + " is missing"));
            } else {
                properties.load(stream);
                logger.log((Priority)goodFileLogLevel, (Object)("resource " + resource + " loaded (" + properties.size() + " properties)"));
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
        }
        return properties;
    }

    public static ExtendedProperties getResourceAsExtendedProperties(String resource) {
        return PropertiesHandler.getResourceAsExtendedProperties(resource, Level.ERROR);
    }

    public static ExtendedProperties getResourceAsExtendedProperties(String resource, Level badFileLogLevel) {
        return PropertiesHandler.getResourceAsExtendedProperties(resource, badFileLogLevel, Level.INFO);
    }

    public static ExtendedProperties getResourceAsExtendedProperties(String resource, Level badFileLogLevel, Level goodFileLogLevel) {
        if (StringUtils.isBlank((String)resource)) {
            return null;
        }
        ExtendedProperties properties = new ExtendedProperties();
        try (InputStream stream = PropertiesHandler.class.getResourceAsStream(resource);){
            if (stream == null) {
                logger.log((Priority)badFileLogLevel, (Object)("resource " + resource + " is missing"));
            } else {
                properties.load(stream);
                logger.log((Priority)goodFileLogLevel, (Object)("resource " + resource + " loaded (" + properties.size() + " properties)"));
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
        }
        return properties;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getResourceBundleKeys(String baseName, Locale locale) {
        block18: {
            LinkedHashSet<String> keySet = new LinkedHashSet<String>();
            String resource = PropertiesHandler.resourceBundlePropertiesFileName(baseName, locale);
            try (InputStream stream = PropertiesHandler.class.getResourceAsStream(resource);){
                LinkedHashSet<String> linkedHashSet;
                if (stream == null) {
                    PropertiesHandler.missingResourceBundle(resource, locale);
                    break block18;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line == null || line.isEmpty() || line.startsWith("#") || line.startsWith("!")) continue;
                        PropertiesHandler.addResourceBundleKey(keySet, line);
                    }
                    logger.trace((Object)("resource " + resource + " loaded (" + keySet.size() + " keys)"));
                    linkedHashSet = keySet;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        logger.error((Object)(ex.getClass().getSimpleName() + " " + baseName + "/" + String.valueOf(locale)));
                        logger.error((Object)ThrowableUtils.getString(ex));
                        break block18;
                    }
                }
                reader.close();
                return linkedHashSet;
            }
            catch (Exception ex) {
                logger.error((Object)(ex.getClass().getSimpleName() + " " + baseName + "/" + String.valueOf(locale)));
                logger.error((Object)ThrowableUtils.getString(ex));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> getResourceBundleRows(String baseName, Locale locale) {
        block18: {
            ArrayList<String> list = new ArrayList<String>();
            String resource = PropertiesHandler.resourceBundlePropertiesFileName(baseName, locale);
            try (InputStream stream = PropertiesHandler.class.getResourceAsStream(resource);){
                ArrayList<String> arrayList;
                if (stream == null) {
                    PropertiesHandler.missingResourceBundle(resource, locale);
                    break block18;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    while (reader.ready()) {
                        String line = reader.readLine();
                        list.add(StringUtils.trimToEmpty((String)line));
                    }
                    logger.trace((Object)("resource " + resource + " loaded (" + list.size() + " rows)"));
                    arrayList = list;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        logger.error((Object)(ex.getClass().getSimpleName() + " " + baseName + "/" + String.valueOf(locale)));
                        logger.error((Object)ThrowableUtils.getString(ex));
                        break block18;
                    }
                }
                reader.close();
                return arrayList;
            }
            catch (Exception ex) {
                logger.error((Object)(ex.getClass().getSimpleName() + " " + baseName + "/" + String.valueOf(locale)));
                logger.error((Object)ThrowableUtils.getString(ex));
            }
        }
        return null;
    }

    private static String resourceBundlePropertiesFileName(String baseName, Locale locale) {
        return "/" + baseName.replace('.', '/') + "_" + locale.toString() + PROPERTIES_SUFFIX;
    }

    private static void addResourceBundleKey(Set<String> keySet, String line) {
        String key;
        String separatorChars = "= :";
        String[] split = StringUtils.split((String)StringUtils.trimToNull((String)line), (String)separatorChars);
        if (split != null && split.length > 0 && startsWithWordCharacter.matcher(key = split[0]).find()) {
            keySet.add(key);
        }
    }

    private static void missingResourceBundle(String resource, Locale locale) {
        if (locale.getVariant().isEmpty()) {
            logger.error((Object)("missing resource " + resource));
        } else {
            logger.warn((Object)("missing resource " + resource));
            String before = StringUtils.substringBeforeLast((String)resource, (String)"/").replace("/", FILE_SEP);
            String bundle = StringUtils.substringAfterLast((String)resource, (String)"/");
            Object[] dirs = new String[]{USER_DIR, "src", "main", "resources"};
            String folder = StringUtils.join((Object[])dirs, (String)FILE_SEP) + before;
            try {
                File file = new File(folder);
                if (!file.exists()) {
                    logger.info((Object)("creating directory " + String.valueOf(file)));
                    file.mkdirs();
                }
                file = new File(file, bundle);
                logger.info((Object)("creating resource file " + String.valueOf(file)));
                file.createNewFile();
            }
            catch (IOException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
    }

    public static ExtendedProperties getBootstrapping() {
        return bootstrapping;
    }

    public static Properties getVelocityProperties() {
        File file = PropertiesHandler.getVelocityPropertiesFile();
        Properties properties = PropertiesHandler.loadProperties(file);
        return properties;
    }

    public static Properties getVelocitySupplementaryProperties() {
        return velocity_supplementary_properties;
    }

    public static Properties loadProperties(String filename) {
        return PropertiesHandler.loadProperties(filename, false);
    }

    public static Properties loadProperties(String filename, boolean sortedKeys) {
        return PropertiesHandler.loadProperties(filename, sortedKeys, Level.ERROR);
    }

    public static Properties loadProperties(String filename, boolean sortedKeys, Level badFileLogLevel) {
        return StringUtils.isBlank((String)filename) ? PropertiesHandler.newProperties(sortedKeys) : PropertiesHandler.loadProperties(new File(filename), sortedKeys, badFileLogLevel);
    }

    public static Properties loadProperties(File file) {
        return PropertiesHandler.loadProperties(file, false);
    }

    public static Properties loadProperties(File file, boolean sortedKeys) {
        return PropertiesHandler.loadProperties(file, sortedKeys, Level.ERROR);
    }

    public static Properties loadProperties(File file, boolean sortedKeys, Level badFileLogLevel) {
        String filename;
        Properties properties = PropertiesHandler.newProperties(sortedKeys);
        String string = filename = file == null ? "" : file.getPath();
        if (file == null) {
            logger.error((Object)"null properties file");
        } else if (file.isFile()) {
            try {
                logger.trace((Object)("loading " + filename));
                try (FileInputStream inStream = new FileInputStream(filename);){
                    properties.load(inStream);
                }
                PropertiesHandler.printProperties(properties);
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        } else {
            logger.log((Priority)badFileLogLevel, (Object)(filename + " does not exist or is not a normal file"));
        }
        return properties;
    }

    public static Properties loadProperties(byte[] buffer) {
        return PropertiesHandler.loadProperties(buffer, false);
    }

    public static Properties loadProperties(byte[] buffer, boolean sortedKeys) {
        Properties properties = PropertiesHandler.newProperties(sortedKeys);
        if (buffer == null) {
            logger.error((Object)"null properties buffer");
        } else {
            try {
                logger.trace((Object)("loading buffer " + Arrays.toString(buffer)));
                try (ByteArrayInputStream inStream = new ByteArrayInputStream(buffer);){
                    properties.load(inStream);
                }
                PropertiesHandler.printProperties(properties);
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
        return properties;
    }

    public static Properties loadProperties(ResourceBundle bundle) {
        return PropertiesHandler.loadProperties(bundle, false);
    }

    public static Properties loadProperties(ResourceBundle bundle, boolean sortedKeys) {
        Properties properties = PropertiesHandler.newProperties(sortedKeys);
        if (bundle == null) {
            logger.error((Object)"null properties bundle");
        } else {
            logger.trace((Object)("loading bundle " + String.valueOf(bundle)));
            Set<String> keySet = bundle.keySet();
            for (String key : keySet) {
                try {
                    String value = bundle.getString(key);
                    if (StringUtils.isBlank((String)value)) continue;
                    properties.setProperty(key, value.trim());
                }
                catch (MissingResourceException missingResourceException) {}
            }
            PropertiesHandler.printProperties(properties);
        }
        return properties;
    }

    private static Properties newProperties(boolean sortedKeys) {
        return sortedKeys ? new SortedProperties() : new Properties();
    }

    public static void storeProperties(Properties properties, String filename) {
        PropertiesHandler.storeProperties(properties, filename, null);
    }

    public static void storeProperties(Properties properties, String filename, String comments) {
        PropertiesHandler.storeProperties(properties, filename, comments, null);
    }

    public static void storeProperties(Properties properties, String filename, String comments, String lineSeparator) {
        if (StringUtils.isNotBlank((String)filename)) {
            PropertiesHandler.storeProperties(properties, new File(filename), comments, lineSeparator);
        }
    }

    public static void storeProperties(Properties properties, File file) {
        PropertiesHandler.storeProperties(properties, file, null);
    }

    public static void storeProperties(Properties properties, File file, String comments) {
        PropertiesHandler.storeProperties(properties, file, comments, null);
    }

    public static void storeProperties(Properties properties, File file, String comments, String lineSeparator) {
        String filename;
        String string = filename = file == null ? "" : file.getPath();
        if (file == null) {
            logger.error((Object)"null properties file");
        } else if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            try {
                SortedProperties sortedProperties;
                if (properties instanceof SortedProperties) {
                    SortedProperties sp;
                    sortedProperties = sp = (SortedProperties)properties;
                } else {
                    sortedProperties = new SortedProperties();
                    sortedProperties.putAll((Map<?, ?>)properties);
                }
                logger.trace((Object)("storing " + filename));
                try (FileOutputStream outStream = new FileOutputStream(filename);){
                    sortedProperties.store(outStream, comments, lineSeparator);
                }
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        } else {
            logger.error((Object)(filename + " is not a valid directory"));
        }
    }

    public static void printProperties(Properties properties) {
        PropertiesHandler.log(properties, Level.TRACE);
    }

    private static void log(Properties properties, Level level) {
        TreeSet<String> names = new TreeSet<String>(properties.stringPropertyNames());
        for (String name : names) {
            String value = properties.getProperty(name);
            logger.log((Priority)level, (Object)(name + " = " + (StringUtils.containsIgnoreCase((String)name, (String)"password") ? "***" : value)));
        }
    }

    public static ExtendedProperties getExtendedProperties(String filename) {
        return PropertiesHandler.getExtendedProperties(filename, Level.ERROR);
    }

    public static ExtendedProperties getExtendedProperties(String ... filename) {
        if (filename == null || filename.length == 0) {
            return null;
        }
        int last = filename.length - 1;
        ExtendedProperties properties = null;
        for (int i = 0; i < filename.length && (properties == null || properties.isEmpty()); ++i) {
            properties = PropertiesHandler.getExtendedProperties(filename[i], i == last ? Level.ERROR : Level.INFO, Level.INFO);
        }
        return properties;
    }

    public static ExtendedProperties getExtendedProperties(String filename, Level badFileLogLevel) {
        return PropertiesHandler.getExtendedProperties(filename, badFileLogLevel, Level.TRACE);
    }

    public static ExtendedProperties getExtendedProperties(String filename, Level badFileLogLevel, Level goodFileLogLevel) {
        return StringUtils.isBlank((String)filename) ? null : PropertiesHandler.getExtendedProperties(new File(filename), badFileLogLevel, goodFileLogLevel);
    }

    public static ExtendedProperties getExtendedProperties(File file) {
        return PropertiesHandler.getExtendedProperties(file, Level.ERROR);
    }

    public static ExtendedProperties getExtendedProperties(File file, Level badFileLogLevel) {
        return PropertiesHandler.getExtendedProperties(file, badFileLogLevel, Level.TRACE);
    }

    public static ExtendedProperties getExtendedProperties(File file, Level badFileLogLevel, Level goodFileLogLevel) {
        String filename;
        ExtendedProperties extendedProperties = new ExtendedProperties();
        String string = filename = file == null ? "" : file.getPath();
        if (file == null) {
            logger.error((Object)"null properties file");
        } else if (file.isFile()) {
            try {
                logger.trace((Object)("loading " + filename));
                try (FileInputStream inStream = new FileInputStream(filename);){
                    extendedProperties.load((InputStream)inStream);
                }
                logger.log((Priority)goodFileLogLevel, (Object)("file " + filename + " loaded (" + extendedProperties.size() + " properties)"));
                PropertiesHandler.printExtendedProperties(extendedProperties);
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        } else {
            logger.log((Priority)badFileLogLevel, (Object)(filename + " does not exist or is not a normal file"));
        }
        return extendedProperties;
    }

    public static ExtendedProperties getExtendedProperties(byte[] buffer) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        if (buffer == null) {
            logger.error((Object)"null properties buffer");
        } else {
            try {
                logger.trace((Object)("loading buffer " + Arrays.toString(buffer)));
                try (ByteArrayInputStream inStream = new ByteArrayInputStream(buffer);){
                    extendedProperties.load((InputStream)inStream);
                }
                PropertiesHandler.printExtendedProperties(extendedProperties);
            }
            catch (IOException ex) {
                logger.error((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
        return extendedProperties;
    }

    public static void printExtendedProperties(ExtendedProperties extendedProperties) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = extendedProperties.getKeys();
        while (i.hasNext()) {
            list.add((String)i.next());
        }
        Object[] names = new String[list.size()];
        list.toArray(names);
        Arrays.sort(names);
        for (Object name : names) {
            String[] values = extendedProperties.getStringArray((String)name);
            logger.trace((Object)((String)name + " = " + (StringUtils.containsIgnoreCase((String)name, (String)"password") ? "***" : PropertiesHandler.getArrayString(values))));
        }
    }

    private static String getArrayString(String[] values) {
        if (values == null) {
            return null;
        }
        Object s = "";
        String c = ", ";
        for (String value : values) {
            s = (String)s + c + "\"" + StringUtils.trimToEmpty((String)value) + "\"";
        }
        return "{" + StringUtils.removeStart((String)s, (String)c) + "}";
    }

    private static Charset preferredFileEncoding() {
        return PropertiesHandler.getCharset(PREFERRED_FILE_ENCODING_KEY);
    }

    private static File rootFolder() {
        File file;
        String pathname = PropertiesHandler.getPath(ROOT_FOLDER_KEY);
        if (StringUtils.isBlank((String)pathname)) {
            pathname = FilUtils.getWorkspaceFolderPath();
            if (StringUtils.isBlank((String)pathname)) {
                PropertiesHandler.logMissingProperty(ROOT_FOLDER_KEY);
                return null;
            }
            PropertiesHandler.logMissingProperty(ROOT_FOLDER_KEY, pathname);
        }
        if (FilUtils.isNotVisibleDirectory(file = new File(pathname))) {
            PropertiesHandler.logInvalidDirectory(ROOT_FOLDER_KEY, pathname);
            return null;
        }
        return file;
    }

    private static File velocityPropertiesFile() {
        File file;
        Object pathname = PropertiesHandler.getPath(VELOCITY_FILE_KEY);
        if (StringUtils.isBlank((String)pathname)) {
            pathname = USER_DIR + FILE_SEP + "velocity.properties";
            PropertiesHandler.logMissingProperty(VELOCITY_FILE_KEY, (String)pathname);
        }
        if (FilUtils.isNotVisibleFile(file = new File((String)pathname))) {
            PropertiesHandler.logInvalidFile(VELOCITY_FILE_KEY, (String)pathname);
            return null;
        }
        return file;
    }

    private static File velocitySupplementaryPropertiesFile() {
        File file;
        Object pathname = PropertiesHandler.getPath(VELOCITY_SUP_FILE_KEY);
        if (StringUtils.isBlank((String)pathname)) {
            pathname = velocity_properties_file == null ? USER_DIR + FILE_SEP + "velocity.supplementary.properties" : velocity_properties_file.getParent() + FILE_SEP + "velocity.supplementary.properties";
            PropertiesHandler.logMissingProperty(VELOCITY_SUP_FILE_KEY, (String)pathname);
        }
        if (FilUtils.isNotVisibleFile(file = new File((String)pathname))) {
            PropertiesHandler.logInvalidFile(VELOCITY_SUP_FILE_KEY, (String)pathname);
            return null;
        }
        return file;
    }

    private static File[] velocityFolders() {
        String[] pathnames;
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(USER_VELOCITY_RESOURCES_DIR);
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
        }
        if (FilUtils.isVisibleDirectory(file)) {
            files.add(file);
        }
        if ((pathnames = PropertiesHandler.getPathArray(VELOCITY_FOLDER_KEY)) != null && pathnames.length > 0) {
            for (String pathname : pathnames) {
                file = new File(pathname);
                if (FilUtils.isVisibleDirectory(file)) {
                    files.add(file);
                    continue;
                }
                PropertiesHandler.logInvalidDirectory(VELOCITY_FOLDER_KEY, pathname);
            }
        }
        if (files.isEmpty()) {
            PropertiesHandler.logMissingProperty(VELOCITY_FOLDER_KEY);
            return null;
        }
        return files.toArray((File[])ArrUtils.arrayOf(File.class));
    }

    private static File[] platformsFolders() {
        if (velocity_folders == null || velocity_folders.length == 0) {
            return null;
        }
        String platforms = "platforms";
        ArrayList<File> files = new ArrayList<File>();
        for (File folder : velocity_folders) {
            File file = new File(folder.getPath() + FILE_SEP + platforms);
            if (!FilUtils.isVisibleDirectory(file)) continue;
            files.add(file);
        }
        if (files.isEmpty()) {
            PropertiesHandler.logMissingDirectory(VELOCITY_FOLDER_KEY, platforms);
            return null;
        }
        return files.toArray((File[])ArrUtils.arrayOf(File.class));
    }

    private static Charset getCharset(String key) {
        return PropertiesHandler.getCharset(key, Charset.defaultCharset());
    }

    private static Charset getCharset(String key, Charset defaultValue) {
        Charset charset = defaultValue;
        Level level = Level.DEBUG;
        String charsetName = bootstrapping.getString(key);
        if (StringUtils.isNotBlank((String)charsetName)) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (Exception ex) {
                logger.error((Object)(key + " " + String.valueOf(ex)));
                level = Level.WARN;
            }
        }
        logger.log((Priority)level, (Object)(key + "=" + String.valueOf(charset)));
        return charset;
    }

    private static String getPath(String key) {
        String pathname = FilUtils.fixPath(bootstrapping.getString(key));
        return pathname;
    }

    private static String[] getPathArray(String key) {
        String[] strings = bootstrapping.getStringArray(key);
        if (strings == null || strings.length == 0) {
            return null;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String string : strings) {
            String path = FilUtils.fixPath(string);
            if (!StringUtils.isNotBlank((String)path)) continue;
            set.add(path);
        }
        return set.toArray((String[])ArrUtils.arrayOf(String.class));
    }

    private static void logMissingProperty(String key) {
        if (bootstrapping != null && !bootstrapping.isEmpty()) {
            String pattern = "property \"{0}\" is missing from file \"{1}\"";
            String message = MessageFormat.format(pattern, key, BOOTSTRAPPING_FILE_NAME);
            logger.error((Object)message);
        }
    }

    private static void logMissingProperty(String key, String value) {
        if (bootstrapping != null && !bootstrapping.isEmpty()) {
            String pattern = "property \"{0}\" is missing from file \"{1}\"; default is \"{2}\"";
            String message = MessageFormat.format(pattern, key, BOOTSTRAPPING_FILE_NAME, value);
            logger.warn((Object)message);
        }
    }

    private static void logMissingDirectory(String key, String pathname) {
        if (bootstrapping != null && !bootstrapping.isEmpty()) {
            String pattern = "unable to find a valid \"{0}\" directory, check property \"{1}\" at file \"{2}\"";
            String message = MessageFormat.format(pattern, pathname, key, BOOTSTRAPPING_FILE_NAME);
            logger.error((Object)message);
        }
    }

    private static void logInvalidDirectory(String key, String pathname) {
        if (bootstrapping != null && !bootstrapping.isEmpty()) {
            String pattern = "\"{0}\" is not a valid directory, check property \"{1}\" at file \"{2}\"";
            String message = MessageFormat.format(pattern, pathname, key, BOOTSTRAPPING_FILE_NAME);
            logger.error((Object)message);
        }
    }

    private static void logInvalidFile(String key, String pathname) {
        if (bootstrapping != null && !bootstrapping.isEmpty()) {
            String pattern = "\"{0}\" is not a valid file, check property \"{1}\" at file \"{2}\"";
            String message = MessageFormat.format(pattern, pathname, key, BOOTSTRAPPING_FILE_NAME);
            logger.error((Object)message);
        }
    }

    public static Charset getPreferredFileEncoding() {
        return preferred_file_encoding;
    }

    public static File getRootFolder() {
        return root_folder;
    }

    public static File[] getVelocityFolders() {
        return velocity_folders;
    }

    public static File getVelocityPropertiesFile() {
        return velocity_properties_file;
    }

    public static File getVelocitySupplementaryPropertiesFile() {
        return velocity_supplementary_properties_file;
    }

    public static File[] getPlatformsFolders() {
        return platforms_folders;
    }
}

