/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class SortedProperties
extends Properties {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public synchronized Enumeration<Object> keys() {
        Enumeration<Object> keys = super.keys();
        ArrayList<Object> list = new ArrayList<Object>();
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        Collections.sort(list);
        return Collections.enumeration(list);
    }

    public Set<String> stringPropertyNamesSortedList() {
        return new TreeSet<String>(super.stringPropertyNames());
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.store(writer, comments, null);
    }

    public void store(Writer writer, String comments, String lineSeparator) throws IOException {
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.store(bw, comments, lineSeparator, false);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.store(out, comments, null);
    }

    public void store(OutputStream out, String comments, String lineSeparator) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "8859_1");
        BufferedWriter bw = new BufferedWriter(writer);
        this.store(bw, comments, lineSeparator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(BufferedWriter bw, String comments, String lineSeparator, boolean escUnicode) throws IOException {
        if (comments != null) {
            SortedProperties.writeComments(bw, comments);
        }
        SortedProperties sortedProperties = this;
        synchronized (sortedProperties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)this.get(key);
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                if (lineSeparator == null) {
                    bw.newLine();
                    continue;
                }
                bw.write(lineSeparator);
            }
        }
        bw.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SortedProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SortedProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = SortedProperties.toHex(c >> 12 & 0xF);
                uu[3] = SortedProperties.toHex(c >> 8 & 0xF);
                uu[4] = SortedProperties.toHex(c >> 4 & 0xF);
                uu[5] = SortedProperties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

