/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogUtils {
    public static Level check(Level level, Level defaultLevel, Level maxLevel) {
        Level coalesced = LogUtils.coalesce(level, defaultLevel);
        return LogUtils.fair(coalesced) && LogUtils.fair(maxLevel) ? LogUtils.minimum(coalesced, maxLevel) : Level.OFF;
    }

    public static Level coalesce(Level level1, Level level2) {
        return level1 == null ? level2 : level1;
    }

    public static boolean fair(Level level) {
        return level != null && !level.equals((Object)Level.OFF) && !level.equals((Object)Level.ALL);
    }

    public static boolean foul(Level level) {
        return !LogUtils.fair(level);
    }

    public static boolean fair(Logger logger, Level level) {
        return logger != null && LogUtils.fair(level) && logger.isEnabledFor((Priority)level);
    }

    public static boolean foul(Logger logger, Level level) {
        return !LogUtils.fair(logger, level);
    }

    public static Level maximum(Level level1, Level level2) {
        Level l2;
        Level l1 = LogUtils.coalesce(level1, Level.ALL);
        return l1.isGreaterOrEqual((Priority)(l2 = LogUtils.coalesce(level2, Level.ALL))) ? l1 : l2;
    }

    public static Level minimum(Level level1, Level level2) {
        Level l2;
        Level l1 = LogUtils.coalesce(level1, Level.OFF);
        return l1.isGreaterOrEqual((Priority)(l2 = LogUtils.coalesce(level2, Level.OFF))) ? l2 : l1;
    }
}

