/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.bundles.Bundle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NumUtils {
    private static final String BUNDLE_KEY_PREFIX = NumUtils.class.getName() + ".";
    private static final Map<Locale, String> _decimalSeparatorMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _thousandSeparatorMap = new LinkedHashMap<Locale, String>();

    public static String getDecimalSeparator() {
        Locale locale = Bundle.getLocale();
        if (_decimalSeparatorMap.containsKey(locale)) {
            return _decimalSeparatorMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "decimal.separator.char");
        return StringUtils.defaultIfBlank((String)string, (String)".");
    }

    public static void setDecimalSeparator(Locale locale, char separator) {
        if (locale != null) {
            if (separator == ' ') {
                _decimalSeparatorMap.remove(locale);
            } else {
                _decimalSeparatorMap.put(locale, "" + separator);
            }
        }
    }

    public static String getThousandSeparator() {
        Locale locale = Bundle.getLocale();
        if (_thousandSeparatorMap.containsKey(locale)) {
            return _thousandSeparatorMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "thousand.separator.char");
        return StringUtils.defaultIfBlank((String)string, (String)",");
    }

    public static void setThousandSeparator(Locale locale, char separator) {
        if (locale != null) {
            if (separator == ' ') {
                _thousandSeparatorMap.remove(locale);
            } else {
                _thousandSeparatorMap.put(locale, "" + separator);
            }
        }
    }

    public static String format(Number number) {
        return NumUtils.format(number, Locale.getDefault());
    }

    public static String format(Number number, Locale locale) {
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        if (number instanceof BigDecimal) {
            BigDecimal big = (BigDecimal)number;
            formatter.setMaximumFractionDigits(big.scale());
        }
        return formatter.format(number);
    }

    public static Number parse(String value) {
        return NumUtils.parse(value, false);
    }

    public static Number parse(String value, boolean integerOnly) {
        return NumUtils.parse(value, integerOnly, Locale.getDefault());
    }

    public static Number parse(String value, boolean integerOnly, Locale locale) {
        int l;
        NumberFormat parser = NumberFormat.getNumberInstance(locale);
        parser.setParseIntegerOnly(integerOnly);
        if (parser instanceof DecimalFormat) {
            DecimalFormat decimalParser = (DecimalFormat)parser;
            decimalParser.setParseBigDecimal(true);
        }
        ParsePosition position = new ParsePosition(0);
        Number number = parser.parse(value, position);
        int i = position.getIndex();
        return i < (l = value.length()) ? (Number)null : (Number)number;
    }

    public static Number ceiling(Number dividend, int divisor) {
        return dividend == null || divisor == 0 ? (Number)dividend : (Number)(dividend instanceof Byte ? (Number)NumUtils.ceiling((Byte)dividend, divisor) : (Number)(dividend instanceof Short ? (Number)NumUtils.ceiling((Short)dividend, divisor) : (Number)(dividend instanceof Integer ? (Number)NumUtils.ceiling((Integer)dividend, divisor) : (Number)(dividend instanceof Long ? (Number)NumUtils.ceiling((Long)dividend, divisor) : (Number)(dividend instanceof Float ? (Number)NumUtils.ceiling((Float)dividend, divisor) : (Number)(dividend instanceof Double ? (Number)NumUtils.ceiling((Double)dividend, divisor) : (Number)(dividend instanceof BigInteger ? NumUtils.ceiling((BigInteger)dividend, divisor) : (dividend instanceof BigDecimal ? NumUtils.ceiling((BigDecimal)dividend, divisor) : null))))))));
    }

    public static Byte ceiling(Byte dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        int factor = dividend / divisor + 1;
        int product = factor * divisor;
        return product < -128 || product > 127 ? dividend : (byte)product;
    }

    public static Short ceiling(Short dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        int factor = dividend / divisor + 1;
        int product = factor * divisor;
        return product < Short.MIN_VALUE || product > Short.MAX_VALUE ? dividend : (short)product;
    }

    public static Integer ceiling(Integer dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        long factor = dividend / divisor + 1;
        long product = factor * (long)divisor;
        return product < Integer.MIN_VALUE || product > Integer.MAX_VALUE ? dividend : (int)product;
    }

    public static Long ceiling(Long dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % (long)divisor == 0L) {
            return dividend;
        }
        long factor = dividend / (long)divisor + 1L;
        long limit = Long.signum(factor) == Integer.signum(divisor) ? Long.MAX_VALUE : Long.MIN_VALUE;
        boolean overflow = factor > 0L && factor > limit / (long)divisor || factor < 0L && factor < limit / (long)divisor;
        long product = overflow ? dividend : factor * (long)divisor;
        return product;
    }

    public static Float ceiling(Float dividend, int divisor) {
        if (dividend == null || divisor == 0 || dividend.floatValue() % (float)divisor == 0.0f) {
            return dividend;
        }
        double factor = Math.floor(dividend.floatValue() / (float)divisor) + 1.0;
        double product = factor * (double)divisor;
        return Float.valueOf(product < (double)1.4E-45f || product > 3.4028234663852886E38 ? dividend.floatValue() : (float)product);
    }

    public static Double ceiling(Double dividend, int divisor) {
        if (dividend == null || divisor == 0 || dividend % (double)divisor == 0.0) {
            return dividend;
        }
        double factor = Math.floor(dividend / (double)divisor) + 1.0;
        double limit = Math.signum(factor) == (double)Integer.signum(divisor) ? Double.MAX_VALUE : Double.MIN_VALUE;
        boolean overflow = factor > 0.0 && factor > limit / (double)divisor || factor < 0.0 && factor < limit / (double)divisor;
        double product = overflow ? dividend : factor * (double)divisor;
        return product;
    }

    public static BigInteger ceiling(BigInteger dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        BigInteger denominator = BigInteger.valueOf(divisor);
        if (dividend.remainder(denominator).equals(BigInteger.ZERO)) {
            return dividend;
        }
        BigInteger factor = dividend.divide(denominator).add(BigInteger.ONE);
        BigInteger product = factor.multiply(denominator);
        return product;
    }

    public static BigDecimal ceiling(BigDecimal dividend, int divisor) {
        if (dividend == null || divisor == 0) {
            return dividend;
        }
        BigDecimal denominator = BigDecimal.valueOf(divisor);
        if (dividend.remainder(denominator).compareTo(BigDecimal.ZERO) == 0) {
            return dividend;
        }
        BigDecimal factor = dividend.divideToIntegralValue(denominator).add(BigDecimal.ONE);
        BigDecimal product = factor.multiply(denominator);
        return product;
    }

    public static Number floor(Number dividend, int divisor) {
        return dividend == null || divisor == 0 ? (Number)dividend : (Number)(dividend instanceof Byte ? (Number)NumUtils.floor((Byte)dividend, divisor) : (Number)(dividend instanceof Short ? (Number)NumUtils.floor((Short)dividend, divisor) : (Number)(dividend instanceof Integer ? (Number)NumUtils.floor((Integer)dividend, divisor) : (Number)(dividend instanceof Long ? (Number)NumUtils.floor((Long)dividend, divisor) : (Number)(dividend instanceof Float ? (Number)NumUtils.floor((Float)dividend, divisor) : (Number)(dividend instanceof Double ? (Number)NumUtils.floor((Double)dividend, divisor) : (Number)(dividend instanceof BigInteger ? NumUtils.floor((BigInteger)dividend, divisor) : (dividend instanceof BigDecimal ? NumUtils.floor((BigDecimal)dividend, divisor) : null))))))));
    }

    public static Byte floor(Byte dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        int factor = dividend / divisor;
        int product = factor * divisor;
        return product < -128 || product > 127 ? dividend : (byte)product;
    }

    public static Short floor(Short dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        int factor = dividend / divisor;
        int product = factor * divisor;
        return product < Short.MIN_VALUE || product > Short.MAX_VALUE ? dividend : (short)product;
    }

    public static Integer floor(Integer dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % divisor == 0) {
            return dividend;
        }
        long factor = dividend / divisor;
        long product = factor * (long)divisor;
        return product < Integer.MIN_VALUE || product > Integer.MAX_VALUE ? dividend : (int)product;
    }

    public static Long floor(Long dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1 || dividend % (long)divisor == 0L) {
            return dividend;
        }
        long factor = dividend / (long)divisor;
        long limit = Long.signum(factor) == Integer.signum(divisor) ? Long.MAX_VALUE : Long.MIN_VALUE;
        boolean overflow = factor > 0L && factor > limit / (long)divisor || factor < 0L && factor < limit / (long)divisor;
        long product = overflow ? dividend : factor * (long)divisor;
        return product;
    }

    public static Float floor(Float dividend, int divisor) {
        if (dividend == null || divisor == 0 || dividend.floatValue() % (float)divisor == 0.0f) {
            return dividend;
        }
        double factor = Math.floor(dividend.floatValue() / (float)divisor);
        double product = factor * (double)divisor;
        return Float.valueOf(product < (double)1.4E-45f || product > 3.4028234663852886E38 ? dividend.floatValue() : (float)product);
    }

    public static Double floor(Double dividend, int divisor) {
        if (dividend == null || divisor == 0 || dividend % (double)divisor == 0.0) {
            return dividend;
        }
        double factor = Math.floor(dividend / (double)divisor);
        double limit = Math.signum(factor) == (double)Integer.signum(divisor) ? Double.MAX_VALUE : Double.MIN_VALUE;
        boolean overflow = factor > 0.0 && factor > limit / (double)divisor || factor < 0.0 && factor < limit / (double)divisor;
        double product = overflow ? dividend : factor * (double)divisor;
        return product;
    }

    public static BigInteger floor(BigInteger dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        BigInteger denominator = BigInteger.valueOf(divisor);
        if (dividend.remainder(denominator).equals(BigInteger.ZERO)) {
            return dividend;
        }
        BigInteger factor = dividend.divide(denominator);
        BigInteger product = factor.multiply(denominator);
        return product;
    }

    public static BigDecimal floor(BigDecimal dividend, int divisor) {
        if (dividend == null || divisor == 0) {
            return dividend;
        }
        BigDecimal denominator = BigDecimal.valueOf(divisor);
        if (dividend.remainder(denominator).compareTo(BigDecimal.ZERO) == 0) {
            return dividend;
        }
        BigDecimal factor = dividend.divideToIntegralValue(denominator);
        BigDecimal product = factor.multiply(denominator);
        return product;
    }

    public static Number round(Number dividend, int divisor) {
        return dividend == null || divisor == 0 ? (Number)dividend : (Number)(dividend instanceof Byte ? (Number)NumUtils.round((Byte)dividend, divisor) : (Number)(dividend instanceof Short ? (Number)NumUtils.round((Short)dividend, divisor) : (Number)(dividend instanceof Integer ? (Number)NumUtils.round((Integer)dividend, divisor) : (Number)(dividend instanceof Long ? (Number)NumUtils.round((Long)dividend, divisor) : (Number)(dividend instanceof Float ? (Number)NumUtils.round((Float)dividend, divisor) : (Number)(dividend instanceof Double ? (Number)NumUtils.round((Double)dividend, divisor) : (Number)(dividend instanceof BigInteger ? NumUtils.round((BigInteger)dividend, divisor) : (dividend instanceof BigDecimal ? NumUtils.round((BigDecimal)dividend, divisor) : null))))))));
    }

    public static Byte round(Byte dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        int remainder = dividend % divisor;
        int threshold = divisor / 2;
        return remainder == 0 ? dividend : (remainder <= threshold ? NumUtils.floor(dividend, divisor) : NumUtils.ceiling(dividend, divisor));
    }

    public static Short round(Short dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        int remainder = dividend % divisor;
        int threshold = divisor / 2;
        return remainder == 0 ? dividend : (remainder <= threshold ? NumUtils.floor(dividend, divisor) : NumUtils.ceiling(dividend, divisor));
    }

    public static Integer round(Integer dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        int remainder = dividend % divisor;
        int threshold = divisor / 2;
        return remainder == 0 ? dividend : (remainder <= threshold ? NumUtils.floor(dividend, divisor) : NumUtils.ceiling(dividend, divisor));
    }

    public static Long round(Long dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        long remainder = dividend % (long)divisor;
        long threshold = divisor / 2;
        return remainder == 0L ? dividend : (remainder <= threshold ? NumUtils.floor(dividend, divisor) : NumUtils.ceiling(dividend, divisor));
    }

    public static Float round(Float dividend, int divisor) {
        if (dividend == null || divisor == 0) {
            return dividend;
        }
        double numerator = Math.rint(dividend.floatValue());
        double remainder = numerator % (double)divisor;
        float fp = (float)numerator;
        if (remainder == 0.0) {
            return Float.valueOf(fp);
        }
        long threshold = divisor / 2;
        return (long)remainder <= threshold ? NumUtils.floor(Float.valueOf(fp), divisor) : NumUtils.ceiling(Float.valueOf(fp), divisor);
    }

    public static Double round(Double dividend, int divisor) {
        if (dividend == null || divisor == 0) {
            return dividend;
        }
        double numerator = Math.rint(dividend);
        double remainder = numerator % (double)divisor;
        if (remainder == 0.0) {
            return numerator;
        }
        long threshold = divisor / 2;
        return (long)remainder <= threshold ? NumUtils.floor(numerator, divisor) : NumUtils.ceiling(numerator, divisor);
    }

    public static BigInteger round(BigInteger dividend, int divisor) {
        if (dividend == null || divisor == 0 || divisor == 1) {
            return dividend;
        }
        BigInteger remainder = dividend.remainder(BigInteger.valueOf(divisor));
        long threshold = divisor / 2;
        return remainder.equals(BigInteger.ZERO) ? dividend : (remainder.longValue() <= threshold ? NumUtils.floor(dividend, divisor) : NumUtils.ceiling(dividend, divisor));
    }

    public static BigDecimal round(BigDecimal dividend, int divisor) {
        if (dividend == null || divisor == 0) {
            return dividend;
        }
        BigDecimal numerator = dividend.setScale(0, RoundingMode.HALF_UP).setScale(dividend.scale());
        BigDecimal remainder = numerator.remainder(BigDecimal.valueOf(divisor));
        long threshold = divisor / 2;
        return remainder.compareTo(BigDecimal.ZERO) == 0 ? numerator : (remainder.longValue() <= threshold ? NumUtils.floor(numerator, divisor) : NumUtils.ceiling(numerator, divisor));
    }

    public static boolean multiple(Number dividend, int divisor) {
        return dividend == null || divisor == 0 ? false : (dividend instanceof Byte ? NumUtils.multiple((Byte)dividend, divisor) : (dividend instanceof Short ? NumUtils.multiple((Short)dividend, divisor) : (dividend instanceof Integer ? NumUtils.multiple((Integer)dividend, divisor) : (dividend instanceof Long ? NumUtils.multiple((Long)dividend, divisor) : (dividend instanceof Float ? NumUtils.multiple((Float)dividend, divisor) : (dividend instanceof Double ? NumUtils.multiple((Double)dividend, divisor) : (dividend instanceof BigInteger ? NumUtils.multiple((BigInteger)dividend, divisor) : (dividend instanceof BigDecimal ? NumUtils.multiple((BigDecimal)dividend, divisor) : true))))))));
    }

    public static boolean multiple(Byte dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend % divisor == 0;
    }

    public static boolean multiple(Short dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend % divisor == 0;
    }

    public static boolean multiple(Integer dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend % divisor == 0;
    }

    public static boolean multiple(Long dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend % (long)divisor == 0L;
    }

    public static boolean multiple(Float dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend.floatValue() % (float)divisor == 0.0f;
    }

    public static boolean multiple(Double dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend % (double)divisor == 0.0;
    }

    public static boolean multiple(BigInteger dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend.remainder(BigInteger.valueOf(divisor)).equals(BigInteger.ZERO);
    }

    public static boolean multiple(BigDecimal dividend, int divisor) {
        return dividend != null && divisor != 0 && dividend.remainder(BigDecimal.valueOf(divisor)).compareTo(BigDecimal.ZERO) == 0;
    }

    public static Byte newByte(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return pdq;
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Byte.valueOf(pdq);
        }
        return Byte.valueOf(obj.toString());
    }

    public static Short newShort(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return pdq;
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Short.valueOf(pdq);
        }
        return Short.valueOf(obj.toString());
    }

    public static Integer newInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return pdq.intValue();
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return pdq.intValue();
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return pdq;
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return pdq.intValue();
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return pdq.intValue();
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return pdq.intValue();
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return pdq.intValue();
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return pdq.intValue();
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Integer.valueOf(pdq);
        }
        return Integer.valueOf(obj.toString());
    }

    public static Long newLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return pdq.longValue();
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return pdq.longValue();
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return pdq.longValue();
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return pdq;
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return pdq.longValue();
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return pdq.longValue();
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return pdq.longValue();
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return pdq.longValue();
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Long.valueOf(pdq);
        }
        return Long.valueOf(obj.toString());
    }

    public static Float newFloat(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return pdq;
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return Float.valueOf(pdq.floatValue());
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Float.valueOf(pdq);
        }
        return Float.valueOf(obj.toString());
    }

    public static Double newDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return pdq;
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return pdq.doubleValue();
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : Double.valueOf(pdq);
        }
        return Double.valueOf(obj.toString());
    }

    public static BigInteger newBigInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return BigInteger.valueOf(pdq);
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return BigInteger.ZERO.add(pdq);
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return BigInteger.valueOf(pdq.longValue());
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : new BigInteger(pdq);
        }
        return new BigInteger(obj.toString());
    }

    public static BigDecimal newBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            Byte pdq = (Byte)obj;
            return new BigDecimal(pdq.intValue());
        }
        if (obj instanceof Short) {
            Short pdq = (Short)obj;
            return new BigDecimal(pdq.intValue());
        }
        if (obj instanceof Integer) {
            Integer pdq = (Integer)obj;
            return new BigDecimal(pdq);
        }
        if (obj instanceof Long) {
            Long pdq = (Long)obj;
            return new BigDecimal(pdq);
        }
        if (obj instanceof Float) {
            Float pdq = (Float)obj;
            return new BigDecimal(pdq.doubleValue());
        }
        if (obj instanceof Double) {
            Double pdq = (Double)obj;
            return new BigDecimal(pdq);
        }
        if (obj instanceof BigInteger) {
            BigInteger pdq = (BigInteger)obj;
            return new BigDecimal(pdq);
        }
        if (obj instanceof BigDecimal) {
            BigDecimal pdq = (BigDecimal)obj;
            return BigDecimal.ZERO.add(pdq);
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return pdq.trim().isEmpty() ? null : new BigDecimal(pdq);
        }
        return new BigDecimal(obj.toString());
    }

    public static Byte numberToByte(Object obj) {
        return obj instanceof Number ? NumUtils.newByte(obj) : null;
    }

    public static Short numberToShort(Object obj) {
        return obj instanceof Number ? NumUtils.newShort(obj) : null;
    }

    public static Integer numberToInteger(Object obj) {
        return obj instanceof Number ? NumUtils.newInteger(obj) : null;
    }

    public static Long numberToLong(Object obj) {
        return obj instanceof Number ? NumUtils.newLong(obj) : null;
    }

    public static Float numberToFloat(Object obj) {
        return obj instanceof Number ? NumUtils.newFloat(obj) : null;
    }

    public static Double numberToDouble(Object obj) {
        return obj instanceof Number ? NumUtils.newDouble(obj) : null;
    }

    public static BigInteger numberToBigInteger(Object obj) {
        return obj instanceof Number ? NumUtils.newBigInteger(obj) : null;
    }

    public static BigDecimal numberToBigDecimal(Object obj) {
        return obj instanceof Number ? NumUtils.newBigDecimal(obj) : null;
    }

    public static Number toNumber(Object object, Class<? extends Number> targetClass) {
        if (object == null) {
            return null;
        }
        Class<?> sourceClass = object.getClass();
        if (targetClass == null || targetClass.isAssignableFrom(sourceClass)) {
            return (Number)object;
        }
        if (targetClass.equals(Byte.class)) {
            return NumUtils.toByte(object);
        }
        if (targetClass.equals(Short.class)) {
            return NumUtils.toShort(object);
        }
        if (targetClass.equals(Integer.class)) {
            return NumUtils.toInteger(object);
        }
        if (targetClass.equals(Long.class)) {
            return NumUtils.toLong(object);
        }
        if (targetClass.equals(Float.class)) {
            return NumUtils.toFloat(object);
        }
        if (targetClass.equals(Double.class)) {
            return NumUtils.toDouble(object);
        }
        if (targetClass.equals(BigInteger.class)) {
            return NumUtils.toBigInteger(object);
        }
        if (targetClass.equals(BigDecimal.class)) {
            return NumUtils.toBigDecimal(object);
        }
        return (Number)object;
    }

    public static Byte toByte(Object obj) {
        return obj == null ? null : (obj instanceof Byte ? (Byte)obj : NumUtils.newByte(obj));
    }

    public static Short toShort(Object obj) {
        return obj == null ? null : (obj instanceof Short ? (Short)obj : NumUtils.newShort(obj));
    }

    public static Integer toInteger(Object obj) {
        return obj == null ? null : (obj instanceof Integer ? (Integer)obj : NumUtils.newInteger(obj));
    }

    public static Long toLong(Object obj) {
        return obj == null ? null : (obj instanceof Long ? (Long)obj : NumUtils.newLong(obj));
    }

    public static Float toFloat(Object obj) {
        return obj == null ? null : (obj instanceof Float ? (Float)obj : NumUtils.newFloat(obj));
    }

    public static Double toDouble(Object obj) {
        return obj == null ? null : (obj instanceof Double ? (Double)obj : NumUtils.newDouble(obj));
    }

    public static BigInteger toBigInteger(Object obj) {
        return obj == null ? null : (obj instanceof BigInteger ? (BigInteger)obj : NumUtils.newBigInteger(obj));
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return obj == null ? null : (obj instanceof BigDecimal ? (BigDecimal)obj : NumUtils.newBigDecimal(obj));
    }
}

