/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.TLB;
import adalid.commons.bundles.Bundle;
import adalid.commons.interfaces.Wrappable;
import adalid.commons.interfaces.Wrapper;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.KVP;
import adalid.commons.util.LogUtils;
import adalid.commons.util.MarkupUtils;
import adalid.commons.util.ObjUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.core.Bootstrapping;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.XS1;
import adalid.core.enums.ExpressionUsage;
import adalid.core.enums.InlineHelpType;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.wrappers.ArtifactWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractArtifact
implements Artifact,
Wrappable {
    public static final Locale ENGLISH = Bundle.ENGLISH;
    public static final Locale SPANISH = Bundle.SPANISH;
    public static final Locale PORTUGUESE = Bundle.PORTUGUESE;
    private static final String NBSP = "\u00a0";
    private static final Logger logger = Logger.getLogger(Artifact.class);
    private static final String EOL = "\n";
    private boolean _declared;
    private Boolean _inherited;
    private Boolean _inheritedFromAbstract;
    private Boolean _inheritedFromConcrete;
    private boolean _finalised;
    private boolean _finished;
    private String _name;
    private String _alias;
    private String _trace;
    private String _sqlName;
    private Locale _defaultLocale;
    private InlineHelpType _inlineHelpType;
    private final Map<Locale, String> _localizedLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedShortLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedColumnHeader = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedCollectionLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedCollectionShortLabel = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedDescription = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedShortDescription = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedTooltip = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedSymbol = new LinkedHashMap<Locale, String>();
    private Artifact _declaringArtifact;
    private Field _declaringField;
    private int _declaringFieldIndex;
    private int _depth;
    private int _round;
    private final Map<Class<? extends Annotation>, Field> _annotations = new LinkedHashMap<Class<? extends Annotation>, Field>();
    private final Map<String, Object> _attributes = new LinkedHashMap<String, Object>();
    private boolean _annotated;
    private boolean _checkScope;
    private static final String UNSPECIFIED = "UNSPECIFIED";
    private Wrapper _wrapper;
    protected static final String BR = "\n";
    protected static final String HT = "\t";
    protected static final String FWGTS = "\uff1e";
    protected static final String FWLTS = "\uff1c";
    protected static final String _de_ = " de ";
    protected static final String _of_ = " of ";

    @Override
    public boolean isDeclared() {
        return this._declared;
    }

    @Override
    public boolean isNotDeclared() {
        return !this._declared;
    }

    void setDeclared(String name) {
        this.setDeclared(name, null);
    }

    void setDeclared(String name, Artifact declaringArtifact) {
        this.setDeclared(name, declaringArtifact, null);
    }

    void setDeclared(String name, Artifact declaringArtifact, Field declaringField) {
        this.setDeclared(name, declaringArtifact, declaringField, 0);
    }

    void setDeclared(String name, Artifact declaringArtifact, Field declaringField, int declaringFieldIndex) {
        if (this._declared) {
            return;
        }
        this.setName(name);
        this.setDeclaringArtifact(declaringArtifact);
        this.setDeclaringField(declaringField);
        this.setDeclaringFieldIndex(declaringFieldIndex);
        this._declared = true;
    }

    @Override
    public boolean isFinalised() {
        return this._finalised;
    }

    @Override
    public boolean finalise() {
        if (this._finalised) {
            logger.warn((Object)(this.getFullName() + " already finalised! "));
            Project.increaseParserWarningCount();
            return false;
        }
        this.checkName();
        this._finalised = true;
        return this._finalised;
    }

    @Override
    public boolean isFinished() {
        return this._finished;
    }

    @Override
    public boolean finish() {
        if (this._finished) {
            logger.warn((Object)(this.getFullName() + " already finished! "));
            Project.increaseParserWarningCount();
            return false;
        }
        this._finished = true;
        return this._finished;
    }

    protected boolean checkName() {
        String name = this.getName();
        if (StringUtils.isBlank((String)name)) {
            logger.error((Object)"missing artifact name");
            Project.increaseParserErrorCount();
        } else if (name.length() < 2) {
            logger.error((Object)(this.getFullName() + " must be renamed; " + name + " is too short an artifact name"));
            Project.increaseParserErrorCount();
        } else if (!name.matches("^[a-zA-Z]\\w*$")) {
            logger.error((Object)(this.getFullName() + " must be renamed; " + name + " is an invalid artifact name"));
            Project.increaseParserErrorCount();
        } else if (name.matches("^[a-z][A-Z].*$")) {
            logger.error((Object)(this.getFullName() + " must be renamed; " + name + " is an invalid artifact name (begins with [a-z][A-Z])"));
            Project.increaseParserErrorCount();
        } else if (name.matches("^[A-Z][A-Z]+[a-z].*$")) {
            logger.error((Object)(this.getFullName() + " must be renamed; " + name + " is an invalid artifact name (begins with [A-Z][A-Z]+[a-z])"));
            Project.increaseParserErrorCount();
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isInherited() {
        return this._declared && this.inherited();
    }

    @Override
    public boolean isNotInherited() {
        return this._declared && !this.inherited();
    }

    private boolean inherited() {
        if (this._inherited == null) {
            Field declaringField = this.getDeclaringField();
            Artifact declaringArtifact = this.getDeclaringArtifact();
            Class<?> declaringFieldClass = declaringField.getDeclaringClass();
            Class<?> declaringFieldNamedClass = XS1.getNamedClass(declaringFieldClass);
            Class<?> declaringArtifactNamedClass = XS1.getNamedClass(declaringArtifact);
            String declaringFieldNamedClassSimpleName = declaringFieldNamedClass.getSimpleName();
            String declaringArtifactNamedClassSimpleName = declaringArtifactNamedClass.getSimpleName();
            boolean fromAbstract = Modifier.isAbstract(declaringFieldNamedClass.getModifiers());
            boolean fromConcrete = !fromAbstract;
            this._inherited = !declaringFieldNamedClassSimpleName.equals(declaringArtifactNamedClassSimpleName);
            this._inheritedFromAbstract = this._inherited != false && fromAbstract;
            this._inheritedFromConcrete = this._inherited != false && fromConcrete;
        }
        return this._inherited;
    }

    @Override
    public boolean isInheritedFromAbstract() {
        return this.isInherited() && this._inheritedFromAbstract != false;
    }

    @Override
    public boolean isNotInheritedFromAbstract() {
        return !this.isInheritedFromAbstract();
    }

    @Override
    public boolean isInheritedFromConcrete() {
        return this.isInherited() && this._inheritedFromConcrete != false;
    }

    @Override
    public boolean isNotInheritedFromConcrete() {
        return !this.isInheritedFromConcrete();
    }

    @Override
    public String getName() {
        return this._name;
    }

    void setName(String name) {
        if (this._declared) {
            return;
        }
        this._name = name;
    }

    @Override
    public String getAlias() {
        return this._alias == null ? this._name : this._alias;
    }

    @Override
    public void setAlias(String alias) {
        this.checkScope();
        this._alias = alias;
    }

    public String getTrace() {
        return this._trace == null ? "" : this._trace.trim();
    }

    public void setTrace(String trace) {
        this.checkScope();
        this._trace = trace;
    }

    @Override
    public String getSqlName() {
        return this._sqlName;
    }

    @Override
    public void setSqlName(String sqlName) {
        this.checkScope();
        this._sqlName = sqlName;
    }

    @Override
    public Locale getDefaultLocale() {
        if (this._defaultLocale != null) {
            return this._defaultLocale;
        }
        if (this._declaringArtifact != null) {
            return this._declaringArtifact.getDefaultLocale();
        }
        return Bundle.getLocale();
    }

    public InlineHelpType getInlineHelpType() {
        return this._inlineHelpType != null ? this._inlineHelpType : Project.getDefaultInlineHelpType();
    }

    public void setInlineHelpType(InlineHelpType type) {
        this.checkScope();
        if (!InlineHelpType.UNSPECIFIED.equals((Object)type)) {
            this._inlineHelpType = type;
        }
    }

    @Override
    public String getDefaultLabel() {
        return this.getLocalizedLabel(null);
    }

    @Override
    public void setDefaultLabel(String defaultLabel) {
        this.setLocalizedLabel(null, defaultLabel);
    }

    @Override
    public String getDefaultShortLabel() {
        return this.getLocalizedShortLabel(null);
    }

    @Override
    public void setDefaultShortLabel(String defaultShortLabel) {
        this.setLocalizedShortLabel((Locale)null, defaultShortLabel);
    }

    @Override
    public void setDefaultShortLabel(String ... defaultShortLabel) {
        this.setLocalizedShortLabel(null, defaultShortLabel);
    }

    @Override
    public String getDefaultColumnHeader() {
        return this.getLocalizedColumnHeader(null);
    }

    @Override
    public void setDefaultColumnHeader(String defaultColumnHeader) {
        this.setLocalizedColumnHeader((Locale)null, defaultColumnHeader);
    }

    @Override
    public void setDefaultColumnHeader(String ... defaultColumnHeader) {
        this.setLocalizedColumnHeader(null, defaultColumnHeader);
    }

    @Override
    public String getDefaultCollectionLabel() {
        return this.getLocalizedCollectionLabel(null);
    }

    @Override
    public void setDefaultCollectionLabel(String defaultCollectionLabel) {
        this.setLocalizedCollectionLabel(null, defaultCollectionLabel);
    }

    @Override
    public String getDefaultCollectionShortLabel() {
        return this.getLocalizedCollectionShortLabel(null);
    }

    @Override
    public void setDefaultCollectionShortLabel(String defaultCollectionShortLabel) {
        this.setLocalizedCollectionShortLabel(null, defaultCollectionShortLabel);
    }

    @Override
    public String getDefaultDescription() {
        return this.getLocalizedDescription(null);
    }

    @Override
    public void setDefaultDescription(String defaultDescription) {
        this.setLocalizedDescription(null, defaultDescription);
    }

    @Override
    public String getDefaultShortDescription() {
        return this.getLocalizedShortDescription(null);
    }

    @Override
    public void setDefaultShortDescription(String defaultShortDescription) {
        this.setLocalizedShortDescription(null, defaultShortDescription);
    }

    @Override
    public String getDefaultTooltip() {
        return this.getLocalizedTooltip(null);
    }

    @Override
    public void setDefaultTooltip(String defaultTooltip) {
        this.setLocalizedTooltip(null, defaultTooltip);
    }

    @Override
    public String getDefaultSymbol() {
        return this.getLocalizedSymbol(null);
    }

    @Override
    public void setDefaultSymbol(String defaultSymbol) {
        this.setLocalizedSymbol(null, defaultSymbol);
    }

    protected void copyLocalizedStrings(Artifact artifact) {
        if (artifact instanceof AbstractArtifact) {
            AbstractArtifact that = (AbstractArtifact)artifact;
            if (artifact != this) {
                this._localizedLabel.clear();
                this._localizedLabel.putAll(that._localizedLabel);
                this._localizedShortLabel.clear();
                this._localizedShortLabel.putAll(that._localizedShortLabel);
                this._localizedCollectionLabel.clear();
                this._localizedCollectionLabel.putAll(that._localizedCollectionLabel);
                this._localizedCollectionShortLabel.clear();
                this._localizedCollectionShortLabel.putAll(that._localizedCollectionShortLabel);
                this._localizedDescription.clear();
                this._localizedDescription.putAll(that._localizedDescription);
                this._localizedShortDescription.clear();
                this._localizedShortDescription.putAll(that._localizedShortDescription);
                this._localizedSymbol.clear();
                this._localizedSymbol.putAll(that._localizedSymbol);
                this._localizedTooltip.clear();
                this._localizedTooltip.putAll(that._localizedTooltip);
            }
        }
    }

    @Override
    public String getLocalizedLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedLabel.get(l);
    }

    @Override
    public void setLocalizedLabel(Locale locale, String localizedLabel) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedLabel == null) {
            this._localizedLabel.remove(l);
        } else {
            this._localizedLabel.put(l, localizedLabel);
        }
        this.setLocalizedShortLabel(locale, localizedLabel);
    }

    @Override
    public String getLocalizedShortLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedShortLabel.get(l);
    }

    @Override
    public void setLocalizedShortLabel(Locale locale, String localizedShortLabel) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedShortLabel == null) {
            this._localizedShortLabel.remove(l);
        } else {
            this._localizedShortLabel.put(l, localizedShortLabel);
        }
    }

    @Override
    public void setLocalizedShortLabel(Locale locale, String ... localizedShortLabel) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedShortLabel == null || localizedShortLabel.length == 0) {
            this._localizedShortLabel.remove(l);
        } else {
            this._localizedShortLabel.put(l, StringUtils.join((Object[])localizedShortLabel, (String)"\n"));
        }
    }

    @Override
    public String getLocalizedColumnHeader(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedColumnHeader.get(l);
    }

    @Override
    public void setLocalizedColumnHeader(Locale locale, String localizedColumnHeader) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedColumnHeader == null) {
            this._localizedColumnHeader.remove(l);
        } else {
            this._localizedColumnHeader.put(l, localizedColumnHeader);
        }
    }

    @Override
    public void setLocalizedColumnHeader(Locale locale, String ... localizedColumnHeader) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedColumnHeader == null || localizedColumnHeader.length == 0) {
            this._localizedColumnHeader.remove(l);
        } else {
            this._localizedColumnHeader.put(l, StringUtils.join((Object[])localizedColumnHeader, (String)"\n"));
        }
    }

    @Override
    public String getLocalizedCollectionLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedCollectionLabel.get(l);
    }

    @Override
    public void setLocalizedCollectionLabel(Locale locale, String localizedCollectionLabel) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedCollectionLabel == null) {
            this._localizedCollectionLabel.remove(l);
        } else {
            this._localizedCollectionLabel.put(l, localizedCollectionLabel);
        }
        this.setLocalizedCollectionShortLabel(locale, localizedCollectionLabel);
    }

    @Override
    public String getLocalizedCollectionShortLabel(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedCollectionShortLabel.get(l);
    }

    @Override
    public void setLocalizedCollectionShortLabel(Locale locale, String localizedCollectionShortLabel) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedCollectionShortLabel == null) {
            this._localizedCollectionShortLabel.remove(l);
        } else {
            this._localizedCollectionShortLabel.put(l, localizedCollectionShortLabel);
        }
    }

    @Override
    public String getLocalizedDescription(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedDescription.get(l);
    }

    @Override
    public void setLocalizedDescription(Locale locale, String localizedDescription) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedDescription == null) {
            this._localizedDescription.remove(l);
        } else {
            if (((String)localizedDescription).endsWith("\b")) {
                localizedDescription = (String)localizedDescription + NBSP;
            }
            this._localizedDescription.put(l, (String)localizedDescription);
        }
    }

    @Override
    public String getLocalizedShortDescription(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedShortDescription.get(l);
    }

    @Override
    public void setLocalizedShortDescription(Locale locale, String localizedShortDescription) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedShortDescription == null) {
            this._localizedShortDescription.remove(l);
        } else {
            this._localizedShortDescription.put(l, localizedShortDescription);
        }
    }

    @Override
    public String getLocalizedTooltip(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedTooltip.get(l);
    }

    @Override
    public void setLocalizedTooltip(Locale locale, String localizedTooltip) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedTooltip == null) {
            this._localizedTooltip.remove(l);
        } else {
            this._localizedTooltip.put(l, localizedTooltip);
        }
    }

    @Override
    public String getLocalizedSymbol(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedSymbol.get(l);
    }

    @Override
    public void setLocalizedSymbol(Locale locale, String localizedSymbol) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedSymbol == null) {
            this._localizedSymbol.remove(l);
        } else {
            this._localizedSymbol.put(l, localizedSymbol);
        }
    }

    public boolean isLocalizedSymbolDefined() {
        return !this._localizedSymbol.isEmpty();
    }

    protected Locale localeReadingKey(Locale locale) {
        return locale == null ? Bundle.getLocale() : locale;
    }

    protected Locale localeWritingKey(Locale locale) {
        return this.localeReadingKey(locale);
    }

    protected char settler() {
        return '?';
    }

    @Override
    public Artifact getDeclaringArtifact() {
        return this._declaringArtifact;
    }

    String getDeclaringArtifactClassSimpleName() {
        return this._declaringArtifact == null ? null : this._declaringArtifact.getClass().getSimpleName();
    }

    void initDeclaringArtifact(Artifact declaringArtifact) {
        this._declaringArtifact = declaringArtifact;
    }

    void setDeclaringArtifact(Artifact declaringArtifact) {
        if (this._declared) {
            return;
        }
        this.resetDeclaringArtifact(declaringArtifact);
    }

    void resetDeclaringArtifact(Artifact declaringArtifact) {
        this._declaringArtifact = declaringArtifact;
        if (declaringArtifact != null) {
            if (this instanceof Entity) {
                this._depth = declaringArtifact.depth() + 1;
                this._round = XS1.round(this.getNamedClass(), declaringArtifact);
            } else {
                this._depth = declaringArtifact.depth();
            }
        }
    }

    @Override
    public Field getDeclaringField() {
        return this._declaringField;
    }

    public String getDeclaringFieldNamedClassSimpleName() {
        Field declaringField = this.getDeclaringField();
        Class<?> declaringFieldClass = declaringField.getDeclaringClass();
        Class<?> declaringFieldNamedClass = XS1.getNamedClass(declaringFieldClass);
        return declaringFieldNamedClass.getSimpleName();
    }

    void setDeclaringField(Field declaringField) {
        if (this._declared) {
            return;
        }
        this.resetDeclaringField(declaringField);
    }

    void resetDeclaringField(Field declaringField) {
        this._declaringField = declaringField;
    }

    @Override
    public int getDeclaringFieldIndex() {
        return this._declaringFieldIndex;
    }

    void setDeclaringFieldIndex(int declaringFieldIndex) {
        if (this._declared) {
            return;
        }
        this._declaringFieldIndex = declaringFieldIndex;
    }

    @Override
    public Entity getDeclaringEntity() {
        return this._declaringArtifact instanceof Entity ? (Entity)this._declaringArtifact : null;
    }

    @Override
    public PersistentEntity getDeclaringPersistentEntity() {
        Entity declaringEntity = this.getDeclaringEntity();
        return declaringEntity instanceof PersistentEntity ? (PersistentEntity)declaringEntity : null;
    }

    @Override
    public Entity getDeclaringEntityRoot() {
        Entity declaringEntity = this.getDeclaringEntity();
        return declaringEntity == null ? null : declaringEntity.getRoot();
    }

    @Override
    public PersistentEntity getDeclaringPersistentEntityRoot() {
        Entity declaringEntityRoot = this.getDeclaringEntityRoot();
        return declaringEntityRoot instanceof PersistentEntity ? (PersistentEntity)declaringEntityRoot : null;
    }

    @Override
    public Entity getDeclaringFieldEntityRoot() {
        Class<?> declaringClass = this._declaringField == null ? null : this._declaringField.getDeclaringClass();
        Entity declaringEntity = declaringClass == null ? null : this.getDeclaringEntity();
        return declaringEntity == null ? null : declaringEntity.getDeclaringProject().getEntity(declaringClass);
    }

    @Override
    public PersistentEntity getDeclaringFieldPersistentEntityRoot() {
        Entity declaringFieldEntityRoot = this.getDeclaringFieldEntityRoot();
        return declaringFieldEntityRoot instanceof PersistentEntity ? (PersistentEntity)declaringFieldEntityRoot : null;
    }

    @Override
    public PersistentEntity getDeclaringFieldPersistentEntityTableRoot() {
        PersistentEntity dfper = this.getDeclaringFieldPersistentEntityRoot();
        return dfper == null ? null : (dfper.isTable() ? dfper : dfper.getBaseTableRoot());
    }

    @Override
    public Operation getDeclaringOperation() {
        return this._declaringArtifact instanceof Operation ? (Operation)this._declaringArtifact : null;
    }

    @Override
    public int depth() {
        return this._depth;
    }

    @Override
    public int round() {
        return this._round;
    }

    Map<Class<? extends Annotation>, Field> getAnnotations() {
        return this._annotations;
    }

    @Override
    public void clearAttributes() {
        this._attributes.clear();
    }

    @Override
    public void addAttributes() {
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public Set<String> getAttributesKeySetByRegex(String regex) {
        TreeSet<String> newSet = new TreeSet<String>();
        Set<String> keySet = this._attributes.keySet();
        for (String string : keySet) {
            if (!string.matches(regex)) continue;
            newSet.add(string);
        }
        return newSet;
    }

    @Override
    public boolean isAnnotated() {
        return this._annotated;
    }

    void initializeAnnotations() {
    }

    public void annotate() {
        if (this._annotated) {
            return;
        }
        this._annotated = true;
        this.initializeAnnotations();
        this.annotate(this.getNamedClass());
        this.annotate(this.getDeclaringField());
    }

    void annotate(Class<?> type) {
        if (type == null) {
            return;
        }
        Annotation[] annotations = type.getAnnotations();
        List<Class<? extends Annotation>> valid = this.getValidTypeAnnotations();
        this.checkAnnotations(type, null, annotations, valid);
    }

    void annotate(Field field) {
        boolean check;
        if (field == null) {
            return;
        }
        boolean bl = check = this.depth() == 0 || !this.isProperty();
        if (check) {
            Entity e;
            Class<?> clazz = null;
            if (this.depth() == 0 && this.isParameter() && (e = this.getDeclaringArtifact().getDeclaringEntity()) != null) {
                clazz = e.getClass();
            }
            Annotation[] annotations = field.getAnnotations();
            List<Class<? extends Annotation>> valid = this.getValidFieldAnnotations();
            this.checkAnnotations(field, clazz, annotations, valid);
        }
    }

    private void checkAnnotations(Object obj1, Object obj2, Annotation[] annotations, List<Class<? extends Annotation>> valid) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (valid.contains(annotationType) || annotationType.getPackage().getName().startsWith("javax.xml.bind.annotation")) continue;
            String pattern = "@{0} {1} {2}" + (obj2 == null ? "" : " referenced by {3}");
            String refusal = annotationType.isAnnotationPresent(Deprecated.class) ? "is deprecated and no longer valid for" : "is not valid for";
            String message = MessageFormat.format(pattern, annotationType.getSimpleName(), refusal, obj1, obj2);
            Project.logParserMessage(Level.ERROR, message);
            Project.increaseParserErrorCount();
        }
    }

    protected boolean isValidTypeAnnotation(Class<? extends Annotation> annotation) {
        return this.getValidTypeAnnotations().contains(annotation);
    }

    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        return new ArrayList<Class<? extends Annotation>>();
    }

    protected boolean isValidFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.getValidFieldAnnotations().contains(annotation);
    }

    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        return new ArrayList<Class<? extends Annotation>>();
    }

    @Override
    public Field put(Class<? extends Annotation> annotation, Field field) {
        XS1.checkAccess();
        return this._annotations.put(annotation, field);
    }

    public AbstractArtifact() {
        this.init();
        this.add();
    }

    private void init() {
        this._defaultLocale = this.defaultLocale();
        this.setStaticAttributes();
        this.copyBootstrappingAttributes();
    }

    protected void setStaticAttributes() {
    }

    protected void copyBootstrappingAttributes() {
        this._checkScope = Bootstrapping.checkReferencesToEnclosingEntityMembersWithinEnclosedOperations;
    }

    private void add() {
        Project project = TLC.getProject();
        if (project != null) {
            project.addArtifact(this);
        }
    }

    private void putKeyFeatures(String key, String value) {
        Project project = TLC.getProject();
        if (project != null) {
            project.putKeyFeatures(key, value);
        }
    }

    protected Locale defaultLocale() {
        return null;
    }

    @Override
    public Object addAttribute(Class<?> clazz, String name, KVP value) {
        return this.addAttribute(this.attributeName(clazz, name), value);
    }

    @Override
    public Object addAttribute(String name, KVP value) {
        return value == null ? this._attributes.remove(name) : this.putKeyValuePairAttribute(name, value);
    }

    @Override
    public Object addAttribute(Class<?> clazz, String name, KVP ... value) {
        return this.addAttribute(this.attributeName(clazz, name), value);
    }

    @Override
    public Object addAttribute(String name, KVP ... value) {
        return value == null ? this._attributes.remove(name) : this.putKeyValuePairAttribute(name, value);
    }

    @Override
    public Object addAttribute(Class<?> clazz, String name, Object value) {
        return this.addAttribute(this.attributeName(clazz, name), value);
    }

    @Override
    public Object addAttribute(String name, Object value) {
        return value == null ? this._attributes.remove(name) : this._attributes.put(name, value);
    }

    @Override
    public Object addAttribute(Class<?> clazz, String name, Object ... value) {
        return this.addAttribute(this.attributeName(clazz, name), value);
    }

    @Override
    public Object addAttribute(String name, Object ... value) {
        return value == null ? this._attributes.remove(name) : this._attributes.put(name, value);
    }

    private Object putKeyValuePairAttribute(String name, KVP value) {
        Object oldValue = this._attributes.get(name);
        KVP[] newValue = oldValue == null ? value : (oldValue instanceof KVP ? value.toArray(oldValue) : (KVP.isArray(oldValue) ? ArrUtils.addAll(value.toArray(), KVP.array(oldValue)) : value));
        return this._attributes.put(name, newValue);
    }

    private Object putKeyValuePairAttribute(String name, KVP ... value) {
        Object oldValue = this._attributes.get(name);
        KVP[] newValue = oldValue == null ? value : ArrUtils.addAll(value, KVP.array(oldValue));
        return this._attributes.put(name, newValue);
    }

    @Override
    public Object getAttribute(Class<?> clazz, String name) {
        return this.getAttribute(this.attributeName(clazz, name));
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Boolean getBooleanAttribute(Class<?> clazz, String name) {
        return this.getBooleanAttribute(this.attributeName(clazz, name));
    }

    public Boolean getBooleanAttribute(String name) {
        Object attribute = this._attributes.get(name);
        return ObjUtils.toBoolean(attribute);
    }

    public Integer getIntegerAttribute(Class<?> clazz, String name) {
        return this.getIntegerAttribute(this.attributeName(clazz, name));
    }

    public Integer getIntegerAttribute(String name) {
        Object attribute = this._attributes.get(name);
        return ObjUtils.toInteger(attribute);
    }

    public Integer getIntegerAttribute(Class<?> clazz, String name, Integer min, Integer max) {
        return this.getIntegerAttribute(this.attributeName(clazz, name), min, max);
    }

    public Integer getIntegerAttribute(String name, Integer min, Integer max) {
        Object attribute = this._attributes.get(name);
        Integer integer = ObjUtils.toInteger(attribute);
        return ObjUtils.between(integer, min, max) ? integer : null;
    }

    public String getStringAttribute(Class<?> clazz, String name) {
        return this.getStringAttribute(this.attributeName(clazz, name));
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, "=", ", ", "(", ")");
    }

    public String getStringAttribute(Class<?> clazz, String name, String equals, String separator, String open, String close) {
        return this.getStringAttribute(this.attributeName(clazz, name), equals, separator, open, close);
    }

    public String getStringAttribute(String name, String equals, String separator, String open, String close) {
        return StrUtils.getString(equals, separator, open, close, this._attributes.get(name));
    }

    public String getStringKeyValuePairAttribute(Class<?> clazz, String name, String key) {
        return this.getStringKeyValuePairAttribute(clazz, name, key, null);
    }

    public String getStringKeyValuePairAttribute(Class<?> clazz, String name, String key, Object defaultValue) {
        Object object = this.getKeyValuePairAttribute(this.attributeName(clazz, name), key, defaultValue);
        return object == null ? null : StringUtils.trimToNull((String)object.toString());
    }

    public Object getKeyValuePairAttribute(Class<?> clazz, String name, String key) {
        return this.getKeyValuePairAttribute(this.attributeName(clazz, name), key);
    }

    public Object getKeyValuePairAttribute(String name, String key) {
        return this.getKeyValuePairAttribute(name, key, null);
    }

    public Object getKeyValuePairAttribute(Class<?> clazz, String name, String key, Object defaultValue) {
        return this.getKeyValuePairAttribute(this.attributeName(clazz, name), key, defaultValue);
    }

    public Object getKeyValuePairAttribute(String name, String key, Object defaultValue) {
        KVP[] array;
        if (name != null && key != null && (array = KVP.array(this.getAttributesArray(name))) != null && array.length > 0) {
            for (KVP kvp : array) {
                Object value;
                if (!key.equals(kvp.getKey()) || (value = kvp.getValue()) == null) continue;
                return value;
            }
        }
        return defaultValue;
    }

    public Object getAttributesArray(Class<?> clazz, String name) {
        return this.getAttributesArray(this.attributeName(clazz, name));
    }

    public Object getAttributesArray(String name) {
        Object[] value = this._attributes.get(name);
        return value == null ? null : (value.getClass().isArray() ? value : ArrUtils.arrayOf(value));
    }

    private String attributeName(Class<?> clazz, String name) {
        return (clazz != null ? clazz : this.getNamedClass()).getSimpleName() + ":" + name;
    }

    @Override
    public String getClassPath() {
        return this.classPath(this);
    }

    private String classPath(Artifact a) {
        Artifact da = a.getDeclaringArtifact();
        String str1 = a.getName();
        String str2 = XS1.getNamedClass(a).getSimpleName();
        String str3 = str1 == null || str1.equals(str2) ? str2 : str2 + "[" + str1 + "]";
        return da == null ? str3 : this.classPath(da) + "." + str3;
    }

    @Override
    public boolean isClassInPath(Class<?> type) {
        return this.isClassInPath(type, this);
    }

    private boolean isClassInPath(Class<?> clazz, Artifact artifact) {
        if (clazz != null && artifact != null) {
            if (clazz.isAssignableFrom(XS1.getNamedClass(artifact))) {
                return true;
            }
            Artifact declaringArtifact = artifact.getDeclaringArtifact();
            if (declaringArtifact != null) {
                return this.isClassInPath(clazz, declaringArtifact);
            }
        }
        return false;
    }

    @Override
    public List<Artifact> getPathList() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        this.addToPathList(list, this);
        return list;
    }

    private void addToPathList(List<Artifact> list, Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact != null) {
            this.addToPathList(list, declaringArtifact);
        }
        list.add(artifact);
    }

    @Override
    public String getPathString() {
        return this.path(this);
    }

    private String path(Artifact a) {
        Object p;
        if (a.getDeclaringField() == null || a.getDeclaringArtifact() == null) {
            p = XS1.getNamedClass(a).getSimpleName() + ".this";
        } else {
            p = this.path(a.getDeclaringArtifact()) + "." + a.getDeclaringField().getName();
            if (a.getDeclaringField().getType().isArray()) {
                p = (String)p + "[" + a.getDeclaringFieldIndex() + "]";
            }
            p = StringUtils.removeStart((String)p, (String)".");
        }
        return p;
    }

    @Override
    public String getFullName() {
        return StringUtils.remove((String)this.getPathString(), (String)".this");
    }

    @Override
    public String getPartialName() {
        return StringUtils.substringAfter((String)this.getPathString(), (String)".this.");
    }

    public String getPartialSqlName() {
        return StrUtils.getSnakeCase(this.getPartialName());
    }

    @Override
    public String getCrypticName(String prefix, String suffix) {
        String keyFeatures = this.getKeyFeatures(prefix, suffix);
        String crypticName = StrUtils.getCrypticName(prefix, keyFeatures, suffix);
        String featuresKey = this.getFullName() + "/" + StringUtils.remove((String)suffix, (String)"_");
        this.putKeyFeatures(featuresKey, keyFeatures);
        return crypticName;
    }

    @Override
    public String getKeyFeatures(String prefix, String suffix) {
        return "(" + this.getFullName() + "," + this.getClass().getSimpleName() + ")";
    }

    protected String getValueString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Artifact) {
            Artifact artifact = (Artifact)value;
            return this.getValueString(value, artifact.getPathString());
        }
        return value.toString();
    }

    protected String getValueString(Object object, Object value) {
        return XS1.getNamedClass(object).getSimpleName() + "(" + value.toString() + ")";
    }

    String getJavaFileName() {
        return this.getNamedClass().getCanonicalName().replace('.', '/') + ".java";
    }

    Class<?> getNamedClass() {
        return XS1.getNamedClass(this);
    }

    @Override
    public boolean isOperation() {
        return this instanceof Operation;
    }

    private boolean isParameter() {
        return this instanceof DataArtifact && ((DataArtifact)((Object)this)).isParameter();
    }

    private boolean isProperty() {
        return this instanceof DataArtifact && ((DataArtifact)((Object)this)).isProperty();
    }

    @Override
    public boolean isExpression() {
        return this instanceof Expression;
    }

    protected String fa(String name) {
        return this.fairGraphicImageName(name);
    }

    String fairGraphicImageName(String name) {
        return this.isFontAwesomeClass(name) ? name.trim().replaceAll(" +", " ") : name;
    }

    protected boolean isFontAwesomeClass(String name) {
        return name != null && name.matches("^.*\\bfa[a-z]?(\\sfa[a-z]?\\-[a-z\\-]*)+.*$");
    }

    protected String xs(String name) {
        return this.fairUnicodeSymbolName(name);
    }

    String fairUnicodeSymbolName(String name) {
        return this.isUnicodeSymbolClass(name) ? name.trim().replaceAll(" +", " ") : name;
    }

    protected boolean isUnicodeSymbolClass(String name) {
        return name != null && name.matches("^.*\\bxs[a-z]?(\\sxs[a-z]?\\-[a-z\\-]*)+.*$");
    }

    protected boolean isValidEmbeddedDocument(String document) {
        return document != null && document.matches("^((?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])$");
    }

    protected boolean isValidHelpFileName(String fileName) {
        return fileName != null && fileName.matches("^/?([\\w-]+/)*[\\w-]+\\.[a-zA-Z]+$");
    }

    protected boolean isValidHelpFileType(String fileName) {
        String fileType = StringUtils.substringAfterLast((String)fileName, (String)".");
        return StringUtils.isNotBlank((String)fileType) && ArrayUtils.contains((Object[])Project.getHelpFileTypes(), (Object)fileType);
    }

    protected boolean isValidSnippetFileName(String fileName) {
        return fileName != null && fileName.matches("^/?([\\w-]+/)*[\\w-]+(\\.[a-zA-Z]+)?$");
    }

    protected boolean isValidJavaClassName(String className) {
        return className != null && className.matches("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*");
    }

    protected boolean verifyExpression(Expression expression) {
        return this.verifyExpression(expression, (Artifact)null);
    }

    protected boolean verifyExpression(Expression expression, Artifact artifact) {
        return this.verifyExpression(expression, artifact, true);
    }

    protected boolean verifyExpression(Expression expression, ExpressionUsage usage) {
        return this.verifyExpression(expression, (Artifact)null, usage);
    }

    protected boolean verifyExpression(Expression expression, Artifact artifact, ExpressionUsage usage) {
        return this.verifyExpression(expression, artifact, usage, true);
    }

    protected boolean verifyExpression(Expression expression, Artifact artifact, boolean calculableless) {
        return this.verifyExpression(expression, artifact, ExpressionUsage.INDETERMINATE, calculableless);
    }

    protected boolean verifyExpression(Expression expression, Artifact artifact, ExpressionUsage usage, boolean calculableless) {
        boolean ok = true;
        String locator = artifact == null ? "at " + this.getFullName() : "for " + artifact.getFullName();
        locator = locator + this.stringOf(usage);
        if (expression == null) {
            String message = "null expression defined " + locator;
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            ok = false;
        } else {
            expression.addVerifiedUsage(usage, artifact);
            String expname = StringUtils.isBlank((String)expression.getName()) ? "" : expression.getName() + " ";
            String message = "invalid expression " + expname + "defined " + locator;
            if (expression instanceof VariantX) {
                boolean b1 = this instanceof Entity && this.depth() == 0;
                boolean b2 = this instanceof Operation;
                if (b1 || b2) {
                    message = message + "; expression is not properly defined";
                    logger.error((Object)message);
                    Project.increaseParserErrorCount();
                    ok = false;
                }
            } else {
                ok &= this.verifyExpression(this, expression, message, usage, calculableless);
            }
        }
        return ok;
    }

    private boolean verifyExpression(Artifact container, Expression expression, String message, ExpressionUsage usage, boolean calculableless) {
        Object[] operands;
        boolean ok = true;
        if (expression != null && container != null && (operands = expression.getOperands()) != null && operands.length > 0) {
            for (Object operand : operands) {
                String fullName;
                Artifact artifact;
                if (operand instanceof DataArtifact) {
                    artifact = (Artifact)operand;
                    fullName = artifact.getFullName();
                    List<Artifact> pathList = artifact.getPathList();
                    if (pathList.contains(container)) {
                        String text2;
                        String text1;
                        Level level;
                        boolean b1 = container instanceof Entity && container.depth() == 0;
                        boolean b2 = container instanceof Operation;
                        if (!b1 && !b2) continue;
                        Entity declaringEntity = b1 ? (Entity)container : (b2 ? ((Operation)container).getDeclaringEntity() : null);
                        boolean special = declaringEntity != null && declaringEntity.isSpecialExpressionsWarningsEnabled();
                        boolean unusual = declaringEntity != null && declaringEntity.isUnusualExpressionsWarningsEnabled();
                        boolean calculable = this.calculableProperty(artifact);
                        boolean calculated = this.calculatedProperty(artifact);
                        if (!calculated) continue;
                        if (calculableless || b2) {
                            level = Level.ERROR;
                            text1 = message;
                            text2 = "; operand " + fullName + " is a " + (calculable ? "calculable" : "calculated") + " property";
                        } else if (b1 && !artifact.getDeclaringEntity().equals(container)) {
                            if (calculable) {
                                level = Level.ERROR;
                                text1 = message;
                                text2 = "; operand " + fullName + " is a foreign calculable property";
                            } else if (ExpressionUsage.SEARCH_QUERY_FILTER.equals((Object)usage)) {
                                level = special ? Project.getSpecialExpressionLevel() : null;
                                text1 = message.replace("invalid", "special");
                                text2 = "; operand " + fullName + " is a calculated foreign property";
                            } else {
                                level = unusual ? Project.getUnusualExpressionLevel() : null;
                                text1 = message.replace("invalid", "unusual");
                                text2 = "; operand " + fullName + " is a calculated foreign property";
                            }
                        } else {
                            level = null;
                            text1 = null;
                            text2 = null;
                        }
                        if (!LogUtils.fair(level)) continue;
                        logger.log((Priority)level, (Object)(text1 + text2));
                        if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
                            Project.increaseParserErrorCount();
                            ok = false;
                            continue;
                        }
                        if (!Level.WARN.equals((Object)level)) continue;
                        Project.increaseParserWarningCount();
                        continue;
                    }
                    logger.error((Object)(message + "; operand " + fullName + " is out of scope"));
                    Project.increaseParserErrorCount();
                    ok = false;
                    continue;
                }
                if (operand instanceof VariantX) {
                    artifact = (Artifact)operand;
                    fullName = artifact.getFullName();
                    logger.error((Object)(message + "; operand " + fullName + " is out of scope"));
                    Project.increaseParserErrorCount();
                    ok = false;
                    continue;
                }
                if (!(operand instanceof Expression)) continue;
                Expression operandExpression = (Expression)operand;
                ok &= this.verifyExpression(container, operandExpression, message, usage, calculableless);
            }
        }
        return ok;
    }

    private boolean calculableProperty(Artifact artifact) {
        DataArtifact dataArtifact;
        if (artifact instanceof DataArtifact && (dataArtifact = (DataArtifact)artifact).isProperty()) {
            return ((Property)artifact).isCalculable();
        }
        return false;
    }

    boolean calculatedProperty(Artifact artifact) {
        DataArtifact dataArtifact;
        if (artifact instanceof DataArtifact && (dataArtifact = (DataArtifact)artifact).isProperty()) {
            return ((Property)artifact).isCalculable() || this.calculatedProperty(artifact.getDeclaringArtifact());
        }
        return false;
    }

    private String stringOf(ExpressionUsage usage) {
        return usage == null || usage.equals((Object)ExpressionUsage.INDETERMINATE) ? "" : " (" + StrUtils.getWordyString(usage.toString()) + ")";
    }

    protected void verifyNames(Class<?> top, Class<?> clazz) {
        boolean expression = Expression.class.equals(clazz);
        Class<?> dac = this.getClass();
        for (Field field : XS1.getFields(dac, top, clazz)) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (!this.isNotRestricted(field)) continue;
            try {
                Object object = field.get(this);
                if (!(object instanceof AbstractArtifact)) continue;
                AbstractArtifact artifact = (AbstractArtifact)object;
                String artifactName = artifact.getName();
                if (artifactName == null) {
                    artifact.setName(fieldName);
                }
                if (!expression || !this._checkScope) continue;
                if (artifact.getDeclaringArtifact() == null) {
                    artifact.setDeclaringArtifact(this);
                }
                if (artifact.getDeclaringField() != null) continue;
                artifact.setDeclaringField(field);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                String message = "failed to get field \"" + String.valueOf(field) + "\" at " + String.valueOf(this);
                logger.error((Object)message, ThrowableUtils.getCause(ex));
                Project.increaseParserErrorCount();
            }
        }
    }

    private boolean isNotRestricted(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    protected <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected int greaterThanZero(int ... values) {
        return values == null || values.length == 0 ? 0 : this.gt0(values);
    }

    private int gt0(int ... values) {
        for (int i : values) {
            if (i <= 0) continue;
            return i;
        }
        return 0;
    }

    protected <E extends Enum> E specified(E ... enums) {
        return (E)this.specified(UNSPECIFIED, (Enum[])enums);
    }

    protected <E extends Enum> E specified(String unspecified, E ... values) {
        E e = null;
        if (values != null && values.length > 0) {
            String u = StringUtils.defaultIfBlank((String)unspecified, (String)UNSPECIFIED);
            for (E v : values) {
                if (v == null) continue;
                if (u.equals(((Enum)v).name())) {
                    e = v;
                    continue;
                }
                return v;
            }
        }
        return e;
    }

    protected String specified(String ... strings) {
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                return string;
            }
        }
        return "";
    }

    protected String[] specified(String[] strings, String[] defaultStrings) {
        return this.notBlank(strings) ? strings : (this.notBlank(defaultStrings) ? defaultStrings : null);
    }

    private boolean notBlank(String[] strings) {
        if (strings != null && strings.length > 0) {
            for (String string : strings) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                return true;
            }
        }
        return false;
    }

    protected <T> T[] specified(T[] values, T[] defaultValues) {
        return this.notEmpty(values) ? values : (this.notEmpty(defaultValues) ? defaultValues : null);
    }

    private <T> boolean notEmpty(T[] values) {
        if (values != null && values.length > 0) {
            for (T value : values) {
                if (value == null) continue;
                return true;
            }
        }
        return false;
    }

    protected int[] specified(int[] a1, int[] a2) {
        int[] a3 = new int[a1.length > a2.length ? a1.length : a2.length];
        int[] c1 = Arrays.copyOf(a1, a3.length);
        int[] c2 = Arrays.copyOf(a2, a3.length);
        for (int i = 0; i < a3.length; ++i) {
            a3[i] = c1[i] > 0 ? c1[i] : c2[i];
        }
        return a3;
    }

    protected Integer specified(Integer ... values) {
        if (values != null && values.length > 0) {
            for (Integer v : values) {
                if (v == null || v < 0) continue;
                return v;
            }
        }
        return -1;
    }

    protected Character specified(Character ... values) {
        if (values != null && values.length > 0) {
            for (Character v : values) {
                if (v == null || v.charValue() == ' ') continue;
                return v;
            }
        }
        return Character.valueOf(' ');
    }

    @Override
    public Wrapper getWrapper() {
        Class<?> thisClass;
        Class<? extends Wrapper> wrapperClass;
        if (this._wrapper == null && (wrapperClass = this.getWrapperClass(thisClass = this.getClass())) != null) {
            Class<?> parameterType = XS1.getConstructorParameterType(wrapperClass, thisClass);
            if (parameterType != null) {
                String pattern = "failed to wrap {0} using {1}({2})";
                String message = MessageFormat.format(pattern, thisClass, wrapperClass, parameterType);
                try {
                    this._wrapper = wrapperClass.getConstructor(parameterType).newInstance(this);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw new RuntimeException(message, ex);
                }
            } else {
                String pattern = "{1} is not a valid wrapper for {0}";
                String message = MessageFormat.format(pattern, thisClass, wrapperClass);
                throw new RuntimeException(message);
            }
        }
        return this._wrapper;
    }

    private Class<? extends Wrapper> getWrapperClass(Class<?> clazz) {
        if (clazz != null && Wrappable.class.isAssignableFrom(clazz)) {
            Class<?> wrappableClass = clazz;
            Class<? extends Wrapper> wrapperClass = TLB.getWrapperClass(wrappableClass);
            return wrapperClass != null ? wrapperClass : this.getWrapperClass(clazz.getSuperclass());
        }
        return this.getDefaultWrapperClass();
    }

    public Class<? extends ArtifactWrapper> getDefaultWrapperClass() {
        return ArtifactWrapper.class;
    }

    boolean sameDataTypeSimpleName(TypedArtifact x, TypedArtifact y) {
        return x != null && y != null && x.getDataType() != null && y.getDataType() != null && x.getDataType().getSimpleName().equals(y.getDataType().getSimpleName());
    }

    protected void checkScope() {
        if (Bootstrapping.checkReferencesToEnclosingEntityMembersWithinEnclosedOperations) {
            this.checkScope1();
        }
    }

    private void checkScope1() {
        StackTraceElement[] stack;
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity == null || this.depth() > 1) {
            return;
        }
        for (Artifact artifact : this.getPathList()) {
            if (!(artifact instanceof Operation)) continue;
            return;
        }
        String metodo = null;
        String[] prefixes = new String[]{"adalid.core.AbstractArtifact.checkScope", "java.", "jdk."};
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String method = element.getClassName() + "." + element.getMethodName();
            if (StringUtils.startsWithAny((String)method, (String[])prefixes)) continue;
            method = method + " (" + element.getFileName() + ":" + element.getLineNumber() + ") ";
            if (metodo == null) {
                metodo = method;
                continue;
            }
            Class<?> callerClass = XS1.forName(element.getClassName());
            if (callerClass == null) {
                Project.increaseParserErrorCount();
                logger.error((Object)("class " + element.getClassName() + " not found"));
                break;
            }
            if (!Artifact.class.isAssignableFrom(callerClass)) break;
            if (!Operation.class.isAssignableFrom(callerClass)) continue;
            Class<?> enclosingClass = callerClass.getEnclosingClass();
            if (enclosingClass == null || !Entity.class.isAssignableFrom(enclosingClass)) break;
            Project.increaseParserErrorCount();
            logger.error((Object)("illegal reference to " + this.getFullName()));
            logger.error((Object)("     at " + method));
            break;
        }
    }

    <T> void appendField(List<T> arrayList, T field) {
        if (arrayList.contains(field)) {
            arrayList.remove(field);
        }
        arrayList.add(field);
    }

    protected String a(String href, String text) {
        return MarkupUtils.a(href, text);
    }

    protected String b(String string) {
        return MarkupUtils.b(string);
    }

    protected String b(String separator, String ... strings) {
        return MarkupUtils.b(separator, strings);
    }

    protected static String ic(String clazz) {
        return MarkupUtils.ic(clazz);
    }

    protected static String ic(String clazz, String text) {
        return MarkupUtils.ic(clazz, text);
    }

    protected String i(String string) {
        return MarkupUtils.i(string);
    }

    protected String i(String separator, String ... strings) {
        return MarkupUtils.i(separator, strings);
    }

    protected String m(String string) {
        return MarkupUtils.m(string);
    }

    protected String m(String separator, String ... strings) {
        return MarkupUtils.m(separator, strings);
    }

    protected String s(String string) {
        return MarkupUtils.s(string);
    }

    protected String s(String separator, String ... strings) {
        return MarkupUtils.s(separator, strings);
    }

    protected String u(String string) {
        return MarkupUtils.u(string);
    }

    protected String u(String separator, String ... strings) {
        return MarkupUtils.u(separator, strings);
    }

    protected String ul(String ... strings) {
        return MarkupUtils.ul(strings);
    }

    protected static String h1(String string) {
        return MarkupUtils.h1(string);
    }

    protected static String h2(String string) {
        return MarkupUtils.h2(string);
    }

    protected static String h3(String string) {
        return MarkupUtils.h3(string);
    }

    protected static String h4(String string) {
        return MarkupUtils.h4(string);
    }

    protected static String h5(String string) {
        return MarkupUtils.h5(string);
    }

    protected static String h6(String string) {
        return MarkupUtils.h6(string);
    }

    protected static BigDecimal bigDecimal(String value) {
        return new BigDecimal(value);
    }

    protected static BigDecimal bigDecimal(int value) {
        return AbstractArtifact.bigDecimal((long)value);
    }

    protected static BigDecimal bigDecimal(long value) {
        return BigDecimal.valueOf(value);
    }

    protected static BigDecimal bigDecimal(float value) {
        return AbstractArtifact.bigDecimal((double)value);
    }

    protected static BigDecimal bigDecimal(double value) {
        return BigDecimal.valueOf(value);
    }

    protected static BigInteger bigInteger(String value) {
        return new BigInteger(value);
    }

    protected static BigInteger bigInteger(int value) {
        return AbstractArtifact.bigInteger((long)value);
    }

    protected static BigInteger bigInteger(long value) {
        return BigInteger.valueOf(value);
    }

    protected static BigInteger bigInteger(float value) {
        return AbstractArtifact.bigInteger((double)value);
    }

    protected static BigInteger bigInteger(double value) {
        return BigDecimal.valueOf(value).toBigInteger();
    }

    public String toString() {
        String simpleName = this.getNamedClass().getSimpleName();
        return this.toString(simpleName);
    }

    protected String toString(String simpleName) {
        return simpleName + (String)(this._name == null ? "@" + this.hashCodeHexString() : (this._name.equals(simpleName) ? "" : "[" + this._name + "]"));
    }

    @Override
    public String hashCodeHexString() {
        return StringUtils.leftPad((String)Integer.toHexString(this.hashCode()), (int)8, (char)'0');
    }

    @Override
    public String toString(int n) {
        return this.toString(n, null);
    }

    @Override
    public String toString(int n, String key) {
        return this.toString(n, key, Project.isVerbose());
    }

    @Override
    public String toString(int n, String key, boolean verbose) {
        return this.toString(n, key, verbose, verbose, verbose);
    }

    @Override
    public String toString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String r4n = StringUtils.repeat((String)" ", (int)(4 * n));
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String eol = verbose ? "\n" : ", ";
        Object string = "\n";
        String c = this.classToString(n, key, verbose);
        String f = this.fieldsToString(n, key, verbose, fields, maps);
        String m = this.mapsToString(n, key, verbose, fields, maps);
        string = (String)string + c;
        string = (String)string + " { " + String.valueOf(this) + eol;
        string = (String)string + f;
        string = (String)string + m;
        if (!verbose) {
            string = StringUtils.removeEnd((String)string, (String)eol);
            if (c.contains("\n") || f.contains("\n") || m.contains("\n")) {
                fee = r4n;
            }
        }
        string = (String)string + fee + "}\n";
        return ((String)string).replaceAll("\n\n", "\n");
    }

    protected String classToString(int n, String key, boolean verbose) {
        String tab = StringUtils.repeat((String)" ", (int)4);
        String fee = StringUtils.repeat((String)tab, (int)n);
        Object string = "";
        String s1 = this.getDeclaringField() == null ? "" : this.getDeclaringField().getType().getSimpleName();
        String s2 = this.getNamedClass().getSimpleName();
        String s3 = StringUtils.isBlank((String)s1) || s1.equals(s2) ? s2 : StringUtils.removeEnd((String)s1, (String)"[]") + " (" + s2 + ")";
        Object s4 = StringUtils.isBlank((String)key) ? "" : " " + key;
        string = (String)string + fee + s3 + (String)s4;
        return string;
    }

    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? "\n" : ", ";
        Object string = "";
        if (fields || verbose) {
            if (verbose) {
                if (this._declaringArtifact != null) {
                    string = (String)string + fee + tab + "declaringArtifact" + faa + String.valueOf(this._declaringArtifact) + foo;
                    if (this._declaringField != null) {
                        string = (String)string + fee + tab + "declaringField" + faa + String.valueOf(this._declaringField) + foo;
                        if (this._declaringField.getType().isArray()) {
                            string = (String)string + fee + tab + "declaringFieldIndex" + faa + this._declaringFieldIndex + foo;
                        }
                    }
                    string = (String)string + fee + tab + "path" + faa + this.getPathString() + foo;
                }
                if (this instanceof Entity) {
                    string = (String)string + fee + tab + "depth" + faa + this._depth + foo;
                    string = (String)string + fee + tab + "round" + faa + this._round + foo;
                }
                if (this._name != null) {
                    string = (String)string + fee + tab + "name" + faa + this._name + foo;
                }
                if (this._alias != null) {
                    string = (String)string + fee + tab + "alias" + faa + this._alias + foo;
                }
            } else {
                string = (String)string + fee + tab + "path" + faa + this.getPathString() + foo;
            }
        }
        return string;
    }

    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        return "";
    }
}

