/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.connections.DatabaseConnection;
import adalid.commons.interfaces.DatabaseProject;
import adalid.commons.util.StrUtils;
import adalid.core.AbstractEntity;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.enums.DatabaseEntityType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.DatabaseEntity;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDatabaseEntity
extends AbstractEntity
implements DatabaseEntity {
    private DatabaseEntityType _databaseEntityType;
    private DatabaseConnection _databaseConnection;
    private String _schema;

    @Override
    public DatabaseEntityType getDatabaseEntityType() {
        return this._databaseEntityType;
    }

    void setDatabaseEntityType(DatabaseEntityType databaseEntityType) {
        this._databaseEntityType = databaseEntityType;
    }

    @Override
    public DatabaseConnection getDatabaseConnection() {
        return this._databaseConnection;
    }

    @Override
    public void setDatabaseConnection(DatabaseConnection connection) {
        this.checkScope();
        if (connection != null) {
            String name = StrUtils.getLowerCaseIdentifier(connection.getName(), '-');
            if (StringUtils.isBlank((String)name)) {
                this._databaseConnection = null;
            } else {
                Project project = TLC.getProject();
                if (project instanceof DatabaseProject) {
                    DatabaseProject databaseProject = (DatabaseProject)((Object)project);
                    if (name.equalsIgnoreCase(databaseProject.getDatabaseName())) {
                        this._databaseConnection = null;
                    } else {
                        this._databaseConnection = connection;
                        databaseProject.addExtraDatabaseConnection(connection);
                    }
                }
            }
        }
    }

    @Override
    public String getSchema() {
        return this._schema != null ? this._schema : (this._databaseConnection != null ? this._databaseConnection.getSchema() : null);
    }

    @Override
    public void setSchema(String schema) {
        this.checkScope();
        this._schema = schema;
    }

    @Override
    public boolean isSqlCodeGenEnabled() {
        return super.isSqlCodeGenEnabled() && this._databaseConnection == null;
    }

    public AbstractDatabaseEntity(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }
}

