/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.enums.SortOption;
import java.util.Arrays;

public class Constants {
    public static final int DEFAULT_ROWS_PER_PAGE = 10;
    public static final int DEFAULT_ROWS_PER_PAGE_LIMIT = 100;
    public static final int MINIMUM_ROWS_PER_PAGE_LIMIT = 5;
    public static final int MAXIMUM_ROWS_PER_PAGE_LIMIT = 1000;
    public static final int DEFAULT_SELECT_ROWS_LIMIT = 100;
    public static final int MAXIMUM_SELECT_ROWS_LIMIT = 10000;
    public static final SortOption DEFAULT_SELECT_SORT_OPTION = SortOption.ASC;
    public static final int DEFAULT_REPORT_ROWS_LIMIT = 10000;
    public static final int MAXIMUM_REPORT_ROWS_LIMIT = 1000000;
    public static final SortOption DEFAULT_REPORT_SORT_OPTION = SortOption.ASC;
    public static final int DEFAULT_EXPORT_ROWS_LIMIT = 10000;
    public static final int MAXIMUM_EXPORT_ROWS_LIMIT = 1000000;
    public static final SortOption DEFAULT_EXPORT_SORT_OPTION = SortOption.ASC;
    public static final int DEFAULT_CHARACTER_KEY_MAX_LENGTH = 30;
    public static final int DEFAULT_NAME_PROPERTY_MAX_LENGTH = 100;
    public static final int DEFAULT_DESCRIPTION_PROPERTY_MAX_LENGTH = 2000;
    public static final int DEFAULT_URL_PROPERTY_MAX_LENGTH = 2000;
    public static final int DEFAULT_EMBEDDED_DOCUMENT_MAX_LENGTH = 2000;
    public static final int DEFAULT_FILE_REFERENCE_MAX_LENGTH = 2000;
    public static final int DEFAULT_STRING_FIELD_MAX_LENGTH = 2000;
    public static final int DEFAULT_STRING_INDEX_MAX_LENGTH = 1596;
    public static final int DEFAULT_MAX_INPUT_FILE_SIZE = 100000;
    public static final int DEFAULT_NUMERIC_DIVISOR = 100;
    public static final int DEFAULT_DECIMAL_PRECISION = 16;
    public static final int DEFAULT_DECIMAL_SCALE = 2;
    public static final int DEFAULT_TIME_PRECISION = 3;
    public static final int DEFAULT_YEAR_RANGE = 5;
    public static final int DEFAULT_LARGE_DOCUMENT_WIDTH = 640;
    public static final int DEFAULT_LARGE_DOCUMENT_HEIGHT = 360;
    public static final int DEFAULT_LARGE_IMAGE_WIDTH = 288;
    public static final int DEFAULT_LARGE_IMAGE_HEIGHT = 288;
    public static final int DEFAULT_MEDIUM_DOCUMENT_WIDTH = 480;
    public static final int DEFAULT_MEDIUM_DOCUMENT_HEIGHT = 270;
    public static final int DEFAULT_MEDIUM_IMAGE_WIDTH = 192;
    public static final int DEFAULT_MEDIUM_IMAGE_HEIGHT = 192;
    public static final int DEFAULT_SMALL_DOCUMENT_WIDTH = 320;
    public static final int DEFAULT_SMALL_DOCUMENT_HEIGHT = 180;
    public static final int DEFAULT_SMALL_IMAGE_WIDTH = 96;
    public static final int DEFAULT_SMALL_IMAGE_HEIGHT = 96;
    public static final int MAX_DECIMAL_PRECISION = 60;
    public static final int MAX_BYTE_DIVISOR = 100;
    public static final int MAX_SHORT_DIVISOR = 10000;
    public static final int MAX_INTEGER_DIVISOR = 1000000;
    public static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final int MAX_STRING_INDEX_LENGTH = 6384;
    public static final int MAX_EMAIL_ADDRESS_LENGTH = 254;
    public static final int MAX_PHONE_NUMBER_LENGTH = 20;
    public static final int MAX_LOCAL_PHONE_NUMBER_LENGTH = 20;
    public static final int MAX_TIME_PRECISION = 6;
    public static final int MAX_YEAR_RANGE = 100;
    public static final int MAX_DISPLAY_WIDTH = 1920;
    public static final int MAX_DISPLAY_HEIGHT = 1080;
    public static final int MAX_UPLOAD_FILE_LIMIT = 100;
    public static final int MAX_UPLOAD_UNDO_LIMIT = 4;
    public static final int MAX_SERIES_START = 2000000000;
    public static final int MAX_SERIES_STOP = 2100000000;
    public static final int MAX_SERIES_STEP = 1000000;
    public static final int MAX_ENTITY_SERIES_START = 2000000000;
    public static final int MAX_ENTITY_SERIES_STOP = 2100000000;
    public static final int MAX_ENTITY_SERIES_STEP = 1000000;
    public static final String QUICK_FILTER_SNIPPET = "/resources/snippets/base/panel/quickFilterPanel";
    public static final String SERIES_BY_AGGREGATE = "seriesByAggregate";
    public static final String SERIES_BY_GROUP = "seriesByGroup";
    public static final String DEFAULT_HELP_FILE_TYPE = "html";
    public static final String[] VALID_HELP_FILE_TYPES = new String[]{"html", "xhtml", "pdf", "gif", "jpg", "jpeg", "png"};
    public static final String VALID_HELP_FILE_TYPES_CSV = StrUtils.disclose(Arrays.toString(VALID_HELP_FILE_TYPES), '[', ']');
    public static final String JAVA_CLASS_NAME_REGEX = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*";
    public static final String FONT_AWESOME_CLASS_REGEX = "^.*\\bfa[a-z]?(\\sfa[a-z]?\\-[a-z\\-]*)+.*$";
    public static final String UNICODE_SYMBOL_CLASS_REGEX = "^.*\\bxs[a-z]?(\\sxs[a-z]?\\-[a-z\\-]*)+.*$";
    public static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    public static final String PHONE_REGEX = "^\\+(?:\\d{1,3})[-\\s](?:\\d{1,4})(?:[-\\s]?\\d{6,10})$";
    public static final String LOCAL_PHONE_REGEX = "^(?:\\d{1,4})(?:[-\\s]?\\d{6,10})$";
    private static final String url_regex = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    public static final String URL_REGEX = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$";
    private static final String iframe_ini_regex = "(?:<iframe\\b[^>]*)";
    private static final String iframe_src_regex = "\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\"";
    private static final String iframe_end_regex = "(?:(?:\\/>)|(?:>.*?<\\/iframe>))";
    public static final String iframe_regex = "(?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))";
    public static final String IFRAME_REGEX = "^(?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))$";
    public static final String IFRAME_SIMPLE_PATTERN = "<iframe src=\"{0}\" width=\"{1}\" height=\"{2}\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>";
    public static final String EMBEDDED_DOCUMENT_REGEX = "^((?:<iframe\\b[^>]*)\\bsrc=\"(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]\".*(?:(?:\\/>)|(?:>.*?<\\/iframe>))|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])$";
    public static final String HELP_FILE_NAME_REGEX = "^/?([\\w-]+/)*[\\w-]+\\.[a-zA-Z]+$";
    public static final String SNIPPET_FILE_NAME_REGEX = "^/?([\\w-]+/)*[\\w-]+(\\.[a-zA-Z]+)?$";
    public static final String WHITESPACELESS_REGEX = "^[\\S]+$";

    public static int getDefaultRowsPerPage() {
        return 10;
    }

    public static int getDefaultRowsPerPageLimit() {
        return 100;
    }

    public static int getMaximumRowsPerPageLimit() {
        return 1000;
    }

    public static int getMinimumRowsPerPageLimit() {
        return 5;
    }

    public static int getDefaultSelectRowsLimit() {
        return 100;
    }

    public static SortOption getDefaultSelectSortOption() {
        return DEFAULT_SELECT_SORT_OPTION;
    }

    public static int getDefaultReportRowsLimit() {
        return 10000;
    }

    public static SortOption getDefaultReportSortOption() {
        return DEFAULT_REPORT_SORT_OPTION;
    }

    public static int getDefaultExportRowsLimit() {
        return 10000;
    }

    public static SortOption getDefaultExportSortOption() {
        return DEFAULT_EXPORT_SORT_OPTION;
    }
}

