/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.DisplayField;
import adalid.core.DisplaySet;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.TLC;
import adalid.core.Tab;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.DisplayType;
import adalid.core.enums.HelpFileAutoName;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Property;
import adalid.core.predicates.IsDisplayJoinField;
import adalid.core.predicates.IsDisplayRootField;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.sql.QueryTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class Display
extends AbstractArtifact
implements Comparable<Display> {
    private static final Logger logger = Logger.getLogger(Display.class);
    private static final String EOL = "\n";
    private Project _module;
    private DisplaySet _set;
    private Entity _entity;
    private EntityReference _reference;
    private Entity _master;
    private QueryTable _queryTable;
    private QueryTable _masterQueryTable;
    private DisplayType _displayType;
    private DisplayMode _displayMode;
    private DisplayFormat _displayFormat;
    private BooleanExpression _renderingFilter;
    private List<Display> _siblings;
    private List<Display> _children;
    private List<Display> _collaterals;
    private int _masterDetailViewSequence = 0;
    private String _helpDocument;
    private String _helpFileName;
    private final ByPropertyDisplaySortKey byPropertyDisplaySortKey = new ByPropertyDisplaySortKey(this);
    private final ByStepFieldIndex byStepFieldIndex = new ByStepFieldIndex(this);

    public Display(String name) {
        this._displayType = DisplayType.UNSPECIFIED;
        this._displayMode = DisplayMode.UNSPECIFIED;
        this._displayFormat = DisplayFormat.UNSPECIFIED;
        this.init(name);
    }

    private void init(String name) {
        this.setDeclared(name);
    }

    public boolean isMenuOptionEnabled() {
        return this._reference == null || this._reference.isMasterDetailViewMenuOptionEnabled(this);
    }

    public int getMasterDetailViewSequence() {
        return this._masterDetailViewSequence;
    }

    public void setMasterDetailViewSequence(int sequence) {
        this._masterDetailViewSequence = sequence;
    }

    public String getHelpDocument() {
        String helpDocument;
        if (StringUtils.isNotBlank((String)this._helpDocument)) {
            return this._helpDocument;
        }
        if (this._entity != null) {
            helpDocument = this._entity.getHelpDocument();
            switch (this._displayFormat) {
                case TABLE: {
                    helpDocument = StringUtils.defaultIfBlank((String)this._entity.getTableViewHelpDocument(), (String)helpDocument);
                    break;
                }
                case DETAIL: {
                    helpDocument = StringUtils.defaultIfBlank((String)this._entity.getDetailViewHelpDocument(), (String)helpDocument);
                    break;
                }
                case TREE: {
                    helpDocument = StringUtils.defaultIfBlank((String)this._entity.getTreeViewHelpDocument(), (String)helpDocument);
                    break;
                }
                case CONSOLE: {
                    helpDocument = StringUtils.defaultIfBlank((String)this._entity.getConsoleViewHelpDocument(), (String)helpDocument);
                }
            }
            if (StringUtils.isNotBlank((String)helpDocument)) {
                return helpDocument;
            }
        }
        if (this._module != null && StringUtils.isNotBlank((String)(helpDocument = this._module.getHelpDocument()))) {
            return helpDocument;
        }
        return TLC.getProject().getHelpDocument();
    }

    public void setHelpDocument(String document) {
        if (StringUtils.isBlank((String)document)) {
            this._helpDocument = "";
        } else if (this.isValidEmbeddedDocument(document)) {
            this._helpDocument = document;
        } else {
            logger.error((Object)(this.getName() + " help document is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getHelpFileName() {
        String helpFileName;
        if (StringUtils.isNotBlank((String)this._helpFileName)) {
            return this._helpFileName;
        }
        HelpFileAutoName helpFileAutoName = this.helpFileAutoName();
        String helpFileAutoType = this.helpFileAutoType();
        String helpFileAutoBase = helpFileAutoName.name().toLowerCase() + "/";
        if (HelpFileAutoName.DISPLAY.equals((Object)helpFileAutoName)) {
            return helpFileAutoBase + this.getName() + "." + helpFileAutoType;
        }
        if (this._entity != null) {
            helpFileName = this._entity.getHelpFileName();
            switch (this._displayFormat) {
                case TABLE: {
                    helpFileName = StringUtils.defaultIfBlank((String)this._entity.getTableViewHelpFileName(), (String)helpFileName);
                    break;
                }
                case DETAIL: {
                    helpFileName = StringUtils.defaultIfBlank((String)this._entity.getDetailViewHelpFileName(), (String)helpFileName);
                    break;
                }
                case TREE: {
                    helpFileName = StringUtils.defaultIfBlank((String)this._entity.getTreeViewHelpFileName(), (String)helpFileName);
                    break;
                }
                case CONSOLE: {
                    helpFileName = StringUtils.defaultIfBlank((String)this._entity.getConsoleViewHelpFileName(), (String)helpFileName);
                }
            }
            if (StringUtils.isNotBlank((String)helpFileName)) {
                return helpFileName;
            }
            if (HelpFileAutoName.ENTITY.equals((Object)helpFileAutoName)) {
                return helpFileAutoBase + this._entity.getName() + "." + helpFileAutoType;
            }
        }
        if (this._module != null && StringUtils.isNotBlank((String)(helpFileName = this._module.getHelpFileName()))) {
            return helpFileName;
        }
        return TLC.getProject().getHelpFileName();
    }

    public void setHelpFileName(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            this._helpFileName = "";
        } else if (this.isValidHelpFileName(fileName)) {
            if (this.isValidHelpFileType(fileName)) {
                this._helpFileName = fileName;
            } else {
                logger.error((Object)(this.getName() + " help file type is missing or invalid; valid types are: " + Project.getHelpFileTypesCSV()));
                Project.increaseParserErrorCount();
            }
        } else {
            logger.error((Object)(this.getName() + " help file name is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    private HelpFileAutoName helpFileAutoName() {
        HelpFileAutoName helpFileAutoName;
        if (this._entity != null && (helpFileAutoName = this._entity.getHelpFileAutoName()) != null && !helpFileAutoName.equals((Object)HelpFileAutoName.NONE)) {
            return helpFileAutoName;
        }
        if (this._module != null && (helpFileAutoName = this._module.getHelpFileAutoName()) != null && !helpFileAutoName.equals((Object)HelpFileAutoName.NONE)) {
            return helpFileAutoName;
        }
        return TLC.getProject().getHelpFileAutoName();
    }

    private String helpFileAutoType() {
        HelpFileAutoName helpFileAutoName;
        String helpFileAutoType;
        if (this._entity != null && StringUtils.isNotBlank((String)(helpFileAutoType = this._entity.getHelpFileAutoType())) && (helpFileAutoName = this._entity.getHelpFileAutoName()) != null && !helpFileAutoName.equals((Object)HelpFileAutoName.NONE)) {
            return helpFileAutoType;
        }
        if (this._module != null && StringUtils.isNotBlank((String)(helpFileAutoType = this._module.getHelpFileAutoType())) && (helpFileAutoName = this._module.getHelpFileAutoName()) != null && !helpFileAutoName.equals((Object)HelpFileAutoName.NONE)) {
            return helpFileAutoType;
        }
        return TLC.getProject().getHelpFileAutoType();
    }

    public Project getModule() {
        return this._module;
    }

    public void setModule(Project module) {
        this._module = module;
    }

    public DisplaySet getDisplaySet() {
        return this._set;
    }

    public void setDisplaySet(DisplaySet set) {
        this._set = set;
    }

    public Entity getEntity() {
        return this._entity;
    }

    public void setEntity(Entity entity) {
        this._entity = entity;
    }

    public EntityReference getReference() {
        return this._reference;
    }

    public void setReference(EntityReference reference) {
        this._reference = reference;
    }

    public Entity getMaster() {
        return this._master;
    }

    public void setMaster(Entity master) {
        this._master = master;
    }

    public QueryTable getQueryTable() {
        return this._queryTable;
    }

    public void setQueryTable(QueryTable queryTable) {
        this._queryTable = queryTable;
    }

    public QueryTable getMasterQueryTable() {
        return this._masterQueryTable;
    }

    public void setMasterQueryTable(QueryTable queryTable) {
        this._masterQueryTable = queryTable;
    }

    public DisplayType getDisplayType() {
        return this._displayType;
    }

    protected void setDisplayType(DisplayType displayType) {
        this._displayType = displayType;
    }

    public DisplayMode getDisplayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this._displayMode = displayMode;
    }

    public DisplayFormat getDisplayFormat() {
        return this._displayFormat;
    }

    public void setDisplayFormat(DisplayFormat displayFormat) {
        this._displayFormat = displayFormat;
    }

    public BooleanExpression getRenderingFilter() {
        return this._renderingFilter;
    }

    public void setRenderingFilter(BooleanExpression renderingFilter) {
        String message = "failed to set rendering filter of " + this.getFullName();
        if (renderingFilter == null) {
            message = message + "; supplied expression is null";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        } else {
            this._renderingFilter = renderingFilter instanceof BooleanPrimitive ? renderingFilter.isTrue() : renderingFilter;
        }
    }

    public List<Display> getSiblings() {
        Project module;
        Project project = module = this.linkOuterSiblings() ? TLC.getProject() : this._module;
        if (this._siblings == null) {
            this._siblings = new ArrayList<Display>();
            if (module != null) {
                List<? extends Display> displaysList = module.getDisplaysList();
                Collections.sort(displaysList);
                for (Display display : displaysList) {
                    if (!this.isSibling(display)) continue;
                    this._siblings.add(display);
                }
            }
        }
        return this._siblings;
    }

    public boolean isSibling(Display display) {
        return display != null && !this.equals(display) && !this.unequals((Object)this._displayMode, (Object)display.getDisplayMode()) && this.equals(this._entity, display.getEntity()) && (this._reference == display.getReference() || this.equals(this._reference, display.getReference()));
    }

    private boolean linkOuterSiblings() {
        return this._entity != null && this._entity.isLinkOuterSiblings();
    }

    public List<Display> getChildren() {
        Project module;
        Project project = module = this.linkOuterChildren() ? TLC.getProject() : this._module;
        if (this._children == null) {
            this._children = new ArrayList<Display>();
            if (module != null && this._entity != null) {
                List<? extends Display> displaysList = module.getDisplaysList();
                Collections.sort(displaysList);
                for (Display display : displaysList) {
                    if (this.unequals((Object)this._displayMode, (Object)display.getDisplayMode()) || !this.isMyChild(display)) continue;
                    this._children.add(display);
                }
            }
        }
        return this._children;
    }

    private boolean linkOuterChildren() {
        return this._entity != null && this._entity.isLinkOuterChildren();
    }

    private boolean isMyChild(Display display) {
        Entity master = display.getMaster();
        if (master == null) {
            return false;
        }
        return master.equals(this._entity) || master.getClass().isAssignableFrom(this._entity.getClass());
    }

    public List<Display> getCollaterals() {
        Project module;
        Project project = module = this.linkOuterCollaterals() ? TLC.getProject() : this._module;
        if (this._collaterals == null) {
            this._collaterals = new ArrayList<Display>();
            if (module != null && this._entity != null && this._master != null && this._reference != null) {
                List<Display> children = this.getChildren();
                List<? extends Display> displaysList = module.getDisplaysList();
                Collections.sort(displaysList);
                for (Display display : displaysList) {
                    if (this.equals(display) || this.unequals((Object)this._displayMode, (Object)display.getDisplayMode()) || children.contains(display) || !this.isMyCollateral(display)) continue;
                    this._collaterals.add(display);
                }
            }
        }
        return this._collaterals;
    }

    private boolean linkOuterCollaterals() {
        return this._entity != null && this._entity.isLinkOuterCollaterals();
    }

    private boolean isMyCollateral(Display display) {
        Class<?> claseMaestro;
        Entity entity = display.getEntity();
        Entity master = display.getMaster();
        EntityReference reference = display.getReference();
        if (entity == null || master == null || reference == null) {
            return false;
        }
        if (master.equals(this._master)) {
            return !reference.equals(this._reference);
        }
        Class<?> masterClass = this._master.getClass();
        return masterClass.isAssignableFrom(claseMaestro = master.getClass()) || claseMaestro.isAssignableFrom(masterClass);
    }

    public abstract List<? extends DisplayField> getFields();

    public abstract List<? extends DisplayField> getFields(boolean var1);

    public abstract List<? extends DisplayField> getMasterHeadingFields();

    public abstract List<? extends DisplayField> getMasterHeadingFields(boolean var1);

    public Set<Entity> getEntitiesReferencedByFields() {
        return this.getEntitiesReferencedByFields(false);
    }

    public Set<Entity> getEntitiesReferencedByFields(boolean hidden) {
        return null;
    }

    public List<String> getFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<? extends DisplayField> fields = this.getFields();
        for (DisplayField displayField : fields) {
            names.add(displayField.getName());
        }
        return names;
    }

    public List<? extends DisplayField> getRootFields() {
        ArrayList<? extends DisplayField> fields = new ArrayList<DisplayField>(this.getFields());
        CollectionUtils.filter(fields, (Predicate)new IsDisplayRootField());
        Collections.sort(fields, this.byPropertyDisplaySortKey);
        return fields;
    }

    public List<? extends DisplayField> getRootFields(Step step) {
        ArrayList<DisplayField> fields = new ArrayList<DisplayField>();
        for (DisplayField displayField : this.getRootFields()) {
            if (!step.equals(displayField.getStep())) continue;
            fields.add(displayField);
        }
        Collections.sort(fields, this.byStepFieldIndex);
        return fields;
    }

    public List<? extends DisplayField> getRootFields(Tab tab) {
        ArrayList<DisplayField> fields = new ArrayList<DisplayField>();
        for (DisplayField displayField : this.getRootFields()) {
            if (!displayField.isInTab(tab)) continue;
            fields.add(displayField);
        }
        Collections.sort(fields, new ByTabFieldIndex(this, tab));
        return fields;
    }

    public List<? extends DisplayField> getRootMasterHeadingFields() {
        ArrayList<? extends DisplayField> fields = new ArrayList<DisplayField>(this.removeRootMasterHeadingFields(this.getMasterHeadingFields()));
        CollectionUtils.filter(fields, (Predicate)new IsDisplayRootField());
        Collections.sort(fields, this.byPropertyDisplaySortKey);
        return fields;
    }

    private List<? extends DisplayField> removeRootMasterHeadingFields(List<? extends DisplayField> fields) {
        if (this._master == null || this._reference == null) {
            return fields;
        }
        Property[] array = this._entity.getRemoveHeadingPropertyArray();
        if (array == null || array.length == 0) {
            return fields;
        }
        ArrayList<DisplayField> campos = new ArrayList<DisplayField>();
        String fieldPropertyPrefix = this._master.getFullName() + ".";
        String arrayPropertyPrefix = this._reference.getFullName() + ".";
        boolean removePropertiesInArray = this._entity.isRemovePropertiesInRemoveHeadingPropertyArray();
        block0: for (DisplayField displayField : fields) {
            Property fieldProperty = displayField.getProperty();
            if (fieldProperty == null || !fieldProperty.getFullName().startsWith(fieldPropertyPrefix)) continue;
            for (Property arrayProperty : array) {
                if (!arrayProperty.getFullName().startsWith(arrayPropertyPrefix) || !fieldProperty.getName().equals(arrayProperty.getName())) continue;
                if (removePropertiesInArray) continue block0;
                campos.add(displayField);
                continue block0;
            }
            if (!removePropertiesInArray) continue;
            campos.add(displayField);
        }
        return campos;
    }

    public List<String> getRootFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<? extends DisplayField> fields = this.getRootFields();
        for (DisplayField displayField : fields) {
            names.add(displayField.getName());
        }
        return names;
    }

    public List<? extends DisplayField> getJoinFields() {
        ArrayList<? extends DisplayField> fields = new ArrayList<DisplayField>(this.getFields());
        CollectionUtils.filter(fields, (Predicate)new IsDisplayJoinField());
        return fields;
    }

    public List<String> getJoinFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<? extends DisplayField> fields = this.getJoinFields();
        for (DisplayField displayField : fields) {
            names.add(displayField.getName());
        }
        return names;
    }

    public List<Entity> getOverlayEntitiesList() {
        if (this._entity != null) {
            if (DisplayFormat.TREE.equals((Object)this._displayFormat)) {
                if (this._entity.isOverlayableEntity()) {
                    ArrayList<Entity> list = new ArrayList<Entity>();
                    list.add(this._entity);
                    return list;
                }
            } else {
                Map<String, Entity> map = this._entity.getOverlayEntitiesMap();
                List<? extends DisplayField> rootMasterHeadingFields = this.getRootMasterHeadingFields();
                if (this._master != null && rootMasterHeadingFields != null) {
                    for (DisplayField displayField : rootMasterHeadingFields) {
                        Property property = displayField.getProperty();
                        if (property == null || !property.isHeadingField() || !property.isOverlayableEntityReference()) continue;
                        Entity entity = (Entity)((Object)property);
                        map.put(entity.getRoot().getName(), entity);
                    }
                }
                return new ArrayList<Entity>(map.values());
            }
        }
        return new ArrayList<Entity>();
    }

    public boolean isApplicationDefaultLocation() {
        Entity entity = this.getEntity();
        Entity master = this.getMaster();
        return entity != null && entity.isApplicationDefaultLocation() && (entity.isBasicOperationEntity() || master == null || master.isApplicationDefaultLocation());
    }

    public boolean isChildViewDisplay() {
        Entity entity = this.getEntity();
        Entity master = this.getMaster();
        EntityReference reference = this.getReference();
        DisplayFormat displayFormat = this.getDisplayFormat();
        return entity != null && master != null && reference != null && entity.isApplicationDefaultLocation() && master.isApplicationDefaultLocation() && (reference.isOneToOne() && DisplayFormat.DETAIL.equals((Object)displayFormat) || reference.isManyToOne() && DisplayFormat.TABLE.equals((Object)displayFormat));
    }

    public boolean isCollateralViewDisplay() {
        Entity entity = this.getEntity();
        Entity master = this.getMaster();
        EntityReference reference = this.getReference();
        DisplayFormat displayFormat = this.getDisplayFormat();
        return entity != null && master != null && reference != null && entity.isApplicationDefaultLocation() && master.isApplicationDefaultLocation() && DisplayFormat.TABLE.equals((Object)displayFormat);
    }

    private boolean unequals(Object a, Object b) {
        return !this.equals(a, b);
    }

    private boolean equals(Object a, Object b) {
        return a != null && a.equals(b);
    }

    @Override
    public int compareTo(Display o) {
        if (o != null) {
            Display that = o;
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._entity != null) {
                string = (String)string + fee + tab + "entity" + faa + String.valueOf(this._entity) + foo;
            }
            if (this._reference != null) {
                string = (String)string + fee + tab + "_reference" + faa + String.valueOf(this._reference) + foo;
            }
            if (this._master != null) {
                string = (String)string + fee + tab + "_master" + faa + String.valueOf(this._master) + foo;
            }
            string = (String)string + fee + tab + "displayType" + faa + String.valueOf((Object)this._displayType) + foo;
            string = (String)string + fee + tab + "displayMode" + faa + String.valueOf((Object)this._displayMode) + foo;
            string = (String)string + fee + tab + "displayFormat" + faa + String.valueOf((Object)this._displayFormat) + foo;
        }
        return string;
    }

    class ByPropertyDisplaySortKey
    implements Comparator<DisplayField> {
        ByPropertyDisplaySortKey(Display this$0) {
        }

        @Override
        public int compare(DisplayField o1, DisplayField o2) {
            if (o1 != null && o2 != null) {
                Property p1 = o1.getProperty();
                Property p2 = o2.getProperty();
                if (p1 != null && p2 != null) {
                    return p1.getDisplaySortKey().compareTo(p2.getDisplaySortKey());
                }
            }
            return 0;
        }
    }

    class ByStepFieldIndex
    implements Comparator<DisplayField> {
        ByStepFieldIndex(Display this$0) {
        }

        @Override
        public int compare(DisplayField o1, DisplayField o2) {
            if (o1 != null && o2 != null) {
                return o1.getStepFieldIndex() - o2.getStepFieldIndex();
            }
            return 0;
        }
    }

    class ByTabFieldIndex
    implements Comparator<DisplayField> {
        private final Tab _tab;

        public ByTabFieldIndex(Display this$0, Tab tab) {
            this._tab = tab;
        }

        @Override
        public int compare(DisplayField o1, DisplayField o2) {
            if (o1 != null && o2 != null) {
                return o1.getTabFieldIndex(this._tab) - o2.getTabFieldIndex(this._tab);
            }
            return 0;
        }
    }
}

