/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.Display;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DisplaySet
extends AbstractArtifact
implements Comparable<DisplaySet> {
    private static final String EOL = "\n";
    private Entity _entity;
    private EntityReference _reference;
    private Entity _master;
    private Map<String, Display> _displays;

    public DisplaySet(String name) {
        this.init(name);
    }

    private void init(String name) {
        this.setDeclared(name);
    }

    public Entity getEntity() {
        return this._entity;
    }

    public void setEntity(Entity entity) {
        this._entity = entity;
    }

    public EntityReference getReference() {
        return this._reference;
    }

    public void setReference(EntityReference reference) {
        this._reference = reference;
    }

    public Entity getMaster() {
        return this._master;
    }

    public void setMaster(Entity master) {
        this._master = master;
    }

    public List<Display> getDisplaysList() {
        return new ArrayList<Display>(this.getDisplaysMap().values());
    }

    public Map<String, Display> getDisplaysMap() {
        if (this._displays == null) {
            this._displays = new LinkedHashMap<String, Display>();
        }
        return this._displays;
    }

    @Override
    public int compareTo(DisplaySet o) {
        if (o != null) {
            DisplaySet that = o;
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._entity != null) {
                string = (String)string + fee + tab + "entity" + faa + String.valueOf(this._entity) + foo;
            }
            if (this._reference != null) {
                string = (String)string + fee + tab + "_reference" + faa + String.valueOf(this._reference) + foo;
            }
            if (this._master != null) {
                string = (String)string + fee + tab + "_master" + faa + String.valueOf(this._master) + foo;
            }
        }
        return string;
    }
}

