/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.Key;
import adalid.core.enums.SortOption;
import adalid.core.interfaces.Property;
import adalid.core.wrappers.KeyFieldWrapper;
import org.apache.commons.lang.StringUtils;

public class KeyField
extends AbstractArtifact {
    private static final String EOL = "\n";
    private final Property _property;
    private final SortOption _sortOption;

    public Property getProperty() {
        return this._property;
    }

    public SortOption getSortOption() {
        return this._sortOption;
    }

    @Override
    public String getKeyFeatures(String prefix, String suffix) {
        return "(KeyField" + this._property.getKeyFeatures(prefix, suffix) + "," + String.valueOf((Object)this._sortOption) + ")";
    }

    KeyField(Key key, Property property) {
        this(key, property, SortOption.ASC);
    }

    KeyField(Key key, Property property, SortOption sortOption) {
        this._property = property;
        this._sortOption = sortOption;
        this.init(key);
    }

    private void init(Key key) {
        this.initDeclaringArtifact(key);
    }

    public Class<? extends KeyFieldWrapper> getDefaultWrapperClass() {
        return KeyFieldWrapper.class;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            String property = this._property == null ? "" : this._property.getName();
            string = (String)string + fee + tab + "property" + faa + property + foo;
            string = (String)string + fee + tab + "sortOption" + faa + String.valueOf((Object)this._sortOption) + foo;
        }
        return string;
    }
}

