/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.Project;
import adalid.core.interfaces.Artifact;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

public class ProjectReference {
    private Project _project;
    private final Class<?> _projectClass;
    private Artifact _declaringArtifact;
    private Field _declaringField;
    private final Map<String, Class<?>> _declaredTypes = new TreeMap();
    private final Map<String, Class<?>> _declaringTypes = new TreeMap();
    private final Project _outer;

    ProjectReference(Class<?> projectClass, Project outer) {
        this._outer = outer;
        this._project = null;
        this._projectClass = projectClass;
    }

    public Project getProject() {
        return this._project;
    }

    void setProject(Project project) {
        this._project = project;
    }

    public Class<?> getProjectClass() {
        return this._projectClass;
    }

    void putDeclaredType(Class<?> declaredType) {
        this._declaredTypes.put(declaredType.getName(), declaredType);
    }

    public Map<String, Class<?>> getDeclaredTypes() {
        return this._declaredTypes;
    }

    void putDeclaringType(Class<?> declaringType) {
        if (declaringType != null) {
            this._declaringTypes.put(declaringType.getName(), declaringType);
            if (Project.class.isAssignableFrom(declaringType)) {
                String key = declaringType.getName();
                ProjectReference reference = this._outer.getProjectReferences().get(key);
                reference.putDeclaredType(this._projectClass);
            }
        }
    }

    public Map<String, Class<?>> getDeclaringTypes() {
        return this._declaringTypes;
    }

    public Artifact getDeclaringArtifact() {
        return this._declaringArtifact;
    }

    void setDeclaringArtifact(Artifact declaringArtifact) {
        this._declaringArtifact = declaringArtifact;
    }

    public Field getDeclaringField() {
        return this._declaringField;
    }

    void setDeclaringField(Field declaringField) {
        this._declaringField = declaringField;
    }
}

