/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractArtifact;
import adalid.core.ReportField;
import adalid.core.ReportGroup;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.interfaces.PageFormat;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.page.format.DefaultPageFormat;
import adalid.core.programmers.ChiefProgrammer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Report
extends AbstractArtifact
implements Comparable<Report> {
    private static final Logger logger = Logger.getLogger(Report.class);
    private static final String EOL = "\n";
    private static final PageFormat defaultPageFormat = new DefaultPageFormat();
    private PersistentEntity _entity;
    private View _view;
    private PageFormat _pageFormat = defaultPageFormat;
    private int _interFieldGapWidth = 6;
    private final Map<ViewField, ReportGroup> _groupsMap = new LinkedHashMap<ViewField, ReportGroup>();
    private final List<ReportGroup> _groups = new ArrayList<ReportGroup>();
    private ReportGroup _detailGroup;
    private ReportGroup _lastControlGroup;
    private ReportGroup _penultimateControlGroup;
    private boolean _cntAtHand;
    private boolean _minAtHand;
    private boolean _maxAtHand;
    private boolean _sumAtHand;
    private boolean _avgAtHand;
    private boolean _devAtHand;
    private final Set<ViewFieldAggregation> _aggregations = new LinkedHashSet<ViewFieldAggregation>();

    public Report(String name) {
        if (name != null) {
            this.declare(name);
        }
    }

    private void declare(String name) {
        this.setDeclared(name);
    }

    public Report(PersistentEntity entity) {
        if (entity != null) {
            this.init(entity);
        }
    }

    private void init(PersistentEntity entity) {
        this._entity = entity;
        this._detailGroup = ReportGroup.addReportGroup(this);
        List<ReportField> fields = this._detailGroup.getFields();
        if (fields != null && !fields.isEmpty()) {
            this.resize(this._detailGroup);
        }
        Collections.sort(this._groups);
        this.setDeclared(entity.getName());
    }

    public Report(View view) {
        if (view != null) {
            this.init(view);
        }
    }

    private void init(View view) {
        this._view = view;
        this._pageFormat = view.getPageFormat();
        this._entity = view.getDeclaringPersistentEntity();
        int seq = 0;
        for (ViewField field : this._view.getViewControlFields()) {
            this._penultimateControlGroup = this._lastControlGroup;
            this._lastControlGroup = ReportGroup.addReportGroup(this, field, ++seq);
        }
        if (this._lastControlGroup != null) {
            this._lastControlGroup.setLastControl(true);
        }
        if (this._penultimateControlGroup != null) {
            this._penultimateControlGroup.setPenultimateControl(true);
        }
        this._detailGroup = ReportGroup.addReportGroup(this, view);
        for (ViewField viewField : this._view.getViewFields()) {
            ReportField reportField;
            ViewField groupField = viewField.getGroupField();
            if (groupField == null) {
                reportField = ReportField.addReportField(this._detailGroup, viewField);
                this.setReportProperties(reportField);
                continue;
            }
            ReportGroup reportGroup = this._groupsMap.get(groupField);
            if (reportGroup == null) continue;
            reportField = ReportField.addReportField(reportGroup, viewField);
            if (!viewField.isControlField()) continue;
            reportGroup.setField(reportField);
        }
        this.addAggregates();
        Collections.sort(this._groups);
        this.setDeclared(this._entity.getName() + "_" + view.getName());
        this.verifyViewFields();
    }

    public PersistentEntity getEntity() {
        return this._entity;
    }

    public View getView() {
        return this._view;
    }

    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    public String getPaperSize() {
        return this._pageFormat.getPaperSize();
    }

    public boolean isLandscapeOrientation() {
        return this._pageFormat.isLandscapeOrientation();
    }

    public boolean isPortraitOrientation() {
        return this._pageFormat.isPortraitOrientation();
    }

    public int getColumnWidth() {
        return this._pageFormat.getColumnWidth();
    }

    public int getPageWidth() {
        return this._pageFormat.getPageWidth();
    }

    public int getPageHeight() {
        return this._pageFormat.getPageHeight();
    }

    public int getTopMargin() {
        return this._pageFormat.getTopMargin();
    }

    public int getBottomMargin() {
        return this._pageFormat.getBottomMargin();
    }

    public int getLeftMargin() {
        return this._pageFormat.getLeftMargin();
    }

    public int getRightMargin() {
        return this._pageFormat.getRightMargin();
    }

    public String getTitle() {
        return StrUtils.getStringJava(this._view.getName().toUpperCase());
    }

    public int getInterFieldGapWidth() {
        return this._interFieldGapWidth;
    }

    protected void setInterFieldGapWidth(int interFieldGapWidth) {
        this._interFieldGapWidth = interFieldGapWidth;
    }

    public Map<ViewField, ReportGroup> getGroupsMap() {
        return this._groupsMap;
    }

    public List<ReportGroup> getGroups() {
        return this._groups;
    }

    public ReportGroup getDetailGroup() {
        return this._detailGroup;
    }

    public ReportGroup getLastControlGroup() {
        return this._lastControlGroup;
    }

    public ReportGroup getPenultimateControlGroup() {
        return this._penultimateControlGroup;
    }

    public boolean isCountAtHand() {
        return this._cntAtHand;
    }

    public boolean isMinAtHand() {
        return this._minAtHand;
    }

    public boolean isMaxAtHand() {
        return this._maxAtHand;
    }

    public boolean isSumAtHand() {
        return this._sumAtHand;
    }

    public boolean isAverageAtHand() {
        return this._avgAtHand;
    }

    public boolean isDeviationAtHand() {
        return this._devAtHand;
    }

    public void addAggregates() {
        if (this._sumAtHand) {
            this._aggregations.add(ViewFieldAggregation.SUM);
        }
        if (this._cntAtHand) {
            this._aggregations.add(ViewFieldAggregation.COUNT);
        }
        if (this._avgAtHand) {
            this._aggregations.add(ViewFieldAggregation.AVERAGE);
        }
        if (this._devAtHand) {
            this._aggregations.add(ViewFieldAggregation.DEVIATION);
        }
        if (this._minAtHand) {
            this._aggregations.add(ViewFieldAggregation.MINIMUM);
        }
        if (this._maxAtHand) {
            this._aggregations.add(ViewFieldAggregation.MAXIMUM);
        }
    }

    private void setReportProperties(ReportField field) {
        this._cntAtHand |= field.isCountAtHand();
        this._minAtHand |= field.isMinAtHand();
        this._maxAtHand |= field.isMaxAtHand();
        this._sumAtHand |= field.isSumAtHand();
        this._avgAtHand |= field.isAverageAtHand();
        this._devAtHand |= field.isDeviationAtHand();
    }

    public Set<ViewFieldAggregation> getAggregations() {
        return this._aggregations;
    }

    public String getAggregateFunctionName(String aggregation) {
        ViewFieldAggregation tipo = ViewFieldAggregation.valueOf(aggregation);
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        String funcion = sqlProgrammer.getSqlFunctionName(tipo);
        return funcion;
    }

    private void resize(ReportGroup group) {
        int used = 0;
        int size = 0;
        int columnWidth = this.getColumnWidth();
        ReportField last = null;
        for (ReportField field : group.getFields()) {
            int width = field.getPixels();
            if (width > 0 && used > 0) {
                width += this._interFieldGapWidth;
            }
            if (field.getPixels() <= 0 || width + used > columnWidth) continue;
            used += width;
            if (!field.isResizeable()) continue;
            last = field;
            size += field.getPixels();
        }
        int free = columnWidth - used;
        if (last != null && free > 0) {
            for (ReportField field : group.getFields()) {
                if (field.getPixels() <= 0 || used >= columnWidth) continue;
                int extra = field == last ? columnWidth - used : (field.isResizeable() ? field.getPixels() * free / size : 0);
                if (extra > field.getPixels()) {
                    extra = field.getPixels();
                }
                used += extra;
                field.setPixels(field.getPixels() + extra);
            }
        }
    }

    private void verifyViewFields() {
        int x = 0;
        int columnWidth = this.getColumnWidth();
        String viewName = this._entity.getName() + "." + this._view.getName();
        List<ReportField> fields = this._detailGroup.getFields();
        if (fields != null && !fields.isEmpty()) {
            for (ReportField field : fields) {
                int w = field.getPixels();
                if (w <= 0) continue;
                if ((x += w) > columnWidth) {
                    logger.warn((Object)("View field " + viewName + "." + field.getName() + " does not fit in the report print area"));
                    continue;
                }
                x += this._interFieldGapWidth;
            }
        }
    }

    @Override
    public int compareTo(Report that) {
        if (that != null) {
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._entity != null) {
                string = (String)string + fee + tab + "entity" + faa + String.valueOf(this._entity) + foo;
            }
            if (this._view != null) {
                string = (String)string + fee + tab + "view" + faa + String.valueOf(this._view) + foo;
            }
        }
        return string;
    }
}

