/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.Primitive;
import adalid.core.Report;
import adalid.core.ReportField;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.primitives.BinaryPrimitive;
import adalid.core.sql.QueryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ReportGroup
extends AbstractArtifact
implements Comparable<ReportGroup> {
    private static final String EOL = "\n";
    private Report _report;
    private ViewField _viewField;
    private ReportField _reportField;
    private int _sequence;
    private boolean _detail;
    private boolean _lastControl;
    private boolean _penultimateControl;
    private final List<ReportField> _fields = new ArrayList<ReportField>();
    private int _visibleFieldsCount;
    private int _minHeightToStartNewPage;

    public static ReportGroup addReportGroup(Report report) {
        return new ReportGroup(report);
    }

    public static ReportGroup addReportGroup(Report report, int sequence) {
        return new ReportGroup(report, sequence);
    }

    public static ReportGroup addReportGroup(Report report, View view) {
        return new ReportGroup(report, view);
    }

    public static ReportGroup addReportGroup(Report report, ViewField field, int sequence) {
        return new ReportGroup(report, field, sequence);
    }

    private ReportGroup(Report report) {
        ReportGroup group = this;
        if (report != null) {
            Map<String, Property> qpm;
            List<Property> columns;
            QueryTable queryTable;
            this._report = report;
            this._sequence = Integer.MAX_VALUE;
            this._detail = true;
            PersistentEntity entity = report.getEntity();
            if (entity != null && (queryTable = entity.getQueryTable()) != null && (columns = entity.getDataProviderColumnsList()) != null && !columns.isEmpty() && (qpm = entity.getQueryPropertiesMap()) != null && !qpm.isEmpty()) {
                for (Property column : columns) {
                    ReportField field;
                    if (column.isHiddenField() || !column.isReportField() || !qpm.containsKey(column.getPathString())) continue;
                    if (column instanceof Entity) {
                        Entity e = (Entity)((Object)column);
                        Property p = e.getBusinessKeyProperty();
                        if (p != null && p.isReportField() && queryTable.contains(p) && qpm.containsKey(p.getPathString())) {
                            field = ReportField.addReportField(group, p);
                            field.setParentProperty(column);
                        }
                        if (column instanceof EnumerationEntity || (p = e.getNameProperty()) == null || !p.isReportField() || !queryTable.contains(p) || !qpm.containsKey(p.getPathString())) continue;
                        field = ReportField.addReportField(group, p);
                        field.setParentProperty(column);
                        continue;
                    }
                    if (column instanceof BinaryPrimitive || !(column instanceof Primitive)) continue;
                    field = ReportField.addReportField(group, column);
                    field.setParentProperty(null);
                }
            }
            this.declare("detailGroup", report);
            this.add();
        }
    }

    private ReportGroup(Report report, int sequence) {
        this._report = report;
        this._sequence = sequence;
        this._detail = false;
        this.declare("reportGroup" + sequence, report);
        this.add();
    }

    private ReportGroup(Report report, View view) {
        this._report = report;
        this._sequence = Integer.MAX_VALUE;
        this._detail = true;
        this.declare("detailGroup", report);
        this.add();
    }

    private ReportGroup(Report report, ViewField field, int sequence) {
        String sqlAlias;
        this._report = report;
        this._viewField = field;
        this._sequence = sequence;
        this._detail = false;
        PersistentEntity entity = report == null ? null : report.getEntity();
        QueryTable queryTable = entity == null ? null : entity.getQueryTable();
        String string = sqlAlias = queryTable == null ? null : queryTable.getSqlAlias(field.getColumn());
        if (sqlAlias == null) {
            this.declare("reportGroup" + sequence, report);
        } else {
            this.declare(sqlAlias, report);
        }
        this.add();
    }

    private void declare(String name, Report report) {
        this.setDeclared(name, report);
    }

    private void add() {
        if (this._viewField != null) {
            this._report.getGroupsMap().put(this._viewField, this);
        }
        this._report.getGroups().add(this);
    }

    public int getIndex() {
        return this._report == null ? 0 : this._report.getGroups().indexOf(this) + 1;
    }

    public Report getReport() {
        return this._report;
    }

    public ViewField getViewField() {
        return this._viewField;
    }

    protected void setViewField(ViewField field) {
        this._viewField = field;
    }

    public ReportField getField() {
        return this._reportField;
    }

    void setField(ReportField field) {
        this._reportField = field;
    }

    public Integer getSequence() {
        return this._sequence;
    }

    public boolean isDetail() {
        return this._detail;
    }

    protected void setDetail(boolean detail) {
        this._detail = detail;
    }

    public boolean isLastControl() {
        return this._lastControl;
    }

    void setLastControl(boolean b) {
        this._lastControl = b;
    }

    public boolean isPenultimateControl() {
        return this._penultimateControl;
    }

    void setPenultimateControl(boolean b) {
        this._penultimateControl = b;
    }

    public List<ReportField> getFields() {
        return this._fields;
    }

    public int getVisibleFieldsCount() {
        return this._visibleFieldsCount;
    }

    void increaseVisibleFieldsCount() {
        ++this._visibleFieldsCount;
    }

    public int getMinHeightToStartNewPage() {
        return this._minHeightToStartNewPage;
    }

    public int increaseMinHeightToStartNewPage(int height) {
        this._minHeightToStartNewPage += height;
        return this._minHeightToStartNewPage;
    }

    public int resetMinHeightToStartNewPage() {
        this._minHeightToStartNewPage = 0;
        return this._minHeightToStartNewPage;
    }

    @Override
    public int compareTo(ReportGroup that) {
        return that == null ? 0 : this.getSequence().compareTo(that.getSequence());
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "sequence" + faa + this._sequence + foo;
            string = (String)string + fee + tab + "detail" + faa + this._detail + foo;
        }
        return string;
    }
}

