/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.AbstractArtifact;
import adalid.core.EntityCollection;
import adalid.core.Step;
import adalid.core.interfaces.Property;
import org.apache.commons.lang.StringUtils;

public class StepField
extends AbstractArtifact {
    private static final String EOL = "\n";
    private final Property _property;
    private final EntityCollection _entityCollection;

    public Property getProperty() {
        return this._property;
    }

    public EntityCollection getEntityCollection() {
        return this._entityCollection;
    }

    StepField(Step step, Property property) {
        this._property = property;
        this._entityCollection = null;
        this.init(step);
    }

    StepField(Step step, EntityCollection collection) {
        this._property = null;
        this._entityCollection = collection;
        this.init(step);
    }

    private void init(Step step) {
        this.initDeclaringArtifact(step);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            String property = this._property == null ? "" : this._property.getName();
            string = (String)string + fee + tab + "property" + faa + property + foo;
            String collection = this._entityCollection == null ? "" : this._entityCollection.getName();
            string = (String)string + fee + tab + "property" + faa + collection + foo;
        }
        return string;
    }
}

