/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.StrUtils;
import adalid.core.AbstractArtifact;
import adalid.core.DisplayField;
import org.apache.commons.lang.StringUtils;

public abstract class UIComponent
extends AbstractArtifact {
    private static final String EOL = "\n";
    private final DisplayField _field;

    public UIComponent(DisplayField field) {
        this._field = field;
        this.init(field);
    }

    private void init(DisplayField field) {
        this.setDeclared(this.name(field));
    }

    public DisplayField getField() {
        return this._field;
    }

    private String name(DisplayField field) {
        String name = field.getName();
        String prefix = this.string("prefix");
        String suffix = this.string("suffix");
        return StrUtils.getCamelCase(prefix + name + suffix, "", true);
    }

    private String string(String keyword) {
        String uic = this.getClass().getSimpleName();
        String key = uic + ".name." + keyword;
        return Bundle.getTrimmedToEmptyString(key);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "field" + faa + String.valueOf(this._field) + foo;
        }
        return string;
    }
}

