/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.Project;
import org.apache.log4j.Logger;

class WHR {
    private static final Logger logger = Logger.getLogger(WHR.class);
    static final int LARGE_SIZE = 0;
    static final int MEDIUM_SIZE = 1;
    static final int SMALL_SIZE = 2;
    static final int MIN_DOC_W = 144;
    static final int MIN_DOC_H = 144;
    static final int MIN_IMG_W = 24;
    static final int MIN_IMG_H = 24;
    static final String[] COMPONENT_DISPLAY_SIZE = new String[]{"large", "medium", "small"};
    static final int[] DEF_DOC_W = new int[]{640, 480, 320};
    static final int[] DEF_DOC_H = new int[]{360, 270, 180};
    static final int[] DEF_IMG_W = new int[]{288, 192, 96};
    static final int[] DEF_IMG_H = new int[]{288, 192, 96};
    final int displayWidth;
    final int displayHeight;
    final boolean resizable;

    WHR(String fieldName, boolean log, int size, int displayWidth, int displayHeight, int minimumWidth, int minimumHeight, int defaultWidth, int defaultHeight) {
        if (log) {
            logger.trace((Object)(fieldName + "\tS0=" + size + "\tW0=" + displayWidth + "\tH0=" + displayHeight + "\tW1=" + defaultWidth + "\tH1=" + defaultHeight));
        }
        if (displayWidth < 1) {
            displayWidth = 0;
        } else if (displayWidth < minimumWidth || displayWidth > 1920) {
            displayWidth = 0;
            if (log) {
                logger.error((Object)(fieldName + " has an invalid " + COMPONENT_DISPLAY_SIZE[size] + " display width"));
                Project.increaseParserErrorCount();
            }
        }
        if (displayHeight < 1) {
            displayHeight = 0;
        } else if (displayHeight < minimumHeight || displayHeight > 1080) {
            displayHeight = 0;
            if (log) {
                logger.error((Object)(fieldName + " has an invalid " + COMPONENT_DISPLAY_SIZE[size] + " display height"));
                Project.increaseParserErrorCount();
            }
        }
        boolean resized = false;
        if (displayWidth == 0 && displayHeight == 0) {
            displayWidth = defaultWidth;
            displayHeight = defaultHeight;
            resized = true;
        } else if (displayWidth == 0) {
            displayWidth = displayHeight;
            resized = true;
        } else if (displayHeight == 0) {
            displayHeight = displayWidth > 1080 ? 1080 : displayWidth;
            resized = true;
        }
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.resizable = resized;
        if (log) {
            logger.trace((Object)(fieldName + "\tS2=" + size + "\tW2=" + this.displayWidth + "\tH2=" + this.displayHeight + "\tR2=" + this.resizable));
        }
    }
}

