/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ThrowableUtils;
import adalid.core.AbstractArtifact;
import adalid.core.AbstractDataArtifact;
import adalid.core.AbstractEntity;
import adalid.core.FieldAllocationSettings;
import adalid.core.NamedValueCache;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.View;
import adalid.core.XS2;
import adalid.core.annotations.AbstractClass;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.CastingField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.ImageProperty;
import adalid.core.annotations.InactiveIndicator;
import adalid.core.annotations.InheritanceMapping;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParentProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.SequenceProperty;
import adalid.core.annotations.StateProperty;
import adalid.core.annotations.UniqueKey;
import adalid.core.annotations.UrlProperty;
import adalid.core.annotations.UserProperty;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.InheritanceMappingStrategy;
import adalid.core.enums.KeyProperty;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.exceptions.UnexpectedRuntimeException;
import adalid.core.expressions.BooleanX;
import adalid.core.expressions.CharacterX;
import adalid.core.expressions.EntityX;
import adalid.core.expressions.NumericX;
import adalid.core.expressions.TemporalX;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.AnnotatableArtifact;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.PersistentEnumerationEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.primitives.CharacterPrimitive;
import adalid.core.primitives.NumericPrimitive;
import adalid.core.primitives.TemporalPrimitive;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class XS1 {
    private static final Logger logger = Logger.getLogger(XS1.class);
    private static final String TAB = "\t";
    private static final String THAT_CLASS = XS2.class.getName();
    private static final String THIS_CLASS = XS1.class.getName();
    private static final String THIS_PACKAGE = XS1.class.getPackageName();
    private static final Map<KeyProperty, Class<? extends Annotation>> keyPropertyAnnotation = new LinkedHashMap<KeyProperty, Class<? extends Annotation>>();
    static final Map<KeyProperty, Class<?>[]> keyPropertyValidTypes;
    private static final boolean UNLIMITED_ACCESS = true;

    XS1() {
    }

    static boolean checkAccess() {
        return true;
    }

    static Class<?> getAnnotatedClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null || annotationClass == null) {
            return null;
        }
        if (clazz.isAnnotationPresent(annotationClass)) {
            return clazz;
        }
        return XS1.getAnnotatedClass(clazz.getSuperclass(), annotationClass);
    }

    static Class<?> getNamedClass(Object object) {
        assert (object != null);
        return XS1.getNamedClass(object.getClass());
    }

    static Class<?> getNamedClass(Class<?> clazz) {
        assert (clazz != null);
        return clazz.isAnonymousClass() ? clazz.getSuperclass() : clazz;
    }

    static Class<?> getConcreteSuperclass(Class<?> c) {
        if (c == null) {
            return null;
        }
        Class<?> s = c.getSuperclass();
        if (s == null) {
            return null;
        }
        if (c.isAnonymousClass()) {
            return XS1.getConcreteSuperclass(s);
        }
        int modifiers = s.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return null;
        }
        if (s.getSimpleName().equals(c.getSimpleName())) {
            return XS1.getConcreteSuperclass(s);
        }
        return s;
    }

    static List<Field> getFields(Class<?> clazz, Class<?> top) throws SecurityException {
        return XS1.getFields(clazz, top, Object.class);
    }

    static List<Field> getFields(Class<?> clazz, Class<?> top, Class<?> fieldType) throws SecurityException {
        return XS1.getFields(clazz, top, fieldType, null);
    }

    static List<Field> getFields(Class<?> clazz, Class<?> top, Class<?> fieldType, Class<? extends Annotation> annotationClass) throws SecurityException {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (clazz == null || top == null || fieldType == null || !top.isAssignableFrom(clazz)) {
            return fields;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            logger.trace((Object)clazz.getName());
        } else {
            logger.trace((Object)(clazz.getName() + " extends " + superClazz.getName()));
            if (top.isAssignableFrom(superClazz)) {
                List<Field> superFields = XS1.getFields(superClazz, top, fieldType);
                for (Field field : superFields) {
                    if (!XS1.valid(field, fieldType, annotationClass)) continue;
                    fields.add(field);
                }
            }
        }
        if (top.isAssignableFrom(clazz)) {
            logger.trace((Object)("adding fields declared at " + clazz.getName()));
            Field[] declaredFields = clazz.getDeclaredFields();
            for (Field field : declaredFields) {
                if (!XS1.valid(field, fieldType, annotationClass)) continue;
                fields.add(field);
            }
        }
        return XS1.getRidOfDupFields(fields);
    }

    private static boolean valid(Field field, Class<?> fieldType, Class<? extends Annotation> annotationClass) {
        if (fieldType.isAssignableFrom(field.getType()) && (annotationClass == null || field.isAnnotationPresent(annotationClass))) {
            int modifiers = field.getModifiers();
            boolean restricted = Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers);
            return !restricted;
        }
        return false;
    }

    private static List<Field> getRidOfDupFields(List<Field> fields) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Field field : fields) {
            String key = field.getName();
            if (map.containsKey(key)) {
                TLC.getProject().getParser().error("Field " + key + " hides another field");
                logger.error((Object)("\thiding field: " + String.valueOf(field)));
                logger.error((Object)("\thidden field: " + String.valueOf(map.get(key))));
            }
            map.put(key, field);
        }
        return new ArrayList<Field>(map.values());
    }

    static List<Field> getEntityFields(Class<?> clazz, Class<?> top, Class<?> fieldType) throws SecurityException {
        return clazz == null || top == null || fieldType == null || !top.isAssignableFrom(clazz) ? new ArrayList<Field>() : XS1.efields(clazz, top, fieldType);
    }

    private static List<Field> efields(Class<?> clazz, Class<?> top, Class<?> fieldType) throws SecurityException {
        Class<?> superType;
        List<Field> fields = XS1.getFields(clazz, top, fieldType);
        if (fields.isEmpty() && (superType = fieldType.getSuperclass()) != null && superType.getSimpleName().equals(fieldType.getSimpleName())) {
            fields = XS1.efields(clazz, top, superType);
        }
        return fields;
    }

    static Object initialiseField(Object declaringObject, Field declaringField) {
        return XS1.initialiseField(declaringObject, declaringField, null, true);
    }

    static Object initialiseField(Object declaringObject, Field declaringField, Class<?> declaringFieldClass) {
        return XS1.initialiseField(declaringObject, declaringField, declaringFieldClass, true);
    }

    private static Object initialiseField(Object declaringObject, Field declaringField, Class<?> declaringFieldClass, boolean casting) {
        Class<?> declaringFieldType;
        if (declaringObject == null || declaringField == null) {
            return null;
        }
        String declaringFieldName = declaringField.getName();
        Class<?> clazz = declaringFieldType = declaringFieldClass != null ? declaringFieldClass : declaringField.getType();
        if (NamedValue.class.equals(declaringFieldType)) {
            return NamedValueCache.getInstance(declaringFieldName);
        }
        String fieldName = declaringFieldName;
        Class<?> fieldType = XS1.getFieldType(declaringFieldType);
        if (fieldType == null) {
            return null;
        }
        Object instance = null;
        Class<?> declaringClass = declaringObject.getClass();
        Class<?> enclosingClass = fieldType.getEnclosingClass();
        boolean memberClass = fieldType.isMemberClass();
        Entity declaringEntity = declaringObject instanceof Entity ? (Entity)declaringObject : null;
        Artifact declaringArtifact = declaringObject instanceof Artifact ? (Artifact)declaringObject : null;
        boolean declaringArtifactIsParameter = false;
        if (declaringObject instanceof DataArtifact) {
            DataArtifact declaringDataArtifact = (DataArtifact)declaringObject;
            declaringArtifactIsParameter = declaringDataArtifact.isParameter();
        }
        String errmsg = "failed to create a new instance of field " + String.valueOf(declaringField) + " at " + String.valueOf(declaringObject);
        try {
            CastingField castingFieldAnnotation;
            CastingField castingField = castingFieldAnnotation = casting ? XS1.getCastingFieldAnnotation(declaringField, fieldType) : null;
            if (castingFieldAnnotation != null) {
                String name = castingFieldAnnotation.value();
                Field field = XS1.getFieldToBeCasted(true, fieldName, name, declaringClass, fieldType);
                if (field != null) {
                    Artifact castedArtifact;
                    Class<?> castedArtifactClass;
                    errmsg = "failed to set casting field " + String.valueOf(declaringField) + " at " + String.valueOf(declaringObject);
                    instance = field.get(declaringObject);
                    if (instance instanceof Artifact && !fieldType.isAssignableFrom(castedArtifactClass = (castedArtifact = (Artifact)instance).getClass())) {
                        Object castingInstance;
                        instance = null;
                        if (castedArtifactClass.isAssignableFrom(fieldType) && (castingInstance = XS1.initialiseField(declaringObject, declaringField, declaringFieldType, false)) instanceof AbstractArtifact) {
                            AbstractArtifact castingArtifact = (AbstractArtifact)castingInstance;
                            Field castedArtifactDeclaringField = castedArtifact.getDeclaringField();
                            Artifact castedArtifactDeclaringArtifact = castedArtifact.getDeclaringArtifact();
                            castingArtifact.setName(castedArtifact.getName());
                            castingArtifact.setDeclaringArtifact(castedArtifactDeclaringArtifact);
                            castingArtifact.setDeclaringField(castedArtifactDeclaringField);
                            castedArtifactDeclaringField.set(castedArtifactDeclaringArtifact, castingArtifact);
                            instance = castingArtifact;
                        }
                    }
                }
            } else if (memberClass && enclosingClass != null && enclosingClass.isAssignableFrom(declaringClass)) {
                if (Operation.class.isAssignableFrom(fieldType)) {
                    if (declaringArtifact == null) {
                        instance = fieldType.getConstructor(enclosingClass).newInstance(declaringObject);
                    } else if (declaringEntity == null) {
                        TLC.setDeclaringArtifact(declaringArtifact);
                        TLC.setDeclaringField(declaringField);
                        instance = fieldType.getConstructor(enclosingClass).newInstance(declaringObject);
                        TLC.removeDeclaringArtifact();
                        TLC.removeDeclaringField();
                    } else {
                        String key = fieldType.getSimpleName();
                        Map<String, Class<?>> map = declaringEntity.getOperationClassesMap();
                        Class<?> fieldTypeX = map.containsKey(key) ? map.get(key) : fieldType;
                        Class<?> enclosingClassX = fieldTypeX.getEnclosingClass();
                        TLC.setDeclaringArtifact(declaringArtifact);
                        TLC.setDeclaringField(declaringField);
                        instance = fieldTypeX.getConstructor(enclosingClassX).newInstance(declaringObject);
                        TLC.removeDeclaringArtifact();
                        TLC.removeDeclaringField();
                    }
                } else if (declaringArtifact == null) {
                    instance = fieldType.getConstructor(enclosingClass).newInstance(declaringObject);
                } else {
                    TLC.setDeclaringArtifact(declaringArtifact);
                    TLC.setDeclaringField(declaringField);
                    instance = fieldType.getConstructor(enclosingClass).newInstance(declaringObject);
                    TLC.removeDeclaringArtifact();
                    TLC.removeDeclaringField();
                }
            } else if (enclosingClass == null) {
                if (Entity.class.isAssignableFrom(fieldType)) {
                    if (declaringArtifact == null) {
                        instance = fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        Class<?> trueType = XS1.getTrueType(fieldType);
                        XS1.checkAbstractClassReference(declaringField, trueType);
                        String fullName = declaringArtifact.getFullName() + "." + fieldName;
                        String path = declaringArtifact.getClassPath();
                        int depth = declaringArtifact.depth() + 1;
                        int round = XS1.round(trueType, declaringArtifact);
                        TLC.getProject().getParser().setMaxDepthReached(depth);
                        TLC.getProject().getParser().setMaxRoundReached(round);
                        FieldAllocationSettings settings = new FieldAllocationSettings(declaringField, declaringObject, depth, round);
                        boolean fair = settings.isAllocatable(fullName);
                        int maxDepth = settings.getMaxDepth();
                        int maxRound = settings.getMaxRound();
                        String method1 = "allocate(maxDepth={0}, maxRound={1})";
                        String method2 = MessageFormat.format(method1, maxDepth, maxRound);
                        String remarks = fieldType.equals(trueType) ? null : "fieldType=" + fieldType.getName() + ", trueType=" + trueType.getName();
                        Class<?> type = fieldType;
                        if (fair || declaringArtifactIsParameter || declaringArtifact.depth() == 0 || depth <= maxDepth && round <= maxRound) {
                            TLC.getProject().getParser().track(depth, round, path, type, fieldName, method2, remarks);
                            instance = type.getConstructor(Artifact.class, Field.class).newInstance(declaringObject, declaringField);
                            TLC.getProject().getParser().addEntity((Entity)instance, fullName, depth, round, maxDepth, maxRound);
                        }
                    }
                } else if (declaringArtifact == null) {
                    instance = fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    TLC.setDeclaringArtifact(declaringArtifact);
                    TLC.setDeclaringField(declaringField);
                    instance = fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    TLC.removeDeclaringArtifact();
                    TLC.removeDeclaringField();
                }
            }
            if (instance instanceof AbstractArtifact) {
                AbstractArtifact abstractArtifact = (AbstractArtifact)instance;
                abstractArtifact.setName(fieldName);
                abstractArtifact.setDeclaringArtifact(declaringArtifact);
                abstractArtifact.setDeclaringField(declaringField);
                if (instance instanceof VariantX) {
                    VariantX variantX = (VariantX)instance;
                    variantX.setDataType(declaringFieldType);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new InstantiationRuntimeException(errmsg, ex);
        }
        return instance;
    }

    private static void checkAbstractClassReference(Field declaringField, Class<?> type) {
        if (type.isAnnotationPresent(AbstractClass.class)) {
            String message = "Abstract Class Reference: " + String.valueOf(declaringField) + "; " + type.getSimpleName() + " is annotated with AbstractClass";
            if (type.isAnnotationPresent(InheritanceMapping.class)) {
                InheritanceMapping annotation = type.getAnnotation(InheritanceMapping.class);
                message = message + " and its inheritance mapping strategy is " + String.valueOf((Object)annotation.strategy());
                if (InheritanceMappingStrategy.TABLE_PER_CLASS.equals((Object)annotation.strategy())) {
                    TLC.getProject().getParser().error(message);
                }
            }
        }
    }

    private static Class<?> getFieldType(Class<?> fieldType) {
        if (fieldType.isInterface() && Expression.class.isAssignableFrom(fieldType)) {
            if (EntityExpression.class.isAssignableFrom(fieldType)) {
                return EntityX.class;
            }
            if (BooleanExpression.class.isAssignableFrom(fieldType)) {
                return BooleanX.class;
            }
            if (CharacterExpression.class.isAssignableFrom(fieldType)) {
                return CharacterX.class;
            }
            if (NumericExpression.class.isAssignableFrom(fieldType)) {
                return NumericX.class;
            }
            if (TemporalExpression.class.isAssignableFrom(fieldType)) {
                return TemporalX.class;
            }
            return VariantX.class;
        }
        return XS1.isRestrictedFieldType(fieldType) ? null : fieldType;
    }

    private static boolean isRestrictedFieldType(Class<?> fieldType) {
        int modifiers = fieldType.getModifiers();
        boolean b = fieldType.isPrimitive();
        b |= Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers);
        b |= fieldType.isAnnotation();
        b |= fieldType.isAnonymousClass();
        b |= fieldType.isArray();
        b |= fieldType.isEnum();
        b |= fieldType.isLocalClass();
        return b |= fieldType.isInterface();
    }

    private static CastingField getCastingFieldAnnotation(Field declaringField, Class<?> fieldType) {
        if (Property.class.isAssignableFrom(fieldType) && declaringField.isAnnotationPresent(CastingField.class)) {
            return declaringField.getAnnotation(CastingField.class);
        }
        return null;
    }

    private static Field getFieldToBeCasted(boolean log, String casting, String toBeCasted, Class<?> declaringClass, Class<?> fieldType) {
        String role = StringUtils.isBlank((String)casting) ? "casting" : casting;
        String name = StringUtils.trimToEmpty((String)toBeCasted);
        String annotation = CastingField.class.getSimpleName();
        if (StringUtils.isBlank((String)toBeCasted)) {
            String remarks = "null field name in " + annotation + " annotation";
            if (log) {
                XS1.logFieldErrorMessage(role, name, declaringClass, null, remarks);
            }
        } else if (toBeCasted.equals(casting)) {
            String remarks = "same field name in " + annotation + " annotation";
            if (log) {
                XS1.logFieldErrorMessage(role, name, declaringClass, null, remarks);
            }
        } else {
            Class<?> top = XS1.getFieldToBeCastedTopClass(declaringClass);
            return XS1.getField(log, role, name, declaringClass, top, fieldType);
        }
        return null;
    }

    private static Class<?> getFieldToBeCastedTopClass(Class<?> declaringClass) {
        return declaringClass == null ? null : (Entity.class.isAssignableFrom(declaringClass) ? Entity.class : (Operation.class.isAssignableFrom(declaringClass) ? Operation.class : Artifact.class));
    }

    static Field getField(boolean log, String role, String name, Class<?> type, Class<?> top, Class<?> ... validTypes) {
        int length;
        if (StringUtils.isBlank((String)role)) {
            String string = "field role is missing or invalid";
            if (log) {
                XS1.logFieldErrorMessage(role, name, type, null, string);
            }
            return null;
        }
        if (StringUtils.isBlank((String)name)) {
            String string = "field name is missing or invalid";
            if (log) {
                XS1.logFieldErrorMessage(role, name, type, null, string);
            }
            return null;
        }
        if (type == null) {
            String string = "class is missing or invalid";
            if (log) {
                XS1.logFieldErrorMessage(role, name, type, null, string);
            }
            return null;
        }
        Field field = XS1.getField(name, type, top);
        if (field == null) {
            String string = "field " + name + " not in class";
            if (log) {
                XS1.logFieldErrorMessage(role, name, type, field, string);
            }
            return null;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            String string = "field " + name + " has static and/or final modifier";
            if (log) {
                XS1.logFieldErrorMessage(role, name, type, field, string);
            }
            return null;
        }
        int n = length = validTypes == null ? 0 : validTypes.length;
        if (length < 1) {
            return field;
        }
        Class<?> ft = XS1.getTrueType(field.getType());
        Object[] strings = new String[length];
        int i = 0;
        if (validTypes != null) {
            for (Class<?> vt : validTypes) {
                if (vt.isAssignableFrom(ft)) {
                    return field;
                }
                strings[i++] = vt.getSimpleName();
            }
        }
        String string = "type of " + name + " is not " + StringUtils.join((Object[])strings, (String)" or ");
        if (log) {
            XS1.logFieldErrorMessage(role, name, type, field, string);
        }
        return null;
    }

    private static Field getField(String name, Class<?> type, Class<?> top) {
        if (StringUtils.isNotBlank((String)name) && top.isAssignableFrom(type)) {
            for (Field field : XS1.getFields(type, top)) {
                field.setAccessible(true);
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    static Property getProperty(Field field, Object declaringObject) {
        return XS1.getProperty(field, declaringObject, false);
    }

    static Property getProperty(Field field, Object declaringObject, boolean ignoreExceptions) {
        try {
            Object object = field.get(declaringObject);
            return object instanceof Property ? (Property)object : null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            if (ignoreExceptions) {
                return null;
            }
            Throwable cause = ThrowableUtils.getCause(ex);
            String message = ex.equals(cause) ? null : ex.getMessage();
            logger.error((Object)message, cause);
            Project.increaseParserErrorCount();
            return null;
        }
    }

    static Parameter getParameter(Field field, Object declaringObject) {
        return XS1.getParameter(field, declaringObject, false);
    }

    static Parameter getParameter(Field field, Object declaringObject, boolean ignoreExceptions) {
        try {
            Object object = field.get(declaringObject);
            return object instanceof Parameter ? (Parameter)object : null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            if (ignoreExceptions) {
                return null;
            }
            Throwable cause = ThrowableUtils.getCause(ex);
            String message = ex.equals(cause) ? null : ex.getMessage();
            logger.error((Object)message, cause);
            Project.increaseParserErrorCount();
            return null;
        }
    }

    static View getView(Field field, Object declaringObject) {
        Object object = null;
        try {
            object = field.get(declaringObject);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Throwable cause = ThrowableUtils.getCause(ex);
            String message = ex.equals(cause) ? null : ex.getMessage();
            logger.error((Object)message, cause);
            Project.increaseParserErrorCount();
        }
        return object instanceof View ? (View)object : null;
    }

    static boolean checkKeyPropertyFieldAnnotation(boolean log, Field field, KeyProperty keyProperty) {
        Class<?>[] validTypes = keyPropertyValidTypes.get((Object)keyProperty);
        return XS1.checkKeyPropertyFieldAnnotation(log, field, keyProperty, validTypes);
    }

    static boolean checkKeyPropertyFieldAnnotation(boolean log, Field field, KeyProperty keyProperty, Class<?>[] validTypes) {
        Class<? extends Annotation> annotation = keyPropertyAnnotation.get((Object)keyProperty);
        return XS1.checkFieldAnnotation(log, field, annotation, validTypes);
    }

    static boolean checkFieldAnnotation(boolean log, Field field, Class<? extends Annotation> annotation, Class<?>[] validTypes) {
        int length;
        String name = field.getName();
        Class<?> type = field.getDeclaringClass();
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
            String string = "field " + name + " has static and/or final modifier";
            if (log) {
                XS1.logFieldAnnotationErrorMessage(name, type, annotation, string);
            }
            return false;
        }
        int n = length = validTypes == null ? 0 : validTypes.length;
        if (length < 1) {
            return true;
        }
        Class<?> ft = XS1.getTrueType(field.getType());
        Object[] strings = new String[length];
        int i = 0;
        if (validTypes != null) {
            for (Class<?> vt : validTypes) {
                if (vt.isAssignableFrom(ft)) {
                    return true;
                }
                strings[i++] = vt.getSimpleName();
            }
        }
        String string = "type of " + name + " is not " + StringUtils.join((Object[])strings, (String)" or ");
        if (log) {
            XS1.logFieldAnnotationErrorMessage(name, type, annotation, string);
        }
        return false;
    }

    private static void logFieldErrorMessage(String role, String name, Class<?> type, Field field, String string) {
        Object pattern = StringUtils.equals((String)role, (String)name) ? "failed to get field {0} at {2}" : "failed to get {0} field at {2}";
        if (StringUtils.isNotBlank((String)string)) {
            pattern = (String)pattern + "; {4}";
        }
        Object message = MessageFormat.format((String)pattern, role, name, type, field, string);
        TLC.getProject().getParser().error(message);
        if (StringUtils.isNotBlank((String)name) && field != null) {
            pattern = "field {1} = {3}";
            message = TAB + MessageFormat.format((String)pattern, role, name, type, field, string);
            logger.error(message);
        }
    }

    static void logDuplicateAnnotation(Field field, Class<? extends Annotation> annotation, Field previous) {
        String name = field.getName();
        Class<?> type = field.getDeclaringClass();
        String string = String.valueOf(previous) + " has the same annotation";
        XS1.logFieldAnnotationErrorMessage(name, type, annotation, string);
    }

    static void logFieldAnnotationErrorMessage(Field field, Class<?> annotation, String string) {
        String name = field.getName();
        Class<?> type = field.getDeclaringClass();
        XS1.logFieldAnnotationErrorMessage(name, type, annotation, string);
    }

    private static void logFieldAnnotationErrorMessage(String name, Class<?> type, Class<?> annotation, String string) {
        Object pattern = "failed to annotate field {0} at {1} with {2}";
        if (StringUtils.isNotBlank((String)string)) {
            pattern = (String)pattern + "; {3}";
        }
        String message = MessageFormat.format((String)pattern, name, type, annotation.getSimpleName(), string);
        TLC.getProject().getParser().error(message);
    }

    private static Class<?> getTrueType(Class<?> type) {
        if (Entity.class.isAssignableFrom(type)) {
            Class<?> trueType = TLC.getProject().getTrueType(type);
            if (trueType == null) {
                throw new UnexpectedRuntimeException("null entity reference");
            }
            return trueType;
        }
        return type;
    }

    static Field getEntityField(String name, Class<?> type) {
        Class<Entity> top = Entity.class;
        return XS1.getField(name, type, top);
    }

    static Class<?> getConstructorParameterType(Class<?> wrapper, Class<?> wrappable) {
        Constructor<?>[] constructors;
        Class<?> parameterType = null;
        for (Constructor<?> constructor : constructors = wrapper.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(wrappable) || parameterType != null && !parameterType.isAssignableFrom(parameterTypes[0])) continue;
            parameterType = parameterTypes[0];
        }
        return parameterType;
    }

    static boolean declare(Artifact artifact, Artifact declaringArtifact, Field declaringField) {
        if (artifact == null || declaringArtifact == null || declaringField == null) {
            return false;
        }
        if (artifact.isNotDeclared() && artifact instanceof AbstractArtifact) {
            AbstractArtifact a = (AbstractArtifact)artifact;
            a.setDeclared(declaringField.getName(), declaringArtifact, declaringField);
            if (artifact instanceof AnnotatableArtifact) {
                AnnotatableArtifact annotatableArtifact = (AnnotatableArtifact)artifact;
                annotatableArtifact.annotate();
            }
            if (artifact instanceof AbstractEntity) {
                AbstractEntity e = (AbstractEntity)artifact;
                e.initializeInheritanceFields();
            }
            return true;
        }
        return false;
    }

    static boolean postConstruct(Entity entity) {
        if (entity instanceof AbstractEntity) {
            AbstractEntity e = (AbstractEntity)entity;
            e.annotate();
            e.initializeInheritanceFields();
            return true;
        }
        return false;
    }

    static boolean setReferenceIndex(Entity entity, int referenceIndex) {
        if (entity instanceof AbstractEntity) {
            AbstractEntity e = (AbstractEntity)entity;
            e.setReferenceIndex(referenceIndex);
            return true;
        }
        return false;
    }

    static boolean annotateCastingField(Field declaringField, DataArtifact artifact) {
        if (artifact instanceof AbstractDataArtifact && declaringField.isAnnotationPresent(CastingField.class)) {
            AbstractDataArtifact d = (AbstractDataArtifact)artifact;
            d.annotate(declaringField);
            return true;
        }
        return false;
    }

    static int round(Class<?> clazz, Artifact artifact) {
        int hits = 0;
        if (clazz != null && artifact != null) {
            Artifact declaringArtifact;
            if (clazz.isAssignableFrom(XS1.getNamedClass(artifact))) {
                ++hits;
            }
            if ((declaringArtifact = artifact.getDeclaringArtifact()) != null) {
                hits += XS1.round(clazz, declaringArtifact);
            }
        }
        return hits;
    }

    static Object newInstance(String className) {
        Class<?> clazz = XS1.forName(className);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return null;
        }
    }

    static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        keyPropertyAnnotation.put(KeyProperty.PRIMARY_KEY, PrimaryKey.class);
        keyPropertyAnnotation.put(KeyProperty.SEQUENCE, SequenceProperty.class);
        keyPropertyAnnotation.put(KeyProperty.VERSION, VersionProperty.class);
        keyPropertyAnnotation.put(KeyProperty.NAME, NameProperty.class);
        keyPropertyAnnotation.put(KeyProperty.DESCRIPTION, DescriptionProperty.class);
        keyPropertyAnnotation.put(KeyProperty.IMAGE, ImageProperty.class);
        keyPropertyAnnotation.put(KeyProperty.INACTIVE_INDICATOR, InactiveIndicator.class);
        keyPropertyAnnotation.put(KeyProperty.URL, UrlProperty.class);
        keyPropertyAnnotation.put(KeyProperty.PARENT, ParentProperty.class);
        keyPropertyAnnotation.put(KeyProperty.OWNER, OwnerProperty.class);
        keyPropertyAnnotation.put(KeyProperty.USER, UserProperty.class);
        keyPropertyAnnotation.put(KeyProperty.SEGMENT, SegmentProperty.class);
        keyPropertyAnnotation.put(KeyProperty.UNIQUE_KEY, UniqueKey.class);
        keyPropertyAnnotation.put(KeyProperty.BUSINESS_KEY, BusinessKey.class);
        keyPropertyAnnotation.put(KeyProperty.DISCRIMINATOR, DiscriminatorColumn.class);
        keyPropertyAnnotation.put(KeyProperty.STATE, StateProperty.class);
        keyPropertyValidTypes = new LinkedHashMap<KeyProperty, Class<?>[]>();
        keyPropertyValidTypes.put(KeyProperty.PRIMARY_KEY, new Class[]{LongProperty.class, IntegerProperty.class});
        keyPropertyValidTypes.put(KeyProperty.SEQUENCE, new Class[]{LongProperty.class});
        keyPropertyValidTypes.put(KeyProperty.VERSION, new Class[]{LongProperty.class});
        keyPropertyValidTypes.put(KeyProperty.NUMERIC_KEY, new Class[]{IntegerProperty.class});
        keyPropertyValidTypes.put(KeyProperty.CHARACTER_KEY, new Class[]{StringProperty.class});
        keyPropertyValidTypes.put(KeyProperty.NAME, new Class[]{StringProperty.class});
        keyPropertyValidTypes.put(KeyProperty.DESCRIPTION, new Class[]{StringProperty.class});
        keyPropertyValidTypes.put(KeyProperty.IMAGE, new Class[]{BinaryProperty.class});
        keyPropertyValidTypes.put(KeyProperty.INACTIVE_INDICATOR, new Class[]{BooleanProperty.class});
        keyPropertyValidTypes.put(KeyProperty.URL, new Class[]{StringProperty.class});
        keyPropertyValidTypes.put(KeyProperty.PARENT, new Class[]{EntityReference.class});
        keyPropertyValidTypes.put(KeyProperty.OWNER, new Class[]{EntityReference.class});
        keyPropertyValidTypes.put(KeyProperty.USER, new Class[]{EntityReference.class});
        keyPropertyValidTypes.put(KeyProperty.SEGMENT, new Class[]{EntityReference.class, LongProperty.class});
        keyPropertyValidTypes.put(KeyProperty.UNIQUE_KEY, new Class[]{BooleanPrimitive.class, CharacterPrimitive.class, NumericPrimitive.class, TemporalPrimitive.class, EntityReference.class});
        keyPropertyValidTypes.put(KeyProperty.BUSINESS_KEY, new Class[]{StringProperty.class});
        keyPropertyValidTypes.put(KeyProperty.DISCRIMINATOR, new Class[]{PersistentEnumerationEntityReference.class});
        keyPropertyValidTypes.put(KeyProperty.STATE, new Class[]{PersistentEnumerationEntityReference.class});
    }
}

