/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.enums;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum MimeType {
    APPLICATION,
    AUDIO,
    CHEMICAL,
    DRAWING,
    I_WORLD,
    IMAGE,
    MESSAGE,
    MODEL,
    MULTIPART,
    MUSIC,
    PALEOVU,
    TEXT,
    VIDEO,
    WINDOWS,
    WWW,
    X_CONFERENCE,
    X_MUSIC,
    X_WORLD,
    XGL;

    private static final String REGEX_PREFIX = "^(.*)(\\.)(";
    private static final String REGEX_SUFFIX = ")$";

    public String getRegex() {
        return this.getRegex(false);
    }

    public String getRegex(boolean lowerAndUpperCase) {
        String extensions = this.getRegexExtensions();
        return REGEX_PREFIX + extensions + (String)(lowerAndUpperCase ? "|" + extensions.toUpperCase() : "") + REGEX_SUFFIX;
    }

    public String getRegexExtensions() {
        return Arrays.stream(this.getExtensions()).map(this::escape).collect(Collectors.joining("|"));
    }

    private String escape(String string) {
        return string.replaceAll("([\\\\.^$|?*+()\\[\\]{}])", "\\\\$1");
    }

    public String[] getExtensions() {
        String[] stringArray;
        switch (this.ordinal()) {
            case 0: {
                String[] stringArray2 = new String[266];
                stringArray2[0] = "a";
                stringArray2[1] = "aab";
                stringArray2[2] = "aam";
                stringArray2[3] = "aas";
                stringArray2[4] = "ai";
                stringArray2[5] = "aim";
                stringArray2[6] = "ani";
                stringArray2[7] = "aos";
                stringArray2[8] = "aps";
                stringArray2[9] = "arc";
                stringArray2[10] = "arj";
                stringArray2[11] = "asx";
                stringArray2[12] = "avi";
                stringArray2[13] = "bcpio";
                stringArray2[14] = "bin";
                stringArray2[15] = "boo";
                stringArray2[16] = "book";
                stringArray2[17] = "boz";
                stringArray2[18] = "bsh";
                stringArray2[19] = "bz";
                stringArray2[20] = "bz2";
                stringArray2[21] = "cat";
                stringArray2[22] = "ccad";
                stringArray2[23] = "cco";
                stringArray2[24] = "cdf";
                stringArray2[25] = "cer";
                stringArray2[26] = "cha";
                stringArray2[27] = "chat";
                stringArray2[28] = "class";
                stringArray2[29] = "com";
                stringArray2[30] = "cpio";
                stringArray2[31] = "cpt";
                stringArray2[32] = "crl";
                stringArray2[33] = "crt";
                stringArray2[34] = "csh";
                stringArray2[35] = "css";
                stringArray2[36] = "dcr";
                stringArray2[37] = "deepv";
                stringArray2[38] = "der";
                stringArray2[39] = "dir";
                stringArray2[40] = "doc";
                stringArray2[41] = "docb";
                stringArray2[42] = "docm";
                stringArray2[43] = "docx";
                stringArray2[44] = "dot";
                stringArray2[45] = "dotm";
                stringArray2[46] = "dotx";
                stringArray2[47] = "dp";
                stringArray2[48] = "drw";
                stringArray2[49] = "dump";
                stringArray2[50] = "dvi";
                stringArray2[51] = "dwg";
                stringArray2[52] = "dxf";
                stringArray2[53] = "dxr";
                stringArray2[54] = "elc";
                stringArray2[55] = "env";
                stringArray2[56] = "eps";
                stringArray2[57] = "es";
                stringArray2[58] = "evy";
                stringArray2[59] = "exe";
                stringArray2[60] = "fdf";
                stringArray2[61] = "fif";
                stringArray2[62] = "frl";
                stringArray2[63] = "gsp";
                stringArray2[64] = "gss";
                stringArray2[65] = "gtar";
                stringArray2[66] = "gz";
                stringArray2[67] = "gzip";
                stringArray2[68] = "hdf";
                stringArray2[69] = "help";
                stringArray2[70] = "hgl";
                stringArray2[71] = "hlp";
                stringArray2[72] = "hpg";
                stringArray2[73] = "hpgl";
                stringArray2[74] = "hqx";
                stringArray2[75] = "hta";
                stringArray2[76] = "iges";
                stringArray2[77] = "igs";
                stringArray2[78] = "ima";
                stringArray2[79] = "imap";
                stringArray2[80] = "inf";
                stringArray2[81] = "ins";
                stringArray2[82] = "ip";
                stringArray2[83] = "iv";
                stringArray2[84] = "ivy";
                stringArray2[85] = "jcm";
                stringArray2[86] = "js";
                stringArray2[87] = "ksh";
                stringArray2[88] = "latex";
                stringArray2[89] = "lha";
                stringArray2[90] = "lhx";
                stringArray2[91] = "lsp";
                stringArray2[92] = "ltx";
                stringArray2[93] = "lzh";
                stringArray2[94] = "lzx";
                stringArray2[95] = "man";
                stringArray2[96] = "map";
                stringArray2[97] = "mbd";
                stringArray2[98] = "mc$";
                stringArray2[99] = "mcd";
                stringArray2[100] = "mcp";
                stringArray2[101] = "me";
                stringArray2[102] = "mid";
                stringArray2[103] = "midi";
                stringArray2[104] = "mif";
                stringArray2[105] = "mm";
                stringArray2[106] = "mme";
                stringArray2[107] = "mpc";
                stringArray2[108] = "mpp";
                stringArray2[109] = "mpt";
                stringArray2[110] = "mpv";
                stringArray2[111] = "mpx";
                stringArray2[112] = "mrc";
                stringArray2[113] = "ms";
                stringArray2[114] = "mzz";
                stringArray2[115] = "nc";
                stringArray2[116] = "ncm";
                stringArray2[117] = "nix";
                stringArray2[118] = "nsc";
                stringArray2[119] = "nvd";
                stringArray2[120] = "o";
                stringArray2[121] = "oda";
                stringArray2[122] = "omc";
                stringArray2[123] = "omcd";
                stringArray2[124] = "omcr";
                stringArray2[125] = "p10";
                stringArray2[126] = "p12";
                stringArray2[127] = "p7a";
                stringArray2[128] = "p7c";
                stringArray2[129] = "p7m";
                stringArray2[130] = "p7r";
                stringArray2[131] = "p7s";
                stringArray2[132] = "part";
                stringArray2[133] = "pcl";
                stringArray2[134] = "pdf";
                stringArray2[135] = "pkg";
                stringArray2[136] = "pko";
                stringArray2[137] = "plx";
                stringArray2[138] = "pm4";
                stringArray2[139] = "pm5";
                stringArray2[140] = "pnm";
                stringArray2[141] = "pot";
                stringArray2[142] = "potm";
                stringArray2[143] = "potx";
                stringArray2[144] = "ppa";
                stringArray2[145] = "ppam";
                stringArray2[146] = "pps";
                stringArray2[147] = "ppsm";
                stringArray2[148] = "ppsx";
                stringArray2[149] = "ppt";
                stringArray2[150] = "pptm";
                stringArray2[151] = "pptx";
                stringArray2[152] = "ppz";
                stringArray2[153] = "pre";
                stringArray2[154] = "prt";
                stringArray2[155] = "ps";
                stringArray2[156] = "psd";
                stringArray2[157] = "pwz";
                stringArray2[158] = "pyc";
                stringArray2[159] = "ras";
                stringArray2[160] = "rm";
                stringArray2[161] = "rng";
                stringArray2[162] = "rnx";
                stringArray2[163] = "roff";
                stringArray2[164] = "rtf";
                stringArray2[165] = "rtx";
                stringArray2[166] = "saveme";
                stringArray2[167] = "sbk";
                stringArray2[168] = "scm";
                stringArray2[169] = "sdp";
                stringArray2[170] = "sdr";
                stringArray2[171] = "sea";
                stringArray2[172] = "set";
                stringArray2[173] = "sh";
                stringArray2[174] = "shar";
                stringArray2[175] = "sit";
                stringArray2[176] = "skd";
                stringArray2[177] = "skm";
                stringArray2[178] = "skp";
                stringArray2[179] = "skt";
                stringArray2[180] = "sl";
                stringArray2[181] = "sldm";
                stringArray2[182] = "sldx";
                stringArray2[183] = "smi";
                stringArray2[184] = "smil";
                stringArray2[185] = "sol";
                stringArray2[186] = "spc";
                stringArray2[187] = "spl";
                stringArray2[188] = "spr";
                stringArray2[189] = "sprite";
                stringArray2[190] = "src";
                stringArray2[191] = "ssm";
                stringArray2[192] = "sst";
                stringArray2[193] = "step";
                stringArray2[194] = "stl";
                stringArray2[195] = "stp";
                stringArray2[196] = "sv4cpio";
                stringArray2[197] = "sv4crc";
                stringArray2[198] = "svr";
                stringArray2[199] = "swf";
                stringArray2[200] = "t";
                stringArray2[201] = "tar";
                stringArray2[202] = "tbk";
                stringArray2[203] = "tcl";
                stringArray2[204] = "tex";
                stringArray2[205] = "texi";
                stringArray2[206] = "texinfo";
                stringArray2[207] = "text";
                stringArray2[208] = "tgz";
                stringArray2[209] = "tr";
                stringArray2[210] = "tsp";
                stringArray2[211] = "unv";
                stringArray2[212] = "ustar";
                stringArray2[213] = "uu";
                stringArray2[214] = "vcd";
                stringArray2[215] = "vda";
                stringArray2[216] = "vew";
                stringArray2[217] = "vmd";
                stringArray2[218] = "vmf";
                stringArray2[219] = "vrml";
                stringArray2[220] = "vsd";
                stringArray2[221] = "vst";
                stringArray2[222] = "vsw";
                stringArray2[223] = "w60";
                stringArray2[224] = "w61";
                stringArray2[225] = "w6w";
                stringArray2[226] = "wb1";
                stringArray2[227] = "wbk";
                stringArray2[228] = "web";
                stringArray2[229] = "wiz";
                stringArray2[230] = "wk1";
                stringArray2[231] = "wmlc";
                stringArray2[232] = "wmlsc";
                stringArray2[233] = "word";
                stringArray2[234] = "wp";
                stringArray2[235] = "wp5";
                stringArray2[236] = "wp6";
                stringArray2[237] = "wpd";
                stringArray2[238] = "wq1";
                stringArray2[239] = "wri";
                stringArray2[240] = "wrl";
                stringArray2[241] = "wsrc";
                stringArray2[242] = "wtk";
                stringArray2[243] = "xl";
                stringArray2[244] = "xla";
                stringArray2[245] = "xlam";
                stringArray2[246] = "xlb";
                stringArray2[247] = "xlc";
                stringArray2[248] = "xld";
                stringArray2[249] = "xlk";
                stringArray2[250] = "xll";
                stringArray2[251] = "xlm";
                stringArray2[252] = "xls";
                stringArray2[253] = "xlsb";
                stringArray2[254] = "xlsm";
                stringArray2[255] = "xlsx";
                stringArray2[256] = "xlt";
                stringArray2[257] = "xltm";
                stringArray2[258] = "xltx";
                stringArray2[259] = "xlv";
                stringArray2[260] = "xlw";
                stringArray2[261] = "xml";
                stringArray2[262] = "xpix";
                stringArray2[263] = "z";
                stringArray2[264] = "zip";
                stringArray = stringArray2;
                stringArray2[265] = "zoo";
                break;
            }
            case 1: {
                String[] stringArray3 = new String[46];
                stringArray3[0] = "aif";
                stringArray3[1] = "aifc";
                stringArray3[2] = "aiff";
                stringArray3[3] = "au";
                stringArray3[4] = "funk";
                stringArray3[5] = "gsd";
                stringArray3[6] = "gsm";
                stringArray3[7] = "it";
                stringArray3[8] = "jam";
                stringArray3[9] = "kar";
                stringArray3[10] = "la";
                stringArray3[11] = "lam";
                stringArray3[12] = "lma";
                stringArray3[13] = "m2a";
                stringArray3[14] = "m3u";
                stringArray3[15] = "mid";
                stringArray3[16] = "midi";
                stringArray3[17] = "mjf";
                stringArray3[18] = "mod";
                stringArray3[19] = "mp2";
                stringArray3[20] = "mp3";
                stringArray3[21] = "mpa";
                stringArray3[22] = "mpg";
                stringArray3[23] = "mpga";
                stringArray3[24] = "my";
                stringArray3[25] = "pfunk";
                stringArray3[26] = "qcp";
                stringArray3[27] = "ra";
                stringArray3[28] = "ram";
                stringArray3[29] = "rm";
                stringArray3[30] = "rmi";
                stringArray3[31] = "rmm";
                stringArray3[32] = "rmp";
                stringArray3[33] = "rpm";
                stringArray3[34] = "s3m";
                stringArray3[35] = "sid";
                stringArray3[36] = "snd";
                stringArray3[37] = "tsi";
                stringArray3[38] = "tsp";
                stringArray3[39] = "voc";
                stringArray3[40] = "vox";
                stringArray3[41] = "vqe";
                stringArray3[42] = "vqf";
                stringArray3[43] = "vql";
                stringArray3[44] = "wav";
                stringArray = stringArray3;
                stringArray3[45] = "xm";
                break;
            }
            case 2: {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "pdb";
                stringArray = stringArray4;
                stringArray4[1] = "xyz";
                break;
            }
            case 3: {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "dwf";
                break;
            }
            case 4: {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "ivr";
                break;
            }
            case 5: {
                String[] stringArray7 = new String[53];
                stringArray7[0] = "art";
                stringArray7[1] = "bm";
                stringArray7[2] = "bmp";
                stringArray7[3] = "dwg";
                stringArray7[4] = "dxf";
                stringArray7[5] = "fif";
                stringArray7[6] = "flo";
                stringArray7[7] = "fpx";
                stringArray7[8] = "g3";
                stringArray7[9] = "gif";
                stringArray7[10] = "ico";
                stringArray7[11] = "ief";
                stringArray7[12] = "iefs";
                stringArray7[13] = "jfif";
                stringArray7[14] = "jfif-tbnl";
                stringArray7[15] = "jpe";
                stringArray7[16] = "jpeg";
                stringArray7[17] = "jpg";
                stringArray7[18] = "jps";
                stringArray7[19] = "jut";
                stringArray7[20] = "mcf";
                stringArray7[21] = "nap";
                stringArray7[22] = "naplps";
                stringArray7[23] = "nif";
                stringArray7[24] = "niff";
                stringArray7[25] = "pbm";
                stringArray7[26] = "pct";
                stringArray7[27] = "pcx";
                stringArray7[28] = "pgm";
                stringArray7[29] = "pic";
                stringArray7[30] = "pict";
                stringArray7[31] = "pm";
                stringArray7[32] = "png";
                stringArray7[33] = "pnm";
                stringArray7[34] = "ppm";
                stringArray7[35] = "qif";
                stringArray7[36] = "qti";
                stringArray7[37] = "qtif";
                stringArray7[38] = "ras";
                stringArray7[39] = "rast";
                stringArray7[40] = "rf";
                stringArray7[41] = "rgb";
                stringArray7[42] = "rp";
                stringArray7[43] = "svf";
                stringArray7[44] = "tif";
                stringArray7[45] = "tiff";
                stringArray7[46] = "turbot";
                stringArray7[47] = "wbmp";
                stringArray7[48] = "x-png";
                stringArray7[49] = "xbm";
                stringArray7[50] = "xif";
                stringArray7[51] = "xpm";
                stringArray = stringArray7;
                stringArray7[52] = "xwd";
                break;
            }
            case 6: {
                String[] stringArray8 = new String[3];
                stringArray8[0] = "mht";
                stringArray8[1] = "mhtml";
                stringArray = stringArray8;
                stringArray8[2] = "mime";
                break;
            }
            case 7: {
                String[] stringArray9 = new String[7];
                stringArray9[0] = "dwf";
                stringArray9[1] = "iges";
                stringArray9[2] = "igs";
                stringArray9[3] = "pov";
                stringArray9[4] = "vrml";
                stringArray9[5] = "wrl";
                stringArray = stringArray9;
                stringArray9[6] = "wrz";
                break;
            }
            case 8: {
                String[] stringArray10 = new String[3];
                stringArray10[0] = "gzip";
                stringArray10[1] = "ustar";
                stringArray = stringArray10;
                stringArray10[2] = "zip";
                break;
            }
            case 9: {
                String[] stringArray11 = new String[3];
                stringArray11[0] = "kar";
                stringArray11[1] = "mid";
                stringArray = stringArray11;
                stringArray11[2] = "midi";
                break;
            }
            case 10: {
                String[] stringArray12 = new String[1];
                stringArray = stringArray12;
                stringArray12[0] = "pvu";
                break;
            }
            case 11: {
                String[] stringArray13 = new String[83];
                stringArray13[0] = "abc";
                stringArray13[1] = "acgi";
                stringArray13[2] = "aip";
                stringArray13[3] = "asm";
                stringArray13[4] = "asp";
                stringArray13[5] = "c";
                stringArray13[6] = "c++";
                stringArray13[7] = "cc";
                stringArray13[8] = "com";
                stringArray13[9] = "conf";
                stringArray13[10] = "cpp";
                stringArray13[11] = "csh";
                stringArray13[12] = "css";
                stringArray13[13] = "cxx";
                stringArray13[14] = "def";
                stringArray13[15] = "el";
                stringArray13[16] = "etx";
                stringArray13[17] = "f";
                stringArray13[18] = "f77";
                stringArray13[19] = "f90";
                stringArray13[20] = "flx";
                stringArray13[21] = "for";
                stringArray13[22] = "g";
                stringArray13[23] = "h";
                stringArray13[24] = "hh";
                stringArray13[25] = "hlb";
                stringArray13[26] = "htc";
                stringArray13[27] = "htm";
                stringArray13[28] = "html";
                stringArray13[29] = "htmls";
                stringArray13[30] = "htt";
                stringArray13[31] = "htx";
                stringArray13[32] = "idc";
                stringArray13[33] = "jav";
                stringArray13[34] = "java";
                stringArray13[35] = "js";
                stringArray13[36] = "ksh";
                stringArray13[37] = "list";
                stringArray13[38] = "log";
                stringArray13[39] = "lsp";
                stringArray13[40] = "lst";
                stringArray13[41] = "lsx";
                stringArray13[42] = "m";
                stringArray13[43] = "mar";
                stringArray13[44] = "mcf";
                stringArray13[45] = "p";
                stringArray13[46] = "pas";
                stringArray13[47] = "pl";
                stringArray13[48] = "pm";
                stringArray13[49] = "properties";
                stringArray13[50] = "py";
                stringArray13[51] = "rexx";
                stringArray13[52] = "rt";
                stringArray13[53] = "rtf";
                stringArray13[54] = "rtx";
                stringArray13[55] = "s";
                stringArray13[56] = "scm";
                stringArray13[57] = "sdml";
                stringArray13[58] = "sgm";
                stringArray13[59] = "sgml";
                stringArray13[60] = "sh";
                stringArray13[61] = "shtml";
                stringArray13[62] = "spc";
                stringArray13[63] = "ssi";
                stringArray13[64] = "talk";
                stringArray13[65] = "tcl";
                stringArray13[66] = "tcsh";
                stringArray13[67] = "text";
                stringArray13[68] = "tsv";
                stringArray13[69] = "txt";
                stringArray13[70] = "uil";
                stringArray13[71] = "uni";
                stringArray13[72] = "unis";
                stringArray13[73] = "uri";
                stringArray13[74] = "uris";
                stringArray13[75] = "uu";
                stringArray13[76] = "uue";
                stringArray13[77] = "vcs";
                stringArray13[78] = "wml";
                stringArray13[79] = "wmls";
                stringArray13[80] = "wsc";
                stringArray13[81] = "xml";
                stringArray = stringArray13;
                stringArray13[82] = "zsh";
                break;
            }
            case 12: {
                String[] stringArray14 = new String[36];
                stringArray14[0] = "afl";
                stringArray14[1] = "asf";
                stringArray14[2] = "asx";
                stringArray14[3] = "avi";
                stringArray14[4] = "avs";
                stringArray14[5] = "dif";
                stringArray14[6] = "dl";
                stringArray14[7] = "dv";
                stringArray14[8] = "fli";
                stringArray14[9] = "fmf";
                stringArray14[10] = "gl";
                stringArray14[11] = "isu";
                stringArray14[12] = "m1v";
                stringArray14[13] = "m2v";
                stringArray14[14] = "mjpg";
                stringArray14[15] = "moov";
                stringArray14[16] = "mov";
                stringArray14[17] = "movie";
                stringArray14[18] = "mp2";
                stringArray14[19] = "mp3";
                stringArray14[20] = "mp4";
                stringArray14[21] = "mpa";
                stringArray14[22] = "mpe";
                stringArray14[23] = "mpeg";
                stringArray14[24] = "mpg";
                stringArray14[25] = "mv";
                stringArray14[26] = "qt";
                stringArray14[27] = "qtc";
                stringArray14[28] = "rv";
                stringArray14[29] = "scm";
                stringArray14[30] = "vdo";
                stringArray14[31] = "viv";
                stringArray14[32] = "vivo";
                stringArray14[33] = "vos";
                stringArray14[34] = "xdr";
                stringArray = stringArray14;
                stringArray14[35] = "xsr";
                break;
            }
            case 13: {
                String[] stringArray15 = new String[1];
                stringArray = stringArray15;
                stringArray15[0] = "wmf";
                break;
            }
            case 14: {
                String[] stringArray16 = new String[1];
                stringArray = stringArray16;
                stringArray16[0] = "mime";
                break;
            }
            case 15: {
                String[] stringArray17 = new String[1];
                stringArray = stringArray17;
                stringArray17[0] = "ice";
                break;
            }
            case 16: {
                String[] stringArray18 = new String[2];
                stringArray18[0] = "mid";
                stringArray = stringArray18;
                stringArray18[1] = "midi";
                break;
            }
            case 17: {
                String[] stringArray19 = new String[9];
                stringArray19[0] = "3dm";
                stringArray19[1] = "3dmf";
                stringArray19[2] = "qd3";
                stringArray19[3] = "qd3d";
                stringArray19[4] = "svr";
                stringArray19[5] = "vrml";
                stringArray19[6] = "vrt";
                stringArray19[7] = "wrl";
                stringArray = stringArray19;
                stringArray19[8] = "wrz";
                break;
            }
            case 18: {
                String[] stringArray20 = new String[2];
                stringArray20[0] = "xgz";
                stringArray = stringArray20;
                stringArray20[1] = "xmz";
                break;
            }
            default: {
                stringArray = null;
            }
        }
        return stringArray;
    }
}

