/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.ComparisonOp;
import adalid.core.interfaces.ComparisonX;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryExpression;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractComparisonX
extends AbstractExpression
implements ComparisonX {
    private static final String EOL = "\n";
    private ComparisonOp _operator;
    private Object _x;
    private Object _y;
    private Object _z;

    protected AbstractComparisonX(Object x, ComparisonOp operator) {
        this(x, operator, null);
    }

    protected AbstractComparisonX(Object x, ComparisonOp operator, Object y) {
        this(x, operator, y, null);
    }

    protected AbstractComparisonX(Object x, ComparisonOp operator, Object y, Object z) {
        this._operator = operator;
        this._x = x;
        this._y = y;
        this._z = z;
        this.initDataType();
    }

    @Override
    public ComparisonOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        Object[] objectArray;
        if (this._z == null) {
            if (this._y == null) {
                if (this._x == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this._x;
                }
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = this._x;
                objectArray = objectArray3;
                objectArray3[1] = this._y;
            }
        } else {
            Object[] objectArray4 = new Object[3];
            objectArray4[0] = this._x;
            objectArray4[1] = this._y;
            objectArray = objectArray4;
            objectArray4[2] = this._z;
        }
        return objectArray;
    }

    @Override
    public Object getX() {
        return this._x;
    }

    @Override
    public Object getY() {
        return this._y;
    }

    @Override
    public Object getZ() {
        return this._z;
    }

    private void initDataType() {
        this.setDataType(Boolean.class);
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            Expression e;
            string = (String)string + fee + tab + "operator" + faa + String.valueOf(this._operator) + foo;
            if (this._x != null) {
                if (this._x instanceof NaryExpression) {
                    e = (Expression)this._x;
                    string = (String)string + e.toString(n + 1, "x", verbose, fields, maps);
                } else {
                    string = (String)string + fee + tab + "x" + faa + this.getValueString(this._x) + foo;
                }
            }
            if (this._y != null) {
                if (this._y instanceof NaryExpression) {
                    e = (Expression)this._y;
                    string = (String)string + e.toString(n + 1, "y", verbose, fields, maps);
                } else {
                    string = (String)string + fee + tab + "y" + faa + this.getValueString(this._y) + foo;
                }
            }
            if (this._z != null) {
                if (this._z instanceof NaryExpression) {
                    e = (Expression)this._z;
                    string = (String)string + e.toString(n + 1, "y", verbose, fields, maps);
                } else {
                    string = (String)string + fee + tab + "z" + faa + this.getValueString(this._z) + foo;
                }
            }
        }
        return string;
    }
}

