/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.NaryVectorOp;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryExpression;
import adalid.core.interfaces.NaryVectorX;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractNaryVectorX
extends AbstractExpression
implements NaryVectorX {
    private static final String EOL = "\n";
    private final NaryVectorOp _operator;
    private final Object[] _operands;

    protected AbstractNaryVectorX(NaryVectorOp operator, Object ... operands) {
        this._operator = operator;
        this._operands = operands;
        this.initDataType();
    }

    @Override
    public NaryVectorOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        return this._operands == null ? new Object[]{} : this._operands;
    }

    private void initDataType() {
        if (this._operator == null) {
            this.setDataType(Object.class);
        } else {
            switch (this._operator) {
                case SUBSTR: {
                    this.setDataType(String.class);
                    break;
                }
                default: {
                    this.setDataType(Object.class);
                }
            }
        }
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "operator" + faa + String.valueOf(this._operator) + foo;
            for (Object operand : this._operands) {
                if (operand == null) continue;
                if (operand instanceof NaryExpression) {
                    Expression e = (Expression)operand;
                    string = (String)string + e.toString(n + 1, "x", verbose, fields, maps);
                    continue;
                }
                string = (String)string + fee + tab + "x" + faa + this.getValueString(operand) + foo;
            }
        }
        return string;
    }
}

