/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.RowsAggregateOp;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.RowsAggregateX;
import adalid.core.interfaces.Segment;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRowsAggregateX
extends AbstractExpression
implements RowsAggregateX {
    private static final String EOL = "\n";
    private RowsAggregateOp _operator;
    private Object _measure;
    private Segment _filter;
    private Entity _dimension;

    protected AbstractRowsAggregateX(RowsAggregateOp operator, Object measure) {
        this(operator, measure, null, null);
    }

    protected AbstractRowsAggregateX(RowsAggregateOp operator, Object measure, Segment filter) {
        this(operator, measure, filter, null);
    }

    protected AbstractRowsAggregateX(RowsAggregateOp operator, Object measure, Entity dimension) {
        this(operator, measure, null, dimension);
    }

    protected AbstractRowsAggregateX(RowsAggregateOp operator, Object measure, Segment filter, Entity dimension) {
        this._operator = operator;
        this._measure = measure;
        this._filter = filter;
        this._dimension = dimension;
        this.initDataType();
    }

    @Override
    public RowsAggregateOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        Object[] objectArray;
        if (this._measure == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this._measure;
            objectArray2[1] = this._filter;
            objectArray = objectArray2;
            objectArray2[2] = this._dimension;
        }
        return objectArray;
    }

    @Override
    public Object getMeasure() {
        return this._measure;
    }

    @Override
    public Segment getFilter() {
        return this._filter;
    }

    @Override
    public Entity getDimension() {
        return this._dimension;
    }

    private void initDataType() {
        if (this._operator == null) {
            this.copyDataType(this._measure);
        } else {
            switch (this._operator) {
                case COUNT: {
                    this.setDataType(Long.class);
                    break;
                }
                case AND: 
                case OR: {
                    this.setDataType(Boolean.class);
                    break;
                }
                default: {
                    this.copyDataType(this._measure);
                }
            }
        }
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "operator" + faa + String.valueOf(this._operator) + foo;
            string = (String)string + fee + tab + "operand" + faa + this.getValueString(this._measure) + foo;
            if (this._filter != null) {
                string = (String)string + fee + tab + "segment" + faa + this.getValueString(this._filter) + foo;
            }
            if (this._dimension != null) {
                string = (String)string + fee + tab + "property" + faa + this.getValueString(this._dimension) + foo;
            }
        }
        return string;
    }
}

