/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.Instance;
import adalid.core.ProcessOperation;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.enums.CheckEvent;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SpecialBooleanValue;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.expressions.AbstractScalarX;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.BooleanConditionalX;
import adalid.core.expressions.BooleanOrderedPairX;
import adalid.core.expressions.CharacterConditionalX;
import adalid.core.expressions.CharacterScalarX;
import adalid.core.expressions.EntityConditionalX;
import adalid.core.expressions.NumericConditionalX;
import adalid.core.expressions.TemporalConditionalX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class BooleanScalarX
extends AbstractScalarX
implements Check,
State {
    private final Map<Locale, String> _localizedErrorMessage = new LinkedHashMap<Locale, String>();
    private CheckEvent _checkEvent = CheckEvent.INSERT_AND_UPDATE;
    private Checkpoint _checkpoint = Checkpoint.UNSPECIFIED;

    BooleanScalarX(ScalarOp operator, Object operand) {
        super(operator, operand);
    }

    @Override
    public BooleanComparisonX isNull() {
        return XB.Boolean.Comparison.isNull(this);
    }

    @Override
    public BooleanComparisonX isNotNull() {
        return XB.Boolean.Comparison.isNotNull(this);
    }

    @Override
    public BooleanComparisonX isTrue() {
        return XB.Boolean.Comparison.isTrue(this);
    }

    @Override
    public BooleanComparisonX isFalse() {
        return XB.Boolean.Comparison.isFalse(this);
    }

    @Override
    public BooleanComparisonX isNotTrue() {
        return this.isNullOrFalse();
    }

    @Override
    public BooleanComparisonX isNotFalse() {
        return this.isNullOrTrue();
    }

    @Override
    public BooleanComparisonX isNullOrTrue() {
        return XB.Boolean.Comparison.isNullOrTrue(this);
    }

    @Override
    public BooleanComparisonX isNullOrFalse() {
        return XB.Boolean.Comparison.isNullOrFalse(this);
    }

    @Override
    public BooleanComparisonX isEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNotEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNotEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNullOrEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNullOrEqualTo(this, y);
    }

    @Override
    public BooleanComparisonX isNullOrNotEqualTo(BooleanExpression y) {
        return XB.Boolean.Comparison.isNullOrNotEqualTo(this, y);
    }

    @Override
    public EntityConditionalX then(Entity value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(Instance value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(SpecialEntityValue value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public EntityConditionalX then(EntityExpression value) {
        return XB.Entity.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(Boolean value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(SpecialBooleanValue value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanConditionalX then(BooleanExpression value) {
        return XB.Boolean.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(String value) {
        return XB.Character.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(SpecialCharacterValue value) {
        return XB.Character.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public CharacterConditionalX then(Expression value) {
        return XB.Character.Conditional.then((BooleanExpression)this, this.toCharacterExpression(value));
    }

    @Override
    public NumericConditionalX then(Number value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public NumericConditionalX then(SpecialNumericValue value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public NumericConditionalX then(NumericExpression value) {
        return XB.Numeric.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(Date value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(SpecialTemporalValue value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public TemporalConditionalX then(TemporalExpression value) {
        return XB.Temporal.Conditional.then((BooleanExpression)this, value);
    }

    @Override
    public BooleanOrderedPairX and(BooleanExpression y) {
        return XB.Boolean.OrderedPair.and(this, y);
    }

    @Override
    public BooleanOrderedPairX nand(BooleanExpression y) {
        return XB.Boolean.OrderedPair.nand(this, y);
    }

    @Override
    public BooleanOrderedPairX or(BooleanExpression y) {
        return XB.Boolean.OrderedPair.or(this, y);
    }

    @Override
    public BooleanOrderedPairX nor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.nor(this, y);
    }

    @Override
    public BooleanOrderedPairX xor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xor(this, y);
    }

    @Override
    public BooleanOrderedPairX xnor(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xnor(this, y);
    }

    @Override
    public BooleanOrderedPairX implies(BooleanExpression y) {
        return XB.Boolean.OrderedPair.xImpliesY(this, y);
    }

    @Override
    public BooleanScalarX not() {
        return XB.Boolean.Scalar.not(this);
    }

    @Override
    public CharacterScalarX toCharString() {
        return XB.Character.Scalar.toCharString(this);
    }

    private CharacterExpression toCharacterExpression(Object x) {
        return x instanceof CharacterExpression ? (CharacterExpression)x : XB.toCharString(x);
    }

    @Override
    public Transition transitionTo(State y) {
        return new Transition(this, y);
    }

    @Override
    public Trigger trigger(ProcessOperation operation) {
        return new Trigger(this, operation);
    }

    @Override
    public String getDefaultErrorMessage() {
        return this.getLocalizedErrorMessage(null);
    }

    @Override
    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.setLocalizedErrorMessage(null, defaultErrorMessage);
    }

    @Override
    public String getLocalizedErrorMessage(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedErrorMessage.get(l);
    }

    @Override
    public void setLocalizedErrorMessage(Locale locale, String localizedErrorMessage) {
        this.checkScope();
        Locale l = this.localeWritingKey(locale);
        if (localizedErrorMessage == null) {
            this._localizedErrorMessage.remove(l);
        } else {
            this._localizedErrorMessage.put(l, localizedErrorMessage);
        }
    }

    @Override
    public CheckEvent getCheckEvent() {
        return this._checkEvent;
    }

    @Override
    public void setCheckEvent(CheckEvent checkEvent) {
        this.checkScope();
        this._checkEvent = checkEvent == null ? CheckEvent.INSERT_AND_UPDATE : checkEvent;
    }

    @Override
    public Checkpoint getCheckpoint() {
        return this._checkpoint;
    }

    @Override
    public void setCheckpoint(Checkpoint checkpoint) {
        this.checkScope();
        this._checkpoint = checkpoint == null ? Checkpoint.UNSPECIFIED : checkpoint;
    }
}

