/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.interfaces;

import adalid.core.EntityCollection;
import adalid.core.Instance;
import adalid.core.Key;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.Tab;
import adalid.core.Transition;
import adalid.core.Trigger;
import adalid.core.View;
import adalid.core.annotations.AllocationOverride;
import adalid.core.enums.BusinessKeyType;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityReferenceProperty;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.EntityViewType;
import adalid.core.enums.HelpFileAutoName;
import adalid.core.enums.HierarchyNodeType;
import adalid.core.enums.ListStyle;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.OperationLogging;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchDisplayFormat;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.EntityOrderedPairX;
import adalid.core.expressions.EntityScalarX;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.EntityReferenceContainer;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface Entity
extends Comparable<Entity>,
DataArtifact,
EntityReferenceContainer {
    default public boolean isAssignableFrom(Entity entity) {
        return this.getClass().isAssignableFrom(entity.getClass());
    }

    public boolean isInitialised();

    public boolean isSettled();

    public boolean isRootInstance();

    public boolean isExplicitlyDeclared();

    public boolean isImplicitlyDeclared();

    public int getReferenceIndex();

    public String getDefaultLabel(EntityReference var1);

    public String getDefaultShortLabel(EntityReference var1);

    public String getDefaultCollectionLabel(EntityReference var1);

    public String getDefaultCollectionShortLabel(EntityReference var1);

    public String getDefaultMenuOptionLabel(DisplayFormat var1);

    public String getLocalizedLabel(Locale var1, EntityReference var2);

    public String getLocalizedShortLabel(Locale var1, EntityReference var2);

    public String getLocalizedCollectionLabel(Locale var1, EntityReference var2);

    public String getLocalizedCollectionShortLabel(Locale var1, EntityReference var2);

    public String getLocalizedMenuOptionLabel(Locale var1, DisplayFormat var2);

    public int getReferencePropertiesCount();

    public List<Property> getPropertiesList();

    public List<EntityCollection> getEntityCollectionsList();

    public List<Property> getReferencesList();

    public List<Parameter> getParameterReferencesList();

    public List<Key> getKeysList();

    public List<Step> getStepsList();

    public List<Tab> getTabsList();

    public List<View> getViewsList();

    public List<Instance> getInstancesList();

    public List<NamedValue> getNamedValuesList();

    public List<Expression> getExpressionsList();

    public List<Transition> getTransitionsList();

    public List<Operation> getOperationsList();

    public List<Class<?>> getOperationClassesList();

    public List<Trigger> getTriggersList();

    public List<Property> getCalculablePropertiesList();

    public List<Property> getOverlayPropertiesList();

    public List<Property> getQueryPropertiesList();

    public Map<String, Property> getPropertiesMap();

    public Map<String, EntityCollection> getEntityCollectionsMap();

    public Map<String, Property> getReferencesMap();

    public Map<String, Parameter> getParameterReferencesMap();

    public Map<String, Key> getKeysMap();

    public Map<String, Step> getStepsMap();

    public Map<String, Tab> getTabsMap();

    public Map<String, View> getViewsMap();

    public Map<String, Instance> getInstancesMap();

    public Map<String, NamedValue> getNamedValuesMap();

    public Map<String, Expression> getExpressionsMap();

    public Map<String, Transition> getTransitionsMap();

    public Map<String, Operation> getOperationsMap();

    public Map<String, Class<?>> getOperationClassesMap();

    public Map<String, Trigger> getTriggersMap();

    public Map<String, Property> getCalculablePropertiesMap();

    public Map<String, Property> getOverlayPropertiesMap();

    public Map<String, Property> getQueryPropertiesMap();

    public EntityReference getMainEntityReferenceFrom(Class<?> var1);

    public boolean isAbstractClass();

    public Class<?> getBaseClass();

    public List<Class<?>> getSubclassesList();

    public Map<String, Class<?>> getSubclassesMap();

    public Map<String, Entity> getSubentitiesMap();

    public List<AllocationOverride> getAllocationOverridesList();

    public Map<String, AllocationOverride> getAllocationOverridesMap();

    public String getSuperViewName();

    public void setSuperViewName(String var1);

    public String getSupraViewName();

    public void setSupraViewName(String var1);

    public String getPrimaryKeyFieldName();

    public String getSequenceFieldName();

    public String getVersionFieldName();

    public String getNumericKeyFieldName();

    public String getCharacterKeyFieldName();

    public String getNameFieldName();

    public String getDescriptionFieldName();

    public String getImageFieldName();

    public String getInactiveIndicatorFieldName();

    public String getUrlFieldName();

    public String getParentFieldName();

    public String getOwnerFieldName();

    public String getUserFieldName();

    public String getSegmentFieldName();

    public String getBusinessKeyFieldName();

    public String getStateFieldName();

    default public String getBusinessKeyValueOf(Instance instance) {
        return instance == null ? null : instance.getName();
    }

    default public Object getDefaultPropertyValueOf(Instance instance, Property property) {
        return null;
    }

    public Field getPrimaryKeyField();

    public Field getSequenceField();

    public Field getVersionField();

    public Field getNumericKeyField();

    public Field getCharacterKeyField();

    public Field getNameField();

    public Field getDescriptionField();

    public Field getImageField();

    public Field getInactiveIndicatorField();

    public Field getUrlField();

    public Field getParentField();

    public Field getOwnerField();

    public Field getUserField();

    public Field getSegmentField();

    public Field getBusinessKeyField();

    public Field getStateField();

    public Property getPrimaryKeyProperty();

    public LongProperty getSequenceProperty();

    public LongProperty getVersionProperty();

    public IntegerProperty getNumericKeyProperty();

    public StringProperty getCharacterKeyProperty();

    public StringProperty getNameProperty();

    public StringProperty getDescriptionProperty();

    public BinaryProperty getImageProperty();

    public BooleanProperty getInactiveIndicatorProperty();

    public StringProperty getUrlProperty();

    public Entity getParentProperty();

    public Entity getOwnerProperty();

    public Entity getUserProperty();

    public DataArtifact getSegmentProperty();

    public Property getBusinessKeyProperty();

    public BusinessKeyType getBusinessKeyType();

    public Entity getStateProperty();

    public boolean isBasicOperationEntity();

    public boolean isCatalogEntity();

    public boolean isContextualEntity();

    public boolean isEnumerationEntity();

    public boolean isBooleanEnumerationEntity();

    public boolean isNonEnumerationEntity();

    public boolean isDatabaseEntity();

    public boolean isPersistentEntity();

    public boolean isPersistentEnumerationEntity();

    public boolean isPersistentNonEnumerationEntity();

    public boolean isEntityCollector();

    public boolean isOverlayableEntity();

    public boolean isOverlayableEntityReference();

    public boolean isExistentiallyIndependent();

    public EntityViewType getEntityViewType();

    public boolean isVariantEntity();

    public boolean isInvariantEntity();

    public boolean isSegmentEqualToOwner();

    public boolean isSegmentEqualToPrimaryKey();

    public ResourceType getResourceType();

    public ResourceGender getResourceGender();

    public String getPropertiesPrefix();

    public String getPropertiesSuffix();

    public String getCollectionName();

    public String getHelpDocument();

    public void setHelpDocument(String var1);

    public String getHelpFileName();

    public void setHelpFileName(String var1);

    public HelpFileAutoName getHelpFileAutoName();

    public String getHelpFileAutoType();

    public boolean isSelectEnabled();

    public void setSelectEnabled(boolean var1);

    public OperationAccess isSelectOperationAccess();

    public SelectOnloadOption getSelectOnloadOption();

    public int getStartWith();

    public int getSelectRowsLimit();

    public SortOption getSelectSortOption();

    public boolean isInsertEnabled();

    public void setInsertEnabled(boolean var1);

    public boolean isInsertConfirmationRequired();

    public OperationAccess getInsertOperationAccess();

    public OperationLogging getInsertLogging();

    public boolean isUpdateEnabled();

    public void setUpdateEnabled(boolean var1);

    public boolean isUpdateConfirmationRequired();

    public OperationAccess getUpdateOperationAccess();

    public OperationLogging getUpdateLogging();

    public boolean isDeleteEnabled();

    public void setDeleteEnabled(boolean var1);

    public boolean isDeleteConfirmationRequired();

    public OperationAccess getDeleteOperationAccess();

    public OperationLogging getDeleteLogging();

    public boolean isReportEnabled();

    public void setReportEnabled(boolean var1);

    public int getReportRowsLimit();

    public SortOption getReportSortOption();

    public boolean isExportEnabled();

    public void setExportEnabled(boolean var1);

    public int getExportRowsLimit();

    public SortOption getExportSortOption();

    public boolean isForeignEntityClass();

    public void setForeignEntityClass(Boolean var1);

    public boolean isPrivateEntityClass();

    public void setPrivateEntityClass(Boolean var1);

    public boolean isLinkOuterChildren();

    public boolean isLinkOuterCollaterals();

    public boolean isLinkOuterSiblings();

    public boolean isTableViewEnabled();

    public void setTableViewEnabled(boolean var1);

    public boolean isTableViewWithInsertEnabled();

    public boolean isTableViewWithUpdateEnabled();

    public boolean isTableViewWithDeleteEnabled();

    public boolean isTableViewWithMasterHeading();

    public boolean isTableViewWithQuickFilterSnippet();

    public boolean isTableViewWithStickyHeader();

    public String getTableViewQuickFilterSnippetPath();

    public TableResponsiveMode getTableResponsiveMode();

    public String getTableViewHelpDocument();

    public String getTableViewHelpFileName();

    public boolean isDetailViewEnabled();

    public void setDetailViewEnabled(boolean var1);

    public String getDetailViewHelpDocument();

    public String getDetailViewHelpFileName();

    public boolean isTreeViewEnabled();

    public void setTreeViewEnabled(boolean var1);

    public String getTreeViewHelpDocument();

    public String getTreeViewHelpFileName();

    public boolean isConsoleViewEnabled();

    public void setConsoleViewEnabled(boolean var1);

    public String getConsoleViewHelpDocument();

    public String getConsoleViewHelpFileName();

    public boolean isWarningsEnabled();

    public boolean isSpecialExpressionsWarningsEnabled();

    public boolean isUnusualExpressionsWarningsEnabled();

    public boolean isBplCodeGenEnabled();

    public void setBplCodeGenEnabled(boolean var1);

    public boolean isBwsCodeGenEnabled();

    public void setBwsCodeGenEnabled(boolean var1);

    public boolean isDaoCodeGenEnabled();

    public void setDaoCodeGenEnabled(boolean var1);

    public boolean isDafCodeGenEnabled();

    public void setDafCodeGenEnabled(boolean var1);

    public boolean isFwsCodeGenEnabled();

    public void setFwsCodeGenEnabled(boolean var1);

    public boolean isGuiCodeGenEnabled();

    public void setGuiCodeGenEnabled(boolean var1);

    public boolean isSqlCodeGenEnabled();

    public void setSqlCodeGenEnabled(boolean var1);

    public boolean isEntityStateCodeGenEnabled();

    public boolean isEntityClassDiagramGenEnabled();

    public boolean isEntityStateDiagramGenEnabled();

    public boolean isEntityInsertActivityDiagramGenEnabled();

    public boolean isEntityUpdateActivityDiagramGenEnabled();

    public Property getProperty(String var1);

    public EntityReferenceStyle getReferenceStyle();

    public EntityReferenceProperty getReferenceFilterBy();

    public Property getReferenceFilterByProperty();

    public EntityReferenceProperty getReferenceSortBy();

    public Property getReferenceSortByProperty();

    public SearchType getSearchType();

    public ListStyle getListStyle();

    public SearchDisplayFormat getSearchDisplayFormat();

    public DisplayMode getSearchDisplayMode();

    public String getApplicationOrigin();

    public void setApplicationOrigin(String var1);

    public String getApplicationContextRoot();

    public void setApplicationContextRoot(String var1);

    public String getApplicationConsolePath();

    public void setApplicationConsolePath(String var1);

    public String getApplicationReadingPath();

    public void setApplicationReadingPath(String var1);

    public String getApplicationWritingPath();

    public void setApplicationWritingPath(String var1);

    public boolean isApplicationDefaultLocation();

    public BooleanExpression getSearchQueryFilter();

    public BooleanExpression getSelectFilter();

    public BooleanExpression getInsertFilter(EntityReference var1);

    public BooleanExpression getUpdateFilter();

    public BooleanExpression getDeleteFilter();

    public BooleanExpression getMasterDetailFilter(EntityReference var1);

    public Object getInitialValue();

    public void setInitialValue(Entity var1);

    public void setInitialValue(Instance var1);

    public void setInitialValue(EntityExpression var1);

    public void setInitialValue(SpecialEntityValue var1);

    public Object getDefaultValue();

    public void setDefaultValue(Entity var1);

    public void setDefaultValue(Instance var1);

    public void setDefaultValue(EntityExpression var1);

    public void setDefaultValue(SpecialEntityValue var1);

    public boolean isDisplayAvailable();

    public void setDisplayAvailable(Boolean var1);

    public boolean isWritingPageMaster();

    public void initialise();

    public void prepare();

    public void settle();

    public Object addAttribute(Property var1, String var2, Object var3);

    public Project getDeclaringProject();

    public Entity getRoot();

    public Entity getBaseRoot();

    public Entity getHierarchyRoot();

    public HierarchyNodeType getHierarchyNodeType();

    public List<Entity> getAncestorsList();

    public List<Entity> getExtensionsList();

    public Map<String, Entity> getExtensionsMap();

    public List<Entity> getOverlayEntitiesList();

    public Map<String, Entity> getOverlayEntitiesMap();

    public List<Entity> getAccesibleOperationsOverlayEntitiesList();

    public Map<String, Entity> getAccesibleOperationsOverlayEntitiesMap();

    public <T extends Operation> T getOperation(Class<T> var1);

    public List<Operation> getCrudOperationsList();

    public List<Operation> getBusinessOperationsList();

    public List<Operation> getAccesibleBusinessOperationsList();

    public Property[] getRemoveHeadingPropertyArray();

    public boolean isRemovePropertiesInRemoveHeadingPropertyArray();

    @Override
    public BooleanComparisonX isNull();

    @Override
    public BooleanComparisonX isNotNull();

    public BooleanComparisonX isEqualTo(Entity var1);

    public BooleanComparisonX isEqualTo(Instance var1);

    public BooleanComparisonX isEqualTo(EntityExpression var1);

    public BooleanComparisonX isNotEqualTo(Entity var1);

    public BooleanComparisonX isNotEqualTo(Instance var1);

    public BooleanComparisonX isNotEqualTo(EntityExpression var1);

    public BooleanComparisonX isNullOrEqualTo(Entity var1);

    public BooleanComparisonX isNullOrEqualTo(Instance var1);

    public BooleanComparisonX isNullOrEqualTo(EntityExpression var1);

    public BooleanComparisonX isNullOrNotEqualTo(Entity var1);

    public BooleanComparisonX isNullOrNotEqualTo(Instance var1);

    public BooleanComparisonX isNullOrNotEqualTo(EntityExpression var1);

    public EntityScalarX self();

    public EntityOrderedPairX coalesce(Entity var1);

    public EntityOrderedPairX coalesce(Instance var1);

    public EntityOrderedPairX coalesce(EntityExpression var1);
}

