/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.jee;

import adalid.commons.util.ColUtils;
import adalid.core.Operation;
import adalid.core.PageField;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Parameter;
import adalid.core.jee.JavaServerPage;
import adalid.core.predicates.IsAccesibleOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Predicate;

public class ConsoleJavaServerPage
extends JavaServerPage {
    private List<PageField> _fields;
    private List<PageField> _masterFields;
    private Set<Entity> _entitiesReferencedByFields;

    public ConsoleJavaServerPage(String name) {
        super(name);
    }

    @Override
    public List<PageField> getFields(boolean hidden) {
        if (this._fields == null) {
            this._fields = new ArrayList<PageField>();
        }
        return this._fields;
    }

    @Override
    public List<PageField> getMasterHeadingFields(boolean hidden) {
        if (this._masterFields == null) {
            this._masterFields = new ArrayList<PageField>();
        }
        return this._masterFields;
    }

    @Override
    public Set<Entity> getEntitiesReferencedByFields(boolean hidden) {
        if (this._entitiesReferencedByFields == null) {
            Collection<Operation> operations;
            this._entitiesReferencedByFields = new LinkedHashSet<Entity>();
            Entity entity = this.getEntity();
            if (entity != null && (operations = ColUtils.filter(entity.getBusinessOperationsList(), (Predicate)new IsAccesibleOperation())) != null && !operations.isEmpty()) {
                for (Operation operation : operations) {
                    for (Parameter parameter : operation.getParametersList()) {
                        if (!(parameter instanceof Entity)) continue;
                        Entity reference = (Entity)((Object)parameter);
                        this._entitiesReferencedByFields.add(reference);
                    }
                }
            }
        }
        return this._entitiesReferencedByFields;
    }
}

