/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.page.format;

import adalid.core.interfaces.PageFormat;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPageFormat
implements PageFormat {
    private final String paperSize;
    private final int pageWidth;
    private final int pageHeight;
    private final int topMargin;
    private final int bottomMargin;
    private final int leftMargin;
    private final int rightMargin;

    protected AbstractPageFormat(String paperSize, int pageWidth, int pageHeight, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        this.paperSize = StringUtils.defaultIfBlank((String)paperSize, (String)"Custom");
        int n = pageWidth < 360 ? 360 : (this.pageWidth = pageWidth > 1296 ? 1296 : pageWidth);
        int n2 = pageHeight < 360 ? 360 : (this.pageHeight = pageHeight > 1296 ? 1296 : pageHeight);
        int n3 = topMargin < 18 ? 18 : (this.topMargin = topMargin > 144 ? 144 : topMargin);
        int n4 = bottomMargin < 18 ? 18 : (this.bottomMargin = bottomMargin > 144 ? 144 : bottomMargin);
        int n5 = leftMargin < 18 ? 18 : (this.leftMargin = leftMargin > 144 ? 144 : leftMargin);
        this.rightMargin = rightMargin < 18 ? 18 : (rightMargin > 144 ? 144 : rightMargin);
    }

    @Override
    public String getPaperSize() {
        return this.paperSize;
    }

    @Override
    public boolean isLandscapeOrientation() {
        return this.pageWidth > this.pageHeight;
    }

    @Override
    public boolean isPortraitOrientation() {
        return this.pageHeight > this.pageWidth;
    }

    @Override
    public int getColumnWidth() {
        return this.pageWidth - this.leftMargin - this.rightMargin;
    }

    @Override
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public int getPageHeight() {
        return this.pageHeight;
    }

    @Override
    public int getTopMargin() {
        return this.topMargin;
    }

    @Override
    public int getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public int getRightMargin() {
        return this.rightMargin;
    }
}

