/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.parameters.ext;

import adalid.core.enums.LetterCase;
import adalid.core.parameters.StringParameter;
import java.util.regex.Pattern;

public class EmailAddressParameter
extends StringParameter {
    public EmailAddressParameter() {
        this.setLetterCase(LetterCase.LOWER);
        this.setMaxLength(254);
        this.setPattern(Pattern.compile("^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$"));
        this.setLocalizedDescription(ENGLISH, "this is an address that identifies the e-mail box to which messages are delivered; as a general rule, an e-mail address must start with a user name, followed by an @ sign and a domain name; for example: john.doe@gmail.com");
        this.setLocalizedDescription(SPANISH, "esta es una direcci\u00f3n que identifica la casilla de correo electr\u00f3nico a la que se entregan los mensajes; por regla general, una direcci\u00f3n de correo electr\u00f3nico debe comenzar con un nombre de usuario, seguido de un signo @ y un nombre de dominio; por ejemplo: juan.bimba@gmail.com");
        this.setLocalizedRegexErrorMessage(ENGLISH, "the e-mail address does not meet the required pattern; it must start with a user name, followed by an @ sign and a domain name.");
        this.setLocalizedRegexErrorMessage(SPANISH, "la direcci\u00f3n de correo electr\u00f3nico no cumple con el patr\u00f3n requerido; debe comenzar con un nombre de usuario, seguido de un signo @ y un nombre de dominio.");
    }

    public boolean isEmailAddress() {
        return true;
    }
}

