/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.programmers;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.JavaUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.Instance;
import adalid.core.enums.ComparisonOp;
import adalid.core.enums.DataAggregateOp;
import adalid.core.enums.NaryVectorOp;
import adalid.core.enums.OrderedPairOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SpecialBinaryValue;
import adalid.core.enums.SpecialBooleanValue;
import adalid.core.enums.SpecialCharacterValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.exceptions.InstantiationRuntimeException;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.ComparisonX;
import adalid.core.interfaces.ConditionalX;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.IntervalizedArtifact;
import adalid.core.interfaces.JavaProgrammer;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NaryVectorX;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.RowsAggregateX;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.SpecialValue;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.interfaces.ValuedArtifact;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.programmers.AbstractProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.sql.NamedQuery;
import adalid.core.sql.NativeQuery;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractJavaProgrammer
extends AbstractProgrammer
implements JavaProgrammer {
    protected static final Logger logger = Logger.getLogger(JavaProgrammer.class);
    protected static final String EMPTY = "";
    protected static final boolean RTL = Bundle.getBoolean("java.right_to_left");
    protected static final String UTIL = "ObjUtils";
    protected static final String CALL_REGEX = "^(\\w+\\.)?\\w+\\(.*\\)$";
    protected static final String SEP$ = ",";
    protected static final String[] KEYWORDS = JavaUtils.getJavaKeywordArray();

    public static Set<String> getJavaKeywords() {
        return JavaUtils.getJavaKeywordSet();
    }

    @Override
    public String getJavaName(Artifact artifact) {
        return artifact == null ? null : this.getJavaName(artifact.getName());
    }

    @Override
    public String getJavaName(String name) {
        return StrUtils.getStringAscii(name);
    }

    @Override
    public String getJavaConstantName(Artifact artifact) {
        return artifact == null ? null : this.getJavaConstantName(artifact.getName());
    }

    @Override
    public String getJavaConstantName(String name) {
        return this.getJavaUpperConstantName(name);
    }

    @Override
    public String getJavaUpperConstantName(Artifact artifact) {
        return artifact == null ? null : this.getJavaUpperConstantName(artifact.getName());
    }

    @Override
    public String getJavaUpperConstantName(String name) {
        return StrUtils.getUpperHumplessCase(name);
    }

    @Override
    public String getJavaLowerConstantName(Artifact artifact) {
        return artifact == null ? null : this.getJavaLowerConstantName(artifact.getName());
    }

    @Override
    public String getJavaLowerConstantName(String name) {
        return StrUtils.getLowerHumplessCase(name);
    }

    @Override
    public String getJavaClassName(Artifact artifact) {
        return artifact == null ? null : this.getJavaClassName(artifact.getName());
    }

    @Override
    public String getJavaClassName(String name) {
        return this.getJavaUpperClassName(name);
    }

    @Override
    public String getJavaUpperClassName(Artifact artifact) {
        return artifact == null ? null : this.getJavaUpperClassName(artifact.getName());
    }

    @Override
    public String getJavaUpperClassName(String name) {
        return StringUtils.capitalize((String)StrUtils.getCamelCase(name, true));
    }

    @Override
    public String getJavaLowerClassName(Artifact artifact) {
        return artifact == null ? null : this.getJavaLowerClassName(artifact.getName());
    }

    @Override
    public String getJavaLowerClassName(String name) {
        return StringUtils.uncapitalize((String)StrUtils.getCamelCase(name, true));
    }

    @Override
    public String getJavaVariableName(Artifact artifact) {
        return artifact == null ? null : this.getJavaVariableName(artifact.getName());
    }

    @Override
    public String getJavaVariableName(String name) {
        return this.getJavaLowerVariableName(name);
    }

    @Override
    public String getJavaUpperVariableName(Artifact artifact) {
        return artifact == null ? null : this.getJavaUpperVariableName(artifact.getName());
    }

    @Override
    public String getJavaUpperVariableName(String name) {
        return StringUtils.capitalize((String)StrUtils.getCamelCase(name, true));
    }

    @Override
    public String getJavaLowerVariableName(Artifact artifact) {
        return artifact == null ? null : this.getJavaLowerVariableName(artifact.getName());
    }

    @Override
    public String getJavaLowerVariableName(String name) {
        return StringUtils.uncapitalize((String)StrUtils.getCamelCase(name, true));
    }

    @Override
    public String getJavaQualifiedName(Artifact artifact) {
        return artifact == null ? null : artifact.getPathString();
    }

    @Override
    public String getJavaType(Artifact artifact) {
        Class<?> dataType = this.getDataType(artifact);
        return dataType == null ? null : this.javaLangLess(dataType);
    }

    @Override
    public String getJavaTypeName(Artifact artifact) {
        Class<?> dataType = this.getDataType(artifact);
        return dataType == null ? null : dataType.getName();
    }

    @Override
    public String getJavaTypeCanonicalName(Artifact artifact) {
        Class<?> dataType = this.getDataType(artifact);
        return dataType == null ? null : dataType.getCanonicalName();
    }

    @Override
    public String getJavaTypeSimpleName(Artifact artifact) {
        Class<?> dataType = this.getDataType(artifact);
        return dataType == null ? null : dataType.getSimpleName();
    }

    protected Class<?> getDataType(Artifact artifact) {
        TypedArtifact typedArtifact = artifact instanceof TypedArtifact ? (TypedArtifact)artifact : null;
        return typedArtifact == null ? null : typedArtifact.getDataType();
    }

    @Override
    public String getJavaInitialValue(DataArtifact artifact) {
        Object initialValue = this.getInitialValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return initialValue == null || dataType == null ? null : this.getJavaValue(initialValue, dataType);
    }

    protected Object getInitialValue(DataArtifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getInitialValue();
    }

    @Override
    public String getJavaDefaultValue(DataArtifact artifact) {
        Object defaultValue = this.getDefaultValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return defaultValue == null || dataType == null ? null : this.getJavaValue(defaultValue, dataType);
    }

    protected Object getDefaultValue(DataArtifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getDefaultValue();
    }

    @Override
    public String getJavaCurrentValue(DataArtifact artifact) {
        Object currentValue = this.getCurrentValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return currentValue == null || dataType == null ? null : this.getJavaValue(currentValue, dataType);
    }

    protected Object getCurrentValue(DataArtifact artifact) {
        ValuedArtifact valuedArtifact = artifact instanceof ValuedArtifact ? (ValuedArtifact)artifact : null;
        return valuedArtifact == null ? null : valuedArtifact.getCurrentValue();
    }

    @Override
    public String getJavaMaximumValue(DataArtifact artifact) {
        Object maximumValue = this.getMaximumValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return maximumValue == null || dataType == null ? null : this.getJavaValue(maximumValue, dataType);
    }

    protected Object getMaximumValue(DataArtifact artifact) {
        IntervalizedArtifact intervalizedArtifact = artifact instanceof IntervalizedArtifact ? (IntervalizedArtifact)artifact : null;
        return intervalizedArtifact == null ? null : intervalizedArtifact.getMaxValue();
    }

    @Override
    public String getJavaMinimumValue(DataArtifact artifact) {
        Object minimumValue = this.getMinimumValue(artifact);
        Class<?> dataType = this.getDataType(artifact);
        return minimumValue == null || dataType == null ? null : this.getJavaValue(minimumValue, dataType);
    }

    protected Object getMinimumValue(DataArtifact artifact) {
        IntervalizedArtifact intervalizedArtifact = artifact instanceof IntervalizedArtifact ? (IntervalizedArtifact)artifact : null;
        return intervalizedArtifact == null ? null : intervalizedArtifact.getMinValue();
    }

    @Override
    public String getJavaNullifyingValue(DataArtifact artifact) {
        return artifact == null ? null : (artifact.isProperty() ? this.getJavaPropertyNullifyingValue((Property)artifact) : null);
    }

    protected String getJavaPropertyNullifyingValue(Property p) {
        return p.isNullable() ? "null" : (p.isBooleanPrimitive() ? "false" : (p.isCharacterPrimitive() ? "\"\"" : (p.isBigDecimalData() ? "BigDecimal.ZERO" : (p.isBigIntegerData() ? "BigDecimal.ZERO" : (p.isDoubleData() ? "0.0D" : (p.isFloatData() ? "0.0D" : (p.isLongData() ? "0L" : (p.isNumericPrimitive() ? "0" : (p.isDateData() ? "0" : (p.isTemporalPrimitive() ? "new java.util.Date(0L)" : null))))))))));
    }

    @Override
    public String getJavaValue(Object object) {
        return object == null ? null : this.getJavaValue(object, object.getClass());
    }

    protected String getJavaValue(Object object, Class<?> type) {
        if (object == null || type == null) {
            return null;
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            return this.getJavaPrimitiveValue(instance.getInstanceKeyValue(), instance.getInstanceKeyType());
        }
        if (object instanceof Artifact) {
            return null;
        }
        if (object instanceof SpecialBinaryValue) {
            SpecialBinaryValue value = (SpecialBinaryValue)object;
            return this.getSpecialBinaryValue(value);
        }
        if (object instanceof SpecialBooleanValue) {
            SpecialBooleanValue value = (SpecialBooleanValue)object;
            return this.getSpecialBooleanValue(value);
        }
        if (object instanceof SpecialCharacterValue) {
            SpecialCharacterValue value = (SpecialCharacterValue)object;
            return this.getSpecialCharacterValue(value);
        }
        if (object instanceof SpecialEntityValue) {
            SpecialEntityValue value = (SpecialEntityValue)object;
            return this.getSpecialEntityValue(value);
        }
        if (object instanceof SpecialNumericValue) {
            SpecialNumericValue value = (SpecialNumericValue)object;
            return this.getSpecialNumericValue(value);
        }
        if (object instanceof SpecialTemporalValue) {
            SpecialTemporalValue value = (SpecialTemporalValue)object;
            return this.getSpecialTemporalValue(value);
        }
        if (object instanceof NamedValue) {
            NamedValue value = (NamedValue)object;
            return this.getNamedValueName(value);
        }
        return this.getJavaPrimitiveValue(object, type);
    }

    @Override
    public String getJavaPrimitiveValue(Object object, String typeName) {
        if (object == null || typeName == null) {
            return null;
        }
        Object name = typeName.contains(".") ? typeName : "java.lang." + typeName;
        Class<?> type = this.getClassForName((String)name);
        return this.getJavaPrimitiveValue(object, type);
    }

    protected Class<?> getClassForName(String className) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        String message = "failed to load " + className;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new InstantiationRuntimeException(message, ex);
        }
    }

    protected String getSpecialBinaryValue(SpecialBinaryValue value) {
        return this.getSpecialBinaryValue(value, null);
    }

    protected String getSpecialBinaryValue(SpecialBinaryValue value, ParameterizedExpression px) {
        return switch (value) {
            case SpecialBinaryValue.NULL -> "null";
            default -> null;
        };
    }

    protected String getSpecialBooleanValue(SpecialBooleanValue value) {
        return this.getSpecialBooleanValue(value, null);
    }

    protected String getSpecialBooleanValue(SpecialBooleanValue value, ParameterizedExpression px) {
        return switch (value) {
            case SpecialBooleanValue.NULL -> "null";
            case SpecialBooleanValue.TRUE -> "Boolean.TRUE";
            case SpecialBooleanValue.FALSE -> "Boolean.FALSE";
            default -> null;
        };
    }

    protected String getSpecialCharacterValue(SpecialCharacterValue value) {
        return this.getSpecialCharacterValue(value, null);
    }

    protected String getSpecialCharacterValue(SpecialCharacterValue value, ParameterizedExpression px) {
        String string;
        switch (value) {
            case NULL: {
                return "null";
            }
            case EMPTY: {
                return "\"\"";
            }
            case RGUID: {
                string = "java.util.UUID.randomUUID().toString()";
                break;
            }
            case CONTENT_ROOT_DIR: {
                string = "getContentRootDir()";
                break;
            }
            case CURRENT_USER_CODE: {
                string = "getCurrentUserCode()";
                break;
            }
            default: {
                return null;
            }
        }
        this.addSpecialValue(value, px, string);
        return string;
    }

    protected String getSpecialEntityValue(SpecialEntityValue value) {
        return this.getSpecialEntityValue(value, null);
    }

    protected String getSpecialEntityValue(SpecialEntityValue value, ParameterizedExpression px) {
        String string;
        switch (value) {
            case NULL: {
                return "null";
            }
            case CURRENT_USER: {
                string = "getCurrentUser()";
                break;
            }
            default: {
                return null;
            }
        }
        this.addSpecialValue(value, px, string);
        return string;
    }

    protected String getSpecialNumericValue(SpecialNumericValue value) {
        return this.getSpecialNumericValue(value, null);
    }

    protected String getSpecialNumericValue(SpecialNumericValue value, ParameterizedExpression px) {
        String string;
        switch (value) {
            case NULL: {
                return "null";
            }
            case CURRENT_USER_ID: {
                string = "getCurrentUserId()";
                break;
            }
            default: {
                return null;
            }
        }
        this.addSpecialValue(value, px, string);
        return string;
    }

    protected String getSpecialTemporalValue(SpecialTemporalValue value) {
        return this.getSpecialTemporalValue(value, null);
    }

    protected String getSpecialTemporalValue(SpecialTemporalValue value, ParameterizedExpression px) {
        String string;
        switch (value) {
            case NULL: {
                return "null";
            }
            case CURRENT_DATE: {
                string = "TimeUtils.currentDate()";
                break;
            }
            case CURRENT_TIME: {
                string = "TimeUtils.currentTime()";
                break;
            }
            case CURRENT_TIMESTAMP: {
                string = "TimeUtils.currentTimestamp()";
                break;
            }
            default: {
                return null;
            }
        }
        this.addSpecialValue(value, px, string);
        return string;
    }

    protected void addSpecialValue(SpecialValue value, ParameterizedExpression px, String string) {
        if (px != null) {
            px.getSpecialValuesMap().put(value, string);
        }
    }

    @Override
    public String getJavaPrimitiveValue(Object object, Class<?> type) {
        if (object == null || type == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Character.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (String.class.isAssignableFrom(type)) {
            return this.getDelimitedString(object, type);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Short.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Long.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Float.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Double.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return this.newFromString(object, type);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return this.newFromString(object, type);
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Time.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return this.valueOfString(object, type);
        }
        return null;
    }

    protected String newFromString(Object object, Class<?> type) {
        String string = this.getString(object, type);
        if (string == null) {
            return null;
        }
        return "new " + this.javaLangLess(type) + "(\"" + string + "\")";
    }

    protected String valueOfString(Object object, Class<?> type) {
        String string = this.getString(object, type);
        if (string == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            if (string.equalsIgnoreCase("true")) {
                return "Boolean.TRUE";
            }
            if (string.equalsIgnoreCase("false")) {
                return "Boolean.FALSE";
            }
            return this.javaLangLess(type) + ".valueOf(\"" + string + "\")";
        }
        if (Character.class.isAssignableFrom(type)) {
            return this.javaLangLess(type) + ".valueOf('" + string + "')";
        }
        return this.javaLangLess(type) + ".valueOf(\"" + string + "\")";
    }

    protected String javaLangLess(Class<?> type) {
        return type == null ? "Object" : (type.isArray() ? this.javaLangLess(type.getComponentType()) + "[]" : StringUtils.removeStart((String)type.getName(), (String)"java.lang."));
    }

    @Override
    public String getJavaString(String string) {
        return StrUtils.getStringJava(string);
    }

    protected String getString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            return StrUtils.getStringJava(string);
        }
        if (object instanceof Date) {
            return TimeUtils.jdbcDateString(object);
        }
        if (object instanceof Time) {
            return TimeUtils.jdbcTimeString(object);
        }
        if (object instanceof java.util.Date) {
            return TimeUtils.jdbcTimestampString(object);
        }
        return String.valueOf(object);
    }

    protected String getDelimitedString(Object object) {
        if (object == null) {
            return null;
        }
        String string = this.getString(object);
        if (string == null) {
            return null;
        }
        if (object instanceof Character) {
            return "'" + string + "'";
        }
        if (object instanceof String) {
            return "\"" + string + "\"";
        }
        if (object instanceof java.util.Date) {
            return "\"" + string + "\"";
        }
        return string;
    }

    protected String getString(Object object, Class<?> type) {
        if (object == null || type == null) {
            return null;
        }
        String errmsg = "cannot get \"" + this.javaLangLess(type) + "\" from \"" + String.valueOf(object) + "\"";
        String string = this.getString(object);
        try {
            if (string == null) {
                return null;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return EMPTY + Boolean.valueOf(string);
            }
            if (Character.class.isAssignableFrom(type)) {
                return this.getCharacterString(string);
            }
            if (String.class.isAssignableFrom(type)) {
                return string;
            }
            if (Byte.class.isAssignableFrom(type)) {
                return EMPTY + Byte.valueOf(string);
            }
            if (Short.class.isAssignableFrom(type)) {
                return EMPTY + Short.valueOf(string);
            }
            if (Integer.class.isAssignableFrom(type)) {
                return EMPTY + Integer.valueOf(string);
            }
            if (Long.class.isAssignableFrom(type)) {
                return EMPTY + Long.valueOf(string);
            }
            if (Float.class.isAssignableFrom(type)) {
                return EMPTY + Float.valueOf(string);
            }
            if (Double.class.isAssignableFrom(type)) {
                return EMPTY + Double.valueOf(string);
            }
            if (BigInteger.class.isAssignableFrom(type)) {
                return String.valueOf(new BigInteger(string));
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                return String.valueOf(new BigDecimal(string));
            }
            if (object instanceof java.util.Date && Date.class.isAssignableFrom(type)) {
                string = TimeUtils.jdbcDateString(object);
                return this.getString(Date.valueOf(string));
            }
            if (object instanceof java.util.Date && Time.class.isAssignableFrom(type)) {
                string = TimeUtils.jdbcTimeString(object);
                return this.getString(Time.valueOf(string));
            }
            if (object instanceof java.util.Date && Timestamp.class.isAssignableFrom(type)) {
                string = TimeUtils.jdbcTimestampString(object);
                return this.getString(Timestamp.valueOf(string));
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            logger.error((Object)errmsg);
            return null;
        }
    }

    protected String getCharacterString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return " ";
        }
        String s = string.trim();
        int endIndex = s.startsWith("\\") ? (s.charAt(1) == 'u' ? 6 : 2) : 1;
        return s.substring(0, endIndex);
    }

    protected String getDelimitedString(Object object, Class<?> type) {
        if (object == null || type == null) {
            return null;
        }
        String string = this.getString(object, type);
        if (string == null) {
            return null;
        }
        if (Character.class.isAssignableFrom(type)) {
            return "'" + string + "'";
        }
        if (String.class.isAssignableFrom(type)) {
            return "\"" + string + "\"";
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return "\"" + string + "\"";
        }
        return string;
    }

    @Override
    public String getJavaExpressionOfSqlExpression(String sqlExpression) {
        if (StringUtils.isBlank((String)sqlExpression)) {
            return null;
        }
        String expression = NamedQuery.getJavaExpressionOfSqlExpression(sqlExpression);
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        if (sqlProgrammer == null) {
            return expression;
        }
        String[] sqlExpressions = new String[]{sqlProgrammer.getSpecialCharacterValue(SpecialCharacterValue.CONTENT_ROOT_DIR), sqlProgrammer.getSpecialNumericValue(SpecialNumericValue.CURRENT_USER_ID), sqlProgrammer.getSpecialCharacterValue(SpecialCharacterValue.CURRENT_USER_CODE)};
        String[] javaExpressions = new String[]{"'\" + " + this.getSpecialCharacterValue(SpecialCharacterValue.CONTENT_ROOT_DIR) + " + \"'", " \" + " + this.getSpecialNumericValue(SpecialNumericValue.CURRENT_USER_ID) + " + \" ", "'\" + " + this.getSpecialCharacterValue(SpecialCharacterValue.CURRENT_USER_CODE) + " + \"'"};
        return StringUtils.replaceEachRepeatedly((String)expression, (String[])sqlExpressions, (String[])javaExpressions);
    }

    @Override
    public ParameterizedExpression getJavaParameterizedExpression(Object object) {
        ParameterizedExpression px = new ParameterizedExpression();
        String expression = this.getJavaExpression(object, px, false);
        px.setExpression(expression);
        return px;
    }

    protected String getJavaExpression(Object object, ParameterizedExpression px, boolean enclose) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objects = (Object[])object;
            return this.getJavaExpression(objects, px, enclose);
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return this.getFullVariableName(entity, px);
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            return this.getJavaPrimitiveValue(instance.getInstanceKeyValue(), instance.getInstanceKeyType());
        }
        if (object instanceof SpecialBinaryValue) {
            SpecialBinaryValue value = (SpecialBinaryValue)object;
            return this.getSpecialBinaryValue(value, px);
        }
        if (object instanceof SpecialBooleanValue) {
            SpecialBooleanValue value = (SpecialBooleanValue)object;
            return this.getSpecialBooleanValue(value, px);
        }
        if (object instanceof SpecialCharacterValue) {
            SpecialCharacterValue value = (SpecialCharacterValue)object;
            return this.getSpecialCharacterValue(value, px);
        }
        if (object instanceof SpecialEntityValue) {
            SpecialEntityValue value = (SpecialEntityValue)object;
            return this.getSpecialEntityValue(value, px);
        }
        if (object instanceof SpecialNumericValue) {
            SpecialNumericValue value = (SpecialNumericValue)object;
            return this.getSpecialNumericValue(value, px);
        }
        if (object instanceof SpecialTemporalValue) {
            SpecialTemporalValue value = (SpecialTemporalValue)object;
            return this.getSpecialTemporalValue(value, px);
        }
        if (object instanceof NamedValue) {
            NamedValue namedValue = (NamedValue)object;
            return this.getNamedValueName(namedValue, px);
        }
        if (object instanceof NativeQuery) {
            NativeQuery nativeQuery = (NativeQuery)object;
            return this.getDelimitedString(nativeQuery.getString());
        }
        if (object instanceof Expression) {
            Expression expression = (Expression)object;
            return this.getJavaExpression(expression, px, enclose);
        }
        if (object instanceof Artifact) {
            Artifact artifact = (Artifact)object;
            return this.getJavaQualifiedName(artifact);
        }
        return this.getJavaValue(object);
    }

    protected String getJavaExpression(Object[] objects, ParameterizedExpression px, boolean enclose) {
        if (objects == null) {
            return null;
        }
        ArrayList<String> expressions = new ArrayList<String>();
        for (Object object : objects) {
            String expression = this.getJavaExpression(object, px, enclose);
            if (!StringUtils.isNotBlank((String)expression)) continue;
            expressions.add(expression);
        }
        return expressions.isEmpty() ? null : "new Object[]" + StrUtils.enclose(StringUtils.join(expressions, (String)", "), '{', '}');
    }

    protected String getJavaExpression(Expression expression, ParameterizedExpression px, boolean enclose) {
        boolean call;
        String string;
        if (expression == null) {
            return null;
        }
        if (expression instanceof Property) {
            Property property = (Property)((Object)expression);
            return this.getFullVariableName(property, px);
        }
        if (expression instanceof ComparisonX) {
            ComparisonX comparisonX = (ComparisonX)expression;
            string = this.getJavaComparisonExpression(comparisonX, px);
        } else if (expression instanceof ConditionalX) {
            ConditionalX conditionalX = (ConditionalX)expression;
            string = this.getJavaConditionalExpression(conditionalX, px);
        } else if (expression instanceof DataAggregateX) {
            DataAggregateX dataAggregateX = (DataAggregateX)expression;
            string = this.getJavaDataAggregateExpression(dataAggregateX, px);
        } else if (expression instanceof RowsAggregateX) {
            RowsAggregateX rowsAggregateX = (RowsAggregateX)expression;
            string = this.getJavaRowsAggregateExpression(rowsAggregateX, px);
        } else if (expression instanceof NaryVectorX) {
            NaryVectorX naryVectorX = (NaryVectorX)expression;
            string = this.getJavaNaryVectorExpression(naryVectorX, px);
        } else if (expression instanceof OrderedPairX) {
            OrderedPairX orderedPairX = (OrderedPairX)expression;
            string = this.getJavaOrderedPairExpression(orderedPairX, px);
        } else if (expression instanceof ScalarX) {
            ScalarX scalarX = (ScalarX)expression;
            string = this.getJavaScalarExpression(scalarX, px);
        } else if (expression instanceof VariantX) {
            VariantX variantX = (VariantX)expression;
            string = this.getJavaVariantExpression(variantX, px);
        } else {
            string = this.getJavaValue(expression);
        }
        boolean bl = call = string.matches("^\\w+$") || string.matches(CALL_REGEX);
        return call ? string : (enclose ? StrUtils.encloseSqlExpression(string) : StrUtils.disclose(string));
    }

    protected String getJavaComparisonExpression(ComparisonX expression, ParameterizedExpression px) {
        ComparisonOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        Object z = expression.getZ();
        if (operator == null || x == null) {
            return null;
        }
        String arg1 = this.getJavaExpression(x, px, true);
        String arg2 = this.getJavaExpression(y, px, true);
        String arg3 = this.getJavaExpression(z, px, true);
        String pattern = switch (operator) {
            case ComparisonOp.IS_NULL, ComparisonOp.IS_NOT_NULL, ComparisonOp.IS_TRUE, ComparisonOp.IS_FALSE, ComparisonOp.IS_NULL_OR_TRUE, ComparisonOp.IS_NULL_OR_FALSE -> this.call((Operator)operator, 1);
            case ComparisonOp.EQ, ComparisonOp.NEQ, ComparisonOp.GT, ComparisonOp.GTEQ, ComparisonOp.LT, ComparisonOp.LTEQ, ComparisonOp.STARTS_WITH, ComparisonOp.NOT_STARTS_WITH, ComparisonOp.CONTAINS, ComparisonOp.NOT_CONTAINS, ComparisonOp.ENDS_WITH, ComparisonOp.NOT_ENDS_WITH, ComparisonOp.IS_IN, ComparisonOp.IS_NOT_IN, ComparisonOp.IS_NULL_OR_EQ, ComparisonOp.IS_NULL_OR_NEQ, ComparisonOp.IS_NULL_OR_GT, ComparisonOp.IS_NULL_OR_GTEQ, ComparisonOp.IS_NULL_OR_LT, ComparisonOp.IS_NULL_OR_LTEQ, ComparisonOp.IS_NULL_OR_STARTS_WITH, ComparisonOp.IS_NULL_OR_NOT_STARTS_WITH, ComparisonOp.IS_NULL_OR_CONTAINS, ComparisonOp.IS_NULL_OR_NOT_CONTAINS, ComparisonOp.IS_NULL_OR_ENDS_WITH, ComparisonOp.IS_NULL_OR_NOT_ENDS_WITH, ComparisonOp.IS_NULL_OR_IN, ComparisonOp.IS_NULL_OR_NOT_IN -> this.call((Operator)operator, 2);
            case ComparisonOp.IS_BETWEEN, ComparisonOp.IS_NOT_BETWEEN, ComparisonOp.IS_NULL_OR_BETWEEN, ComparisonOp.IS_NULL_OR_NOT_BETWEEN -> this.call((Operator)operator, 3);
            default -> this.call((Operator)operator, z == null ? (y == null ? 1 : 2) : 3);
        };
        return AbstractJavaProgrammer.format(pattern, arg1, arg2, arg3);
    }

    protected String getJavaConditionalExpression(ConditionalX expression, ParameterizedExpression px) {
        BooleanExpression b = expression.getBooleanExpression();
        Object x = expression.getThenValue();
        Object y = expression.getElseValue();
        if (b == null || x == null) {
            return null;
        }
        if (b instanceof BooleanPrimitive) {
            b = b.isTrue();
        }
        String arg0 = this.getJavaExpression(b, px, true);
        String arg1 = this.getJavaExpression(x, px, true);
        String arg2 = this.getJavaExpression(y, px, true);
        String pattern = y == null ? "{0} ? {1} : null" : "{0} ? {1} : {2}";
        return AbstractJavaProgrammer.format(pattern, arg0, arg1, arg2);
    }

    protected String getJavaDataAggregateExpression(DataAggregateX expression, ParameterizedExpression px) {
        DataAggregateOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        if (operator == null || operands == null || operands.length < 2) {
            return null;
        }
        String[] arguments = new String[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            arguments[i] = StrUtils.disclose(this.getJavaExpression(operands[i], px, true));
        }
        switch (operator) {
            default: 
        }
        String string = this.call((Operator)operator, arguments);
        return string;
    }

    protected String getJavaRowsAggregateExpression(RowsAggregateX expression, ParameterizedExpression px) {
        Object errmsg = EMPTY;
        if (expression == null) {
            return null;
        }
        errmsg = (String)errmsg + "failed to generate code for expression " + this.stringOf(expression);
        Entity declaringEntity = expression.getDeclaringEntity();
        if (declaringEntity == null) {
            logger.error(errmsg);
            return null;
        }
        errmsg = (String)errmsg + " at entity " + this.stringOf(declaringEntity);
        String function = this.getJavaExpressionSelectFunctionName(expression);
        if (function == null) {
            logger.error(errmsg);
            return null;
        }
        Entity dimension = expression.getDimension();
        Property argument = dimension instanceof Property ? (Property)((Object)dimension) : null;
        String argname = argument == null ? EMPTY : this.getFullVariableName(argument, px);
        return function + "(" + argname + ")";
    }

    protected String getJavaNaryVectorExpression(NaryVectorX expression, ParameterizedExpression px) {
        int length;
        NaryVectorOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        int n = length = operands == null ? 0 : operands.length;
        if (operator == null || length == 0) {
            return null;
        }
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.getJavaExpression(operands[i], px, true);
        }
        Object[] arguments = new Object[length];
        for (int i = 0; i < length; ++i) {
            arguments[i] = StrUtils.disclose(strings[i]);
        }
        String pattern = this.call((Operator)operator, length);
        return AbstractJavaProgrammer.format(pattern, arguments);
    }

    protected String getJavaOrderedPairExpression(OrderedPairX expression, ParameterizedExpression px) {
        OrderedPairOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        if (operator == null || x == null || y == null) {
            return null;
        }
        String arg1 = this.getJavaExpression(x, px, true);
        String arg2 = this.getJavaExpression(y, px, true);
        switch (operator) {
            default: 
        }
        arg1 = StrUtils.disclose(arg1);
        arg2 = StrUtils.disclose(arg2);
        String pattern = this.call((Operator)operator, 2);
        return AbstractJavaProgrammer.format(pattern, arg1, arg2);
    }

    protected String getJavaScalarExpression(ScalarX expression, ParameterizedExpression px) {
        ScalarOp operator = expression.getOperator();
        Object operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        String arg1 = this.getJavaExpression(operand, px, false);
        String arg2 = this.getJavaExpressionDefaultValue(expression);
        if (operator == null || operator.equals(ScalarOp.SELF)) {
            return arg1;
        }
        boolean varchar = operand instanceof String || operand instanceof CharacterExpression;
        return AbstractJavaProgrammer.format(switch (operator) {
            case ScalarOp.DEFAULT_WHEN_NULL -> this.call("coalesce", 2);
            case ScalarOp.NULL_WHEN_DEFAULT -> this.call("nullif", 2);
            case ScalarOp.TO_DATE -> this.call(varchar ? "as_date" : "to_date", 1);
            case ScalarOp.TO_TIME -> this.call(varchar ? "as_time" : "to_time", 1);
            case ScalarOp.TO_TIMESTAMP -> this.call(varchar ? "as_timestamp" : "to_timestamp", 1);
            default -> this.call((Operator)operator, 1);
        }, arg1, arg2);
    }

    protected String getJavaVariantExpression(VariantX expression, ParameterizedExpression px) {
        Expression foreignExpression;
        Object errmsg = EMPTY;
        if (expression == null) {
            return null;
        }
        errmsg = (String)errmsg + "failed to generate code for expression " + this.stringOf(expression);
        Entity declaringEntity = expression.getDeclaringEntity();
        if (declaringEntity == null) {
            logger.error(errmsg);
            return null;
        }
        errmsg = (String)errmsg + " at entity " + this.stringOf(declaringEntity);
        String function = this.getJavaExpressionFunctionName(expression);
        Property argument = expression.getExpressionFunctionArgument();
        if (function == null || argument == null) {
            logger.error(errmsg);
            return null;
        }
        boolean doubtful = declaringEntity.isRootInstance();
        if (doubtful && (foreignExpression = expression.getForeignExpression()) instanceof RowsAggregateX) {
            RowsAggregateX foreignRowsAggregateX = (RowsAggregateX)foreignExpression;
            String select = this.getJavaExpressionSelectFunctionName(foreignRowsAggregateX);
            if (select != null) {
                Entity dimension = foreignRowsAggregateX.getDimension();
                if (dimension == null) {
                    function = select;
                    argument = null;
                    doubtful = false;
                } else if (declaringEntity.getClass().isAssignableFrom(dimension.getClass())) {
                    function = select;
                    doubtful = false;
                }
            }
            if (doubtful) {
                errmsg = (String)errmsg + "; cannot bind it to its foreign expression " + this.stringOf(foreignExpression);
                errmsg = (String)errmsg + " at entity " + this.stringOf(foreignExpression.getDeclaringEntity());
            }
        }
        if (doubtful) {
            logger.error(errmsg);
            return null;
        }
        if (argument == null) {
            return function + "()";
        }
        return function + "(" + this.getFullVariableName(argument, px) + ")";
    }

    protected String getJavaExpressionFunctionName(Expression expression) {
        Entity e = expression.getDeclaringEntity();
        return e == null ? this.getJavaName(expression) : this.getJavaName(e.getRoot()) + "_" + this.getJavaName(expression);
    }

    protected String getJavaExpressionSelectFunctionName(Expression expression) {
        Entity declaringEntity = expression instanceof RowsAggregateX ? expression.getDeclaringEntity() : null;
        return declaringEntity == null ? this.getJavaName(expression) : this.getJavaName(declaringEntity.getRoot()) + "_select_" + this.getJavaName(expression);
    }

    protected String stringOf(Expression e) {
        return e == null ? "?" : (e.getName() != null ? e.getName() : (e.getParentExpression() != null ? this.stringOf(e.getParentExpression()) + "[" + e.toString() + "]" : e.toString()));
    }

    protected String stringOf(Entity e) {
        return e == null ? "?" : (e.getName() != null ? e.getName() : e.toString());
    }

    protected String getJavaExpressionDefaultValue(Expression expression) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = expression == null ? null : expression.getDataType();
        if (clazz == null) {
            return "null";
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return "false";
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return "' '";
        }
        if (String.class.isAssignableFrom(clazz)) {
            return "\"\"";
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return "0";
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return "0";
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return "0";
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return "0L";
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return "0.0F";
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return "0.0D";
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return "BigDecimal.ZERO";
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return "BigDecimal.ZERO";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "new Date(0)";
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return "new Time(0)";
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return "new Timestamp(0)";
        }
        return "null";
    }

    protected String getFullVariableName(Artifact artifact, ParameterizedExpression px) {
        String name;
        if (artifact == null) {
            return null;
        }
        String string = name = RTL ? this.getPrefixedVariableName(artifact) : this.getSuffixedVariableName(artifact);
        if (px != null) {
            px.getParametersMap().put(name, artifact);
        }
        return name;
    }

    protected String getPrefixedVariableName(Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        String prefix = declaringArtifact == null ? EMPTY : this.getPrefixedVariableName(declaringArtifact) + "_";
        return prefix + this.getJavaVariableName(artifact);
    }

    protected String getSuffixedVariableName(Artifact artifact) {
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        String suffix = declaringArtifact == null ? EMPTY : "_" + this.getSuffixedVariableName(declaringArtifact);
        return this.getJavaVariableName(artifact) + suffix;
    }

    protected String getNamedValueName(NamedValue namedValue) {
        return this.getNamedValueName(namedValue, null);
    }

    protected String getNamedValueName(NamedValue namedValue, ParameterizedExpression px) {
        String name = namedValue.name();
        if (px != null) {
            px.getNamedValuesMap().put(name, namedValue);
        }
        return name;
    }

    protected String call(Operator operator, int arguments) {
        String function = operator.name().toLowerCase();
        return this.call(function, arguments);
    }

    protected String call(String function, int arguments) {
        String[] placeHolders = null;
        if (arguments > 0) {
            placeHolders = new String[arguments];
            for (int i = 0; i < arguments; ++i) {
                placeHolders[i] = "{" + i + "}";
            }
        }
        return this.call(function, placeHolders);
    }

    protected String call(Operator operator, String ... arguments) {
        String function = operator.name().toLowerCase();
        return this.call(function, arguments);
    }

    protected String call(String function, String ... arguments) {
        String method = function.contains(".") ? function : "ObjUtils." + StrUtils.getCamelCase(function, true);
        String string = arguments == null || arguments.length == 0 ? "()" : StrUtils.enclose(StringUtils.join((Object[])arguments, (String)", "));
        return method + string;
    }
}

