/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.properties.ext;

import adalid.core.enums.PhoneNumberFormat;
import adalid.core.properties.ext.AbstractPhoneNumberProperty;
import java.util.regex.Pattern;

public class InternationalPhoneNumberProperty
extends AbstractPhoneNumberProperty {
    public InternationalPhoneNumberProperty() {
        this.setMaxLength(20);
        this.setPattern(Pattern.compile("^\\+(?:\\d{1,3})[-\\s](?:\\d{1,4})(?:[-\\s]?\\d{6,10})$"));
        this.setSpecialValidatorName("phoneNumberValidator");
        this.setLocalizedDescription(ENGLISH, "this is an international phone number; it must start with a country code, followed by a global subscriber number or an area code and a subscriber number; for example: +58 4121234567, +58-412-1234567");
        this.setLocalizedDescription(SPANISH, "este es un n\u00famero de tel\u00e9fono internacional; debe comenzar con un c\u00f3digo de pa\u00eds, seguido de un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: +58 4121234567, +58-412-1234567");
        this.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; it must start with a country code, i.e. a plus sign and a group of 1 to 3 digits, followed by a global subscriber number, i.e. a group of 7 to 14 digits; country code and global subscriber number must be separated by a single white space or hyphen; global subscriber number can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; whatever their distribution among the groups, the total number of digits must be between 8 and 15.");
        this.setLocalizedRegexErrorMessage(SPANISH, "el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe comenzar con un c\u00f3digo de pa\u00eds, es decir, un signo m\u00e1s y un grupo de 1 hasta 3 d\u00edgitos, seguido de un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; el c\u00f3digo de pa\u00eds y el n\u00famero de suscriptor global deben estar separados por un solo espacio en blanco o gui\u00f3n; el n\u00famero de suscriptor global se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 8 y 15.");
    }

    @Override
    public final PhoneNumberFormat getPhoneNumberFormat() {
        return PhoneNumberFormat.INTERNATIONAL;
    }
}

