/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.sql;

import adalid.core.enums.SqlQualifierType;
import adalid.core.sql.QualifiedQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NativeQuery {
    private final Map<SqlQualifierType, String> _qualifiedQueries = new LinkedHashMap<SqlQualifierType, String>();
    private String _unqualifiedStatement;

    public static NativeQuery of(QualifiedQuery ... qualifiedQueries) {
        return new NativeQuery(qualifiedQueries);
    }

    public static NativeQuery of(String unqualifiedStatement) {
        return new NativeQuery(unqualifiedStatement);
    }

    NativeQuery(QualifiedQuery ... qualifiedQueries) {
        if (qualifiedQueries != null && qualifiedQueries.length > 0) {
            for (QualifiedQuery qq : qualifiedQueries) {
                String statement = qq.getStatement();
                if (!StringUtils.isNotBlank((String)statement)) continue;
                SqlQualifierType type = qq.getType();
                if (type != null) {
                    this._qualifiedQueries.put(type, statement);
                    continue;
                }
                this._unqualifiedStatement = statement;
            }
        }
    }

    NativeQuery(String unqualifiedStatement) {
        this._unqualifiedStatement = unqualifiedStatement;
    }

    public String getString(SqlQualifierType qualifier) {
        return StringUtils.defaultIfBlank((String)this._qualifiedQueries.get((Object)qualifier), (String)this._unqualifiedStatement);
    }

    public String getString() {
        return this._unqualifiedStatement;
    }
}

