/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.wrappers;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractEntity;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.wrappers.DataArtifactWrapper;
import org.apache.commons.lang.StringUtils;

public class EntityWrapper
extends DataArtifactWrapper {
    private final Entity _entity;
    private final AbstractEntity _abstractEntity;

    public EntityWrapper(Entity entity) {
        super(entity);
        this._entity = entity;
        this._abstractEntity = this._entity instanceof AbstractEntity ? (AbstractEntity)this._entity : null;
    }

    @Override
    public Entity getWrapped() {
        return this._entity;
    }

    public String getSelectFilterTag() {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getSelectFilterTag(), this._abstractEntity.getSelectFilter());
    }

    public String getInsertFilterTag(EntityReference reference) {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getInsertFilterTag(), this._abstractEntity.getInsertFilter(reference));
    }

    public String getUpdateFilterTag() {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getUpdateFilterTag(), this._abstractEntity.getUpdateFilter());
    }

    public String getDeleteFilterTag() {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getDeleteFilterTag(), this._abstractEntity.getDeleteFilter());
    }

    public String getSearchQueryFilterTag() {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getSearchQueryFilterTag(), this._abstractEntity.getSearchQueryFilter());
    }

    public String getMasterDetailFilterTag(EntityReference reference) {
        return this._abstractEntity == null ? null : this.artifactTag(this._abstractEntity.getMasterDetailFilterTag(), this._abstractEntity.getMasterDetailFilter(reference));
    }

    public String getValidDefaultLabel(EntityReference reference) {
        String string = reference == null ? null : this._entity.getDefaultLabel(reference);
        return StringUtils.isNotBlank((String)string) ? string : this.getValidDefaultLabel();
    }

    public String getValidDefaultShortLabel(EntityReference reference) {
        String string = reference == null ? null : this._entity.getDefaultShortLabel(reference);
        return StringUtils.isNotBlank((String)string) ? string : this.getValidDefaultShortLabel();
    }

    public String getValidDefaultCollectionLabel(EntityReference reference) {
        String string = reference == null ? null : this._entity.getDefaultCollectionLabel(reference);
        return StringUtils.isNotBlank((String)string) ? string : this.getValidDefaultCollectionLabel();
    }

    public String getValidDefaultCollectionShortLabel(EntityReference reference) {
        String string = reference == null ? null : this._entity.getDefaultCollectionShortLabel(reference);
        return StringUtils.isNotBlank((String)string) ? string : this.getValidDefaultCollectionShortLabel();
    }

    @Override
    public String getValidDefaultTooltip() {
        return StrUtils.coalesce(this.getDefaultTooltip(), this.getDefaultShortDescription(), this.getValidDefaultLabel());
    }

    public String getBundleValidDefaultLabel(EntityReference reference) {
        return this.getBundleValueString(this.getValidDefaultLabel(reference));
    }

    public String getBundleValidDefaultShortLabel(EntityReference reference) {
        return this.getBundleValueString(this.getValidDefaultShortLabel(reference));
    }

    public String getBundleValidDefaultCollectionLabel(EntityReference reference) {
        return this.getBundleValueString(this.getValidDefaultCollectionLabel(reference));
    }

    public String getBundleValidDefaultCollectionShortLabel(EntityReference reference) {
        return this.getBundleValueString(this.getValidDefaultCollectionShortLabel(reference));
    }

    public String getJavaValidDefaultLabel(EntityReference reference) {
        return this.getJavaString(this.getValidDefaultLabel(reference));
    }

    public String getJavaValidDefaultShortLabel(EntityReference reference) {
        return this.getJavaString(this.getValidDefaultShortLabel(reference));
    }

    public String getJavaValidDefaultCollectionLabel(EntityReference reference) {
        return this.getJavaString(this.getValidDefaultCollectionLabel(reference));
    }

    public String getJavaValidDefaultCollectionShortLabel(EntityReference reference) {
        return this.getJavaString(this.getValidDefaultCollectionShortLabel(reference));
    }

    public String getXmlValidDefaultLabel(EntityReference reference) {
        return this.getXmlString(this.getValidDefaultLabel(reference));
    }

    public String getXmlValidDefaultShortLabel(EntityReference reference) {
        return this.getXmlString(this.getValidDefaultShortLabel(reference));
    }

    public String getXmlValidDefaultCollectionLabel(EntityReference reference) {
        return this.getXmlString(this.getValidDefaultCollectionLabel(reference));
    }

    public String getXmlValidDefaultCollectionShortLabel(EntityReference reference) {
        return this.getXmlString(this.getValidDefaultCollectionShortLabel(reference));
    }
}

