/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.wrappers;

import adalid.commons.bundles.Bundle;
import adalid.core.Primitive;
import adalid.core.enums.SqlQualifierType;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.JavaProgrammer;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.ArtifactWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExpressionWrapper
extends ArtifactWrapper {
    private final Expression _expression;
    private final BooleanExpression _booleanExpression;

    public ExpressionWrapper(Expression expression) {
        super(expression);
        this._expression = expression;
        this._booleanExpression = expression instanceof BooleanExpression ? (BooleanExpression)expression : null;
    }

    @Override
    public Expression getWrapped() {
        return this._expression;
    }

    public String getDefaultErrorMessage() {
        if (this._booleanExpression == null) {
            return null;
        }
        return this._booleanExpression.getDefaultErrorMessage();
    }

    public String getDefaultErrorMessageJoin() {
        if (this._booleanExpression == null) {
            return null;
        }
        return this.getDefaultErrorMessageJoin(null);
    }

    public String getDefaultErrorMessageJoin(String separator) {
        if (this._booleanExpression == null) {
            return null;
        }
        List<String> messages = this.getDefaultErrorMessagesList();
        String sep = StringUtils.isBlank((String)separator) ? Bundle.getTrimmedToEmptyString("error_message_join_separator.string") + " " : separator;
        return StringUtils.join(messages, (String)sep);
    }

    public String getDefaultErrorMessageChoice() {
        if (this._booleanExpression == null) {
            return null;
        }
        String message = this.getDefaultErrorMessage();
        return StringUtils.isNotBlank((String)message) ? message : this.getDefaultErrorMessageJoin();
    }

    public String getDefaultErrorMessageChoice(String separator) {
        if (this._booleanExpression == null) {
            return null;
        }
        String message = this.getDefaultErrorMessage();
        return StringUtils.isNotBlank((String)message) ? message : this.getDefaultErrorMessageJoin(separator);
    }

    public List<String> getDefaultErrorMessagesList() {
        ArrayList<String> defaultErrorMessagesList = new ArrayList<String>();
        if (this._booleanExpression == null) {
            return defaultErrorMessagesList;
        }
        defaultErrorMessagesList.addAll(this.getDefaultErrorMessagesList(this._booleanExpression));
        return defaultErrorMessagesList;
    }

    private List<String> getDefaultErrorMessagesList(BooleanExpression booleanExpression) {
        ArrayList<String> defaultErrorMessagesList = new ArrayList<String>();
        List<Expression> expressions = this.getExpressionsList(booleanExpression);
        for (Expression expression : expressions) {
            if (!(expression instanceof BooleanExpression)) continue;
            BooleanExpression booleanExpression1 = (BooleanExpression)expression;
            BooleanExpression bex = booleanExpression1;
            String defaultErrorMessage = bex.getDefaultErrorMessage();
            if (defaultErrorMessage == null) {
                defaultErrorMessagesList.addAll(this.getDefaultErrorMessagesList(bex));
                continue;
            }
            defaultErrorMessagesList.add(defaultErrorMessage);
        }
        return defaultErrorMessagesList;
    }

    public String getDefaultFilterDescription() {
        if (this._booleanExpression == null) {
            return null;
        }
        return this._booleanExpression.getDefaultDescription();
    }

    public String getDefaultFilterDescriptionJoin() {
        if (this._booleanExpression == null) {
            return null;
        }
        return this.getDefaultFilterDescriptionJoin(null);
    }

    public String getDefaultFilterDescriptionJoin(String separator) {
        if (this._booleanExpression == null) {
            return null;
        }
        List<String> descriptions = this.getDefaultFilterDescriptionsList();
        String sep = StringUtils.isBlank((String)separator) ? Bundle.getTrimmedToEmptyString("filter_description_join_separator.string") + " " : separator;
        return StringUtils.join(descriptions, (String)sep);
    }

    public String getDefaultFilterDescriptionChoice() {
        if (this._booleanExpression == null) {
            return null;
        }
        String description = this.getDefaultFilterDescription();
        return StringUtils.isNotBlank((String)description) ? description : this.getDefaultFilterDescriptionJoin();
    }

    public String getDefaultFilterDescriptionChoice(String separator) {
        if (this._booleanExpression == null) {
            return null;
        }
        String description = this.getDefaultFilterDescription();
        return StringUtils.isNotBlank((String)description) ? description : this.getDefaultFilterDescriptionJoin(separator);
    }

    public List<String> getDefaultFilterDescriptionsList() {
        ArrayList<String> defaultFilterDescriptionsList = new ArrayList<String>();
        if (this._booleanExpression == null) {
            return defaultFilterDescriptionsList;
        }
        defaultFilterDescriptionsList.addAll(this.getDefaultFilterDescriptionsList(this._booleanExpression));
        return defaultFilterDescriptionsList;
    }

    private List<String> getDefaultFilterDescriptionsList(BooleanExpression booleanExpression) {
        ArrayList<String> defaultFilterDescriptionsList = new ArrayList<String>();
        List<Expression> expressions = this.getExpressionsList(booleanExpression);
        for (Expression expression : expressions) {
            if (!(expression instanceof BooleanExpression)) continue;
            BooleanExpression booleanExpression1 = (BooleanExpression)expression;
            BooleanExpression bex = booleanExpression1;
            String defaultDescription = bex.getDefaultDescription();
            if (defaultDescription == null) {
                defaultFilterDescriptionsList.addAll(this.getDefaultFilterDescriptionsList(bex));
                continue;
            }
            defaultFilterDescriptionsList.add(defaultDescription);
        }
        return defaultFilterDescriptionsList;
    }

    public List<Expression> getExpressionsList(Expression expression) {
        ArrayList<Expression> expressionsList = new ArrayList<Expression>();
        Object[] operands = expression.getOperands();
        if (operands != null && operands.length > 0) {
            for (Object operand : operands) {
                Expression expression1;
                if (operand instanceof Primitive || !(operand instanceof Expression)) continue;
                Expression ex = expression1 = (Expression)operand;
                expressionsList.add(ex);
            }
        }
        return expressionsList;
    }

    public String getBundleDefaultErrorMessage() {
        return this.getBundleValueString(this.getDefaultErrorMessage());
    }

    public String getBundleDefaultErrorMessageJoin() {
        return this.getBundleValueString(this.getDefaultErrorMessageJoin());
    }

    public String getBundleDefaultErrorMessageJoin(String separator) {
        return this.getBundleValueString(this.getDefaultErrorMessageJoin(separator));
    }

    public String getBundleDefaultErrorMessageChoice() {
        return this.getBundleValueString(this.getDefaultErrorMessageChoice());
    }

    public String getBundleDefaultErrorMessageChoice(String separator) {
        return this.getBundleValueString(this.getDefaultErrorMessageChoice(separator));
    }

    public String getXmlDefaultErrorMessage() {
        return this.getXmlString(this.getDefaultErrorMessage());
    }

    public String getXmlDefaultErrorMessageJoin() {
        return this.getXmlString(this.getDefaultErrorMessageJoin());
    }

    public String getXmlDefaultErrorMessageJoin(String separator) {
        return this.getXmlString(this.getDefaultErrorMessageJoin(separator));
    }

    public String getXmlDefaultErrorMessageChoice() {
        return this.getXmlString(this.getDefaultErrorMessageChoice());
    }

    public String getXmlDefaultErrorMessageChoice(String separator) {
        return this.getXmlString(this.getDefaultErrorMessageChoice(separator));
    }

    public String getJavaType() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaType(this._expression);
    }

    public ParameterizedExpression getJavaParameterizedExpression() {
        JavaProgrammer javaProgrammer = ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaParameterizedExpression(this._expression);
    }

    public String getSqlDefaultErrorMessageChoice() {
        return this.getSqlString(this.getDefaultErrorMessageChoice());
    }

    public String getSqlDefaultErrorMessageChoice(String separator) {
        return this.getSqlString(this.getDefaultErrorMessageChoice(separator));
    }

    public String getSqlType() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlType(this._expression);
    }

    public String getSqlParameterType() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterType(this._expression);
    }

    public String getSqlExpressionFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpressionFunctionName(this._expression);
    }

    public String getSqlExpressionFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpressionFunctionName(this._expression, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedExpressionFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedExpressionFunctionName(this._expression);
    }

    public String getSqlSchemaQualifiedExpressionFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedExpressionFunctionName(this._expression, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedShortExpressionFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortExpressionFunctionName(this._expression);
    }

    public String getSqlSchemaQualifiedShortExpressionFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortExpressionFunctionName(this._expression, maxIdentifierLength);
    }

    public String getSqlExpressionSelectFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpressionSelectFunctionName(this._expression);
    }

    public String getSqlExpressionSelectFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpressionSelectFunctionName(this._expression, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedExpressionSelectFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedExpressionSelectFunctionName(this._expression);
    }

    public String getSqlSchemaQualifiedExpressionSelectFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedExpressionSelectFunctionName(this._expression, maxIdentifierLength);
    }

    public String getSqlSchemaQualifiedShortExpressionSelectFunctionName() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortExpressionSelectFunctionName(this._expression);
    }

    public String getSqlSchemaQualifiedShortExpressionSelectFunctionName(int maxIdentifierLength) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSchemaQualifiedShortExpressionSelectFunctionName(this._expression, maxIdentifierLength);
    }

    @Override
    public String getSqlExpression() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression(this._expression);
    }

    public String getSqlExpression(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression((Object)this._expression, queryTable);
    }

    public String getSqlExpression(QueryTable queryTable, SqlQualifierType qualifier) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression((Object)this._expression, queryTable, qualifier);
    }

    public String getSqlExpression(Map<String, QueryTable> queryTablesMap) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression((Object)this._expression, queryTablesMap);
    }

    public String getSqlExpression(Map<String, QueryTable> queryTablesMap, SqlQualifierType qualifier) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlExpression((Object)this._expression, queryTablesMap, qualifier);
    }

    public String getSqlJavaExpression() {
        return this.replaceSpecialValues(this.getSqlExpression());
    }

    public String getSqlJavaExpression(QueryTable queryTable) {
        return this.replaceSpecialValues(this.getSqlExpression(queryTable));
    }

    public String getSqlJavaExpression(QueryTable queryTable, SqlQualifierType qualifier) {
        return this.replaceSpecialValues(this.getSqlExpression(queryTable, qualifier));
    }

    public String getSqlJavaExpression(Map<String, QueryTable> queryTablesMap) {
        return this.replaceSpecialValues(this.getSqlExpression(queryTablesMap));
    }

    public String getSqlJavaExpression(Map<String, QueryTable> queryTablesMap, SqlQualifierType qualifier) {
        return this.replaceSpecialValues(this.getSqlExpression(queryTablesMap, qualifier));
    }

    private String replaceSpecialValues(String sqlExpression) {
        JavaProgrammer javaProgrammer = StringUtils.isBlank((String)sqlExpression) ? null : ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? null : javaProgrammer.getJavaExpressionOfSqlExpression(sqlExpression);
    }

    @Override
    public ParameterizedExpression getSqlParameterizedExpression() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression(this._expression);
    }

    public ParameterizedExpression getSqlParameterizedExpression(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression((Object)this._expression, queryTable);
    }

    public ParameterizedExpression getSqlParameterizedExpression(QueryTable queryTable, SqlQualifierType qualifier) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression((Object)this._expression, queryTable, qualifier);
    }

    public ParameterizedExpression getSqlParameterizedExpression(Map<String, QueryTable> queryTablesMap) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression((Object)this._expression, queryTablesMap);
    }

    public ParameterizedExpression getSqlParameterizedExpression(Map<String, QueryTable> queryTablesMap, SqlQualifierType qualifier) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlParameterizedExpression((Object)this._expression, queryTablesMap, qualifier);
    }

    public String getSqlSelectStatement() {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSelectStatement(this._expression);
    }

    public String getSqlSelectStatement(QueryTable queryTable) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? null : sqlProgrammer.getSqlSelectStatement(this._expression, queryTable);
    }
}

