/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2;

import adalid.commons.util.StrUtils;

public class WebApplication {
    private final String _code;
    private final String _name;
    private final String _description;
    private final boolean _public;
    private String _numericCode;
    private Long _id;

    public static WebApplication of(String code) {
        return new WebApplication(code, null, null, false, null);
    }

    public static WebApplication of(String code, String name) {
        return new WebApplication(code, name, null, false, null);
    }

    public static WebApplication of(String code, String name, String description) {
        return new WebApplication(code, name, description, false, null);
    }

    public static WebApplication of(String code, String name, String description, boolean publicAccess) {
        return new WebApplication(code, name, description, publicAccess, null);
    }

    public static WebApplication of(String code, String name, String description, boolean publicAccess, Long id) {
        return new WebApplication(code, name, description, publicAccess, id);
    }

    private WebApplication(String code, String name, String description, boolean publicAccess, Long id) {
        this._code = StrUtils.getIdentifier(code, "-");
        this._name = name == null ? null : name.replaceAll("\\p{Cntrl}", " ");
        this._description = description == null ? null : description.replaceAll("\\p{Cntrl}", " ");
        this._public = publicAccess;
        this._numericCode = id == null ? this.numericCode(this._code) : id.toString();
        this._id = id;
    }

    private String numericCode(String key) {
        String humplessKey = StrUtils.getHumplessCase(key, '_');
        String numericCode = StrUtils.getLongNumericKeyCode(humplessKey);
        return numericCode;
    }

    public String getCode() {
        return this._code;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isPublic() {
        return this._public;
    }

    public String getNumericCode() {
        return this._numericCode;
    }

    public Long getId() {
        return this._id;
    }

    public void setId(Long id) {
        this._id = id;
        this._numericCode = id == null ? this.numericCode(this._code) : id.toString();
    }

    public String toString() {
        return super.toString() + " {id=" + this._numericCode + ", code=" + this._code + ", name=" + this._name + ", description=" + this._description + ", public=" + this._public + "}";
    }
}

