/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.bundles;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.ThrowableUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BundleBase {
    private static final Logger logger = Logger.getLogger(BundleBase.class);
    private static final String NBSP = "\u00a0";
    private static final String BASE_NAME = BundleBase.class.getName();
    private static final Locale[] supported_locales = Bundle.getSupportedLocales();
    private static final Map<Locale, Locale> locales = new LinkedHashMap<Locale, Locale>();
    private static final Map<Locale, ResourceBundle> bundles = new LinkedHashMap<Locale, ResourceBundle>();

    private static void load() {
        Locale[] supportedLocales;
        logger.trace((Object)BASE_NAME);
        for (Locale locale : supportedLocales = supported_locales) {
            Locale localePlus;
            ResourceBundle bundlePlus;
            ResourceBundle bundle = BundleBase.putBundle(locale);
            if (bundle == null || (bundlePlus = BundleBase.putBundle(localePlus = new Locale(locale.getLanguage(), locale.getCountry(), "PLUS"))) == null) continue;
            locales.put(locale, localePlus);
        }
    }

    private static ResourceBundle putBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BASE_NAME, locale);
            bundles.put(locale, bundle);
            return bundle;
        }
        catch (Exception ex) {
            BundleBase.error(ex.getClass().getSimpleName() + "@" + BASE_NAME + "." + String.valueOf(locale));
            BundleBase.error(ThrowableUtils.getString(ex));
            return null;
        }
    }

    private static void error(String message) {
        logger.error((Object)message);
    }

    private static Locale getLocalePlus(Locale locale) {
        return locale == null ? null : locales.get(locale);
    }

    private static ResourceBundle getBundle(Locale locale) {
        return locale == null ? null : bundles.get(locale);
    }

    public static String getString(String key) {
        return BundleBase.getString(key, Bundle.getLocale());
    }

    public static String getString(String key, Locale locale) {
        if (StringUtils.isNotBlank((String)key) && Bundle.isSupportedLocale(locale)) {
            Locale[] localities;
            for (Locale locality : localities = new Locale[]{BundleBase.getLocalePlus(locale), locale}) {
                Object string;
                ResourceBundle bundle;
                if (locality == null || (bundle = BundleBase.getBundle(locality)) == null || (string = BundleBase.getString(key, bundle)) == null) continue;
                if (((String)string).endsWith("\b")) {
                    string = (String)string + NBSP;
                }
                return StringUtils.trimToNull((String)string);
            }
        }
        return null;
    }

    private static String getString(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        BundleBase.load();
    }
}

