/*
 * Decompiled with CFR 0.152.
 */
package adalid.util;

import adalid.commons.ProjectBuilder;
import adalid.commons.util.ColUtils;
import adalid.commons.util.JavaUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.core.annotations.MasterProject;
import adalid.util.RunnableClass;
import adalid.util.Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Runner
extends Utility {
    private static final Logger logger = Logger.getLogger(Runner.class);
    private static final ResourceBundle RB = ResourceBundle.getBundle(Runner.class.getCanonicalName());
    private final String LAST_EXECUTED = "${lastExecutedProject}";
    private final String EXECUTE_MESSAGE = "\n\n\u00bfDesea ejecutar la clase?";
    private final String EXECUTE_TITLE = "Ejecutar ";

    public static void run(Class<? extends Runner> mainRunner) {
        Runner runner = new Runner();
        runner.sprint(mainRunner);
    }

    private void sprint(Class<? extends Runner> mainRunner) {
        Collection<String> names;
        long millis = System.currentTimeMillis();
        logger.warn((Object)this.starting(mainRunner));
        String runner = mainRunner.getCanonicalName();
        String prefix = StringUtils.substringBeforeLast((String)mainRunner.getPackageName(), (String)".");
        String exclude = "." + (WINDOWS ? "linux" : "windows") + ".";
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Class<? extends ProjectBuilder> lastExecutedProjectClass = Runner.getLastExecutedProjectClass();
        if (lastExecutedProjectClass != null) {
            logger.info((Object)("last-executed-project=" + lastExecutedProjectClass.getCanonicalName()));
            set.add(lastExecutedProjectClass.getCanonicalName());
        }
        Set<Class<?>> masters = JavaUtils.getTypes(prefix, MasterProject.class);
        set.addAll(JavaUtils.getCanonicalNames(ColUtils.filter(masters, o -> this.runnableProject(o))));
        Set<Class<?>> utilities = JavaUtils.getSubTypes(prefix, Utility.class);
        set.addAll(JavaUtils.getCanonicalNames(ColUtils.filter(utilities, o -> this.runnableUtility(o))));
        Collection<String> collection = names = set.isEmpty() ? null : ColUtils.filter(set, o -> this.fairName(o, prefix, exclude, runner));
        if (names != null && !names.isEmpty()) {
            this.execute(this.showInputDialog(names));
        }
        logger.warn((Object)this.finished(mainRunner, millis));
    }

    private boolean runnableProject(Object o) {
        Class c = o instanceof Class ? (Class)o : null;
        MasterProject a = c == null ? null : c.getAnnotation(MasterProject.class);
        return a != null && a.runnable();
    }

    private boolean runnableUtility(Object o) {
        Class c = o instanceof Class ? (Class)o : null;
        RunnableClass a = c == null ? null : c.getAnnotation(RunnableClass.class);
        return a != null && a.value();
    }

    private boolean fairName(Object o, String prefix, String infix, String runner) {
        String name = o == null ? null : o.toString();
        return name != null && name.startsWith(prefix) && !name.contains(infix) && !name.equals(runner);
    }

    private String showInputDialog(Collection<String> names) {
        Object initialValue;
        String message = "Clase";
        String title = "Seleccione la clase que desea ejecutar";
        int type = 3;
        Object[] values = names.toArray();
        Object value = JOptionPane.showInputDialog(null, message, "Seleccione la clase que desea ejecutar", 3, null, values, initialValue = values[0]);
        return value == null ? null : value.toString();
    }

    private void execute(String name) {
        boolean execute;
        if (name == null || name.isEmpty()) {
            return;
        }
        String string = this.getString(name);
        if (string == null) {
            logger.info((Object)("execute=" + name));
        } else if (string.contains("${lastExecutedProject}")) {
            String lastExecutedProjectAlias = Runner.getLastExecutedProjectAlias();
            String lastExecutedProjectClassName = Runner.getLastExecutedProjectClassName();
            string = string.replace("${lastExecutedProject}", lastExecutedProjectAlias + " (" + lastExecutedProjectClassName + ")");
        }
        boolean bl = execute = string == null || Runner.showConfirmDialog(this.split(string) + "\n\n\u00bfDesea ejecutar la clase?", "Ejecutar " + name);
        if (execute) {
            try {
                Class<?> clazz = Class.forName(name);
                Method method = clazz.getMethod("main", String[].class);
                Object args = null;
                long millis = System.currentTimeMillis();
                logger.warn((Object)this.starting(clazz));
                method.invoke(null, args);
                logger.warn((Object)this.finished(clazz, millis));
                Runner.updateProjectBuilderDictionary(clazz);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex));
            }
        }
    }

    private String getString(String key) {
        try {
            String string = RB.getString(key);
            return StringUtils.trimToNull((String)string);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String split(String string) {
        return StrUtils.separateLines(string, 70, "\n", true);
    }
}

