/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.i18n;

import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BasicTranslator {
    private static final Logger logger = Logger.getLogger(BasicTranslator.class);
    private Translate.TranslateOption sourceLanguage;
    private Translate.TranslateOption targetLanguage;
    private Translate service;
    private int incomingCharCount;
    private int outgoingCharCount;
    private static final String BS = "\b";
    private static final String HT = "\t";
    private static final String LF = "\n";
    private static final String FF = "\f";
    private static final String CR = "\r";
    private static final String DQ = "\"";
    private static final String bs = "[b]";
    private static final String ht = "[t]";
    private static final String lf = "[n]";
    private static final String ff = "[f]";
    private static final String cr = "[r]";
    private static final String dq = "[q]";
    private static final String[] slashedChars = new String[]{"\b", "\t", "\n", "\f", "\r", "\""};
    private static final String[] replacements = new String[]{"[b]", "[t]", "[n]", "[f]", "[r]", "[q]"};

    public void build(Locale sourceLocale, Locale targetLocale) {
        this.build(sourceLocale == null ? null : sourceLocale.getLanguage(), targetLocale == null ? null : targetLocale.getLanguage());
    }

    public void build(String sourceLanguageCode, String targetLanguageCode) {
        if (this.service == null) {
            String slc = StringUtils.defaultIfBlank((String)sourceLanguageCode, (String)"es");
            String tlc = StringUtils.defaultIfBlank((String)targetLanguageCode, (String)"en");
            this.sourceLanguage = Translate.TranslateOption.sourceLanguage((String)slc);
            this.targetLanguage = Translate.TranslateOption.sourceLanguage((String)tlc);
            this.service = (Translate)TranslateOptions.newBuilder().setTargetLanguage(tlc).build().getService();
            logger.info((Object)("source-language = " + String.valueOf(this.sourceLanguage)));
            logger.info((Object)("target-language = " + String.valueOf(this.targetLanguage)));
            logger.info((Object)("service = " + String.valueOf(this.service)));
        }
    }

    public void close() {
        logger.info((Object)("incoming-char-count = " + this.incomingCharCount));
        logger.info((Object)("outgoing-char-count = " + this.outgoingCharCount));
    }

    public String translate(String string) {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        String strong = this.service.translate(this.replaceSlashedChars(string), new Translate.TranslateOption[]{this.sourceLanguage}).getTranslatedText();
        strong = StringEscapeUtils.unescapeHtml((String)strong);
        this.incomingCharCount += string.length();
        this.outgoingCharCount += strong.length();
        return this.restoreSlashedChars(strong);
    }

    public int getIncomingCharCount() {
        return this.incomingCharCount;
    }

    public int getOutgoingCharCount() {
        return this.outgoingCharCount;
    }

    private String replaceSlashedChars(String string) {
        return StringUtils.replaceEach((String)string, (String[])slashedChars, (String[])replacements).trim();
    }

    private String restoreSlashedChars(String string) {
        return StringUtils.replaceEach((String)string, (String[])replacements, (String[])slashedChars);
    }
}

