/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.util.io.FileBytesSize;
import adalid.util.io.FileLinesSize;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileWrapper {
    private static final Logger logger = Logger.getLogger(FileWrapper.class);
    private static final Charset[] STANDARD_CHARSETS = new Charset[]{StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.US_ASCII};
    private final File file;
    private final Path path;
    private String type;
    private Charset charset;
    private List<String> list;
    private int readingWarnings;
    private int readingErrors;

    public FileWrapper(File sourceFile) {
        this.file = sourceFile;
        this.path = Paths.get(sourceFile.getPath(), new String[0]);
    }

    public List<String> read() {
        String fileName = this.file.getName();
        String fileType = StringUtils.substringAfterLast((String)fileName, (String)".");
        fileType = StringUtils.isBlank((String)fileType) ? fileName : fileType.toLowerCase();
        this.type = "binary";
        this.charset = null;
        for (Charset cs : STANDARD_CHARSETS) {
            try {
                this.list = Files.readAllLines(this.path, cs);
                if (this.isEmpty()) {
                    ++this.readingWarnings;
                    logger.warn((Object)(this.file.getPath() + " is empty "));
                }
                this.type = "text/" + fileType;
                this.charset = cs;
                return this.list;
            }
            catch (IOException ex) {
                ++this.readingWarnings;
                logger.warn((Object)ex);
                logger.warn((Object)(this.file.getPath() + " could not be read using " + String.valueOf(cs)));
            }
        }
        ++this.readingErrors;
        logger.error((Object)(this.file.getPath() + " could not be read using a standard charset "));
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public long getBytes() {
        return this.file == null ? 0L : this.file.length();
    }

    public FileBytesSize getBytesSize() {
        long bytes = this.getBytes();
        return bytes <= FileBytesSize.TINY.limit ? FileBytesSize.TINY : (bytes <= FileBytesSize.SMALL.limit ? FileBytesSize.SMALL : (bytes <= FileBytesSize.MEDIUM.limit ? FileBytesSize.MEDIUM : (bytes <= FileBytesSize.LARGE.limit ? FileBytesSize.LARGE : FileBytesSize.HUGE)));
    }

    public Path getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public List<String> getLinesList() {
        return this.list;
    }

    public int getLines() {
        return this.list == null ? 0 : this.list.size();
    }

    public FileLinesSize getLinesSize() {
        long lines = this.getLines();
        return lines <= FileLinesSize.TINY.limit ? FileLinesSize.TINY : (lines <= FileLinesSize.SMALL.limit ? FileLinesSize.SMALL : (lines <= FileLinesSize.MEDIUM.limit ? FileLinesSize.MEDIUM : (lines <= FileLinesSize.LARGE.limit ? FileLinesSize.LARGE : FileLinesSize.HUGE)));
    }

    public int getReadingWarnings() {
        return this.readingWarnings;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public boolean isText() {
        return StringUtils.startsWithIgnoreCase((String)this.type, (String)"text");
    }

    public boolean isEmpty() {
        return this.list == null || this.list.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public Path getRelativePath(Path base) {
        if (this.path.startsWith(base)) {
            try {
                return base.relativize(this.path);
            }
            catch (IllegalArgumentException ex) {
                return this.path;
            }
        }
        return this.path;
    }
}

