/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import adalid.util.io.SmallFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NoticesReplacer
extends Utility {
    private static final Logger logger = Logger.getLogger(NoticesReplacer.class);
    private static final String B = "^";
    private static final String E = "$";
    private static final String X = ".*";
    private static final String D = "\\.";
    private static final String PACKAGE_REGEX = "^package [\\w\\.]*;$";
    private final File rootFolder = PropertiesHandler.getRootFolder();
    private final Path rootFolderPath;
    private final File noticesFile;
    private final SmallFile noticesSmallFile;
    private final List<String> noticesSmallFileLines;
    private final File resourcesFolder;
    private final Path resourcesFolderPath;
    private final File baseFolder;
    private final Path baseFolderPath;
    private final Map<Path, SmallFile> files;
    private final Map<String, Integer> fileTypes;
    private boolean detailAll;
    private List<String> detailPatterns;
    private int readingWarnings;
    private int readingErrors;
    private int javaFilesCopied;
    private int javaFilesSkipped;
    private int writingErrors;

    public static void main(String[] args) {
        NoticesReplacer.replace("adalid\\source\\adalid-zymogen");
    }

    public static boolean replace(String path) {
        return NoticesReplacer.replace(path, false);
    }

    public static boolean replace(String path, boolean detail) {
        logger.info((Object)("replace" + StrUtils.enclose(path)));
        NoticesReplacer replacer = new NoticesReplacer(path, detail);
        return replacer.replace();
    }

    public static boolean replace(String path, List<String> details) {
        logger.info((Object)("replace" + StrUtils.enclose(path)));
        NoticesReplacer replacer = new NoticesReplacer(path, details);
        return replacer.replace();
    }

    private NoticesReplacer(String path) {
        if (this.rootFolder == null) {
            throw new RuntimeException("root folder is missing or invalid");
        }
        this.rootFolderPath = Paths.get(this.rootFolder.getPath(), new String[0]);
        logger.info((Object)("root-folder=" + String.valueOf(this.rootFolderPath)));
        this.noticesFile = new File(this.rootFolder.getAbsolutePath(), "adalid\\source\\documents\\license-notices.txt");
        if (!this.noticesFile.isFile()) {
            throw new IllegalArgumentException(this.noticesFile.getPath() + " is not a file");
        }
        logger.info((Object)("notices-file=" + String.valueOf(this.noticesFile)));
        this.noticesSmallFile = new SmallFile(this.noticesFile.getPath());
        this.noticesSmallFileLines = this.noticesSmallFile.read();
        if (path == null) {
            throw new IllegalArgumentException("null folder path");
        }
        File file = new File(path);
        this.resourcesFolder = file.isAbsolute() ? file : new File(this.rootFolder.getAbsolutePath(), path);
        this.resourcesFolderPath = Paths.get(this.resourcesFolder.getPath(), new String[0]);
        logger.info((Object)("resources-folder=" + String.valueOf(this.resourcesFolderPath)));
        if (this.resourcesFolder.isDirectory()) {
            if (this.resourcesFolder.isHidden()) {
                throw new IllegalArgumentException(String.valueOf(this.resourcesFolderPath) + " is a hidden directory");
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(this.resourcesFolderPath) + " is not a directory");
        }
        this.baseFolder = this.resourcesFolder.getParentFile();
        this.baseFolderPath = Paths.get(this.baseFolder.getPath(), new String[0]);
        logger.info((Object)("base-folder=" + String.valueOf(this.baseFolderPath)));
        this.files = new TreeMap<Path, SmallFile>();
        this.fileTypes = new TreeMap<String, Integer>();
    }

    private NoticesReplacer(String path, boolean detail) {
        this(path);
        this.detailAll = detail;
    }

    private NoticesReplacer(String path, List<String> details) {
        this(path);
        this.detailAll = false;
        this.detailPatterns = details;
    }

    private boolean replace() {
        logger.info((Object)("replace" + StrUtils.enclose(this.resourcesFolderPath.toString())));
        this.init();
        this.readFiles();
        this.printSummary();
        NoticesReplacer.updateProjectBuilderDictionary(NoticesReplacer.class);
        return this.readingErrors == 0;
    }

    private void init() {
        this.readingWarnings = 0;
        this.readingErrors = 0;
        this.javaFilesCopied = 0;
        this.javaFilesSkipped = 0;
        this.writingErrors = 0;
    }

    private boolean readFiles() {
        Collection list = FileUtils.listFiles((File)this.resourcesFolder, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.dirFilter());
        for (File file : list) {
            SmallFile sf = new SmallFile(file.getPath());
            sf.read();
            Charset charset = sf.getCharset();
            String name = sf.getName();
            String extension = StringUtils.defaultIfBlank((String)sf.getExtension().toLowerCase(), (String)"?");
            if (charset == null) {
                ++this.readingErrors;
                logger.error((Object)(name + " could not be read using any of the specified character sets "));
                continue;
            }
            if (sf.isEmpty()) {
                ++this.readingWarnings;
                logger.warn((Object)(name + " is empty "));
                continue;
            }
            this.files.put(sf.getPath(), sf);
            this.updateFileTypes(String.valueOf(charset));
            this.updateFileTypes(String.valueOf(charset) + " / " + extension);
            this.rewrite(sf);
        }
        return true;
    }

    private boolean rewrite(SmallFile smallSource) {
        String[] thirdPartyJava;
        String source = smallSource.getName();
        String shorty = StringUtils.removeStartIgnoreCase((String)source, (String)this.resourcesFolderPath.toString());
        for (String regex : thirdPartyJava = new String[]{"package-info.java", "EnglishNoun.java", "HexUtils.java", "ImageInfo.java", "lib.core.opencsv"}) {
            if (!source.matches("^.*" + regex + ".*$")) continue;
            logger.warn((Object)("skipping " + shorty));
            ++this.javaFilesSkipped;
            return false;
        }
        List<String> sourceLines = smallSource.read();
        ArrayList<String> targetLines = new ArrayList<String>();
        boolean head = true;
        boolean skip = true;
        if (smallSource.isNotEmpty()) {
            for (String line : sourceLines) {
                if (StringUtils.isNotBlank((String)line) && line.matches(PACKAGE_REGEX)) {
                    skip = false;
                }
                if (skip) {
                    if (!head) continue;
                    head = false;
                    targetLines.addAll(this.noticesSmallFileLines);
                    continue;
                }
                targetLines.add(line);
            }
        }
        if (head) {
            logger.warn((Object)("check " + shorty));
        }
        if (skip) {
            ++this.readingErrors;
            logger.error((Object)(source + " package statement is missing "));
        } else if (this.rewrite(smallSource, targetLines)) {
            ++this.javaFilesCopied;
        }
        return true;
    }

    private boolean rewrite(SmallFile smallSource, List<String> lines) {
        String target = smallSource.getName();
        String shorty = StringUtils.removeStartIgnoreCase((String)target, (String)this.resourcesFolderPath.toString());
        logger.info((Object)("rewrite " + shorty));
        try {
            Files.write(smallSource.getPath(), lines, smallSource.getCharset(), new OpenOption[0]);
            return true;
        }
        catch (IOException ex) {
            ++this.writingErrors;
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            logger.fatal((Object)("\t" + shorty + " could not be rewritten "));
            return false;
        }
    }

    private void updateFileTypes(String type) {
        if (this.fileTypes.containsKey(type)) {
            int count = this.fileTypes.get(type);
            this.fileTypes.put(type, ++count);
        } else {
            this.fileTypes.put(type, 1);
        }
    }

    private void printSummary() {
        logger.info((Object)(this.files.size() + " files "));
        logger.info((Object)(this.fileTypes.size() + " file types "));
        for (String type : this.fileTypes.keySet()) {
            String tab = type.contains("/") ? "\t" : "";
            logger.info((Object)(tab + type + " = " + String.valueOf(this.fileTypes.get(type))));
            this.printDetail(type);
        }
        logger.info((Object)(this.readingWarnings + " reading warnings "));
        logger.info((Object)(this.readingErrors + " reading errors "));
        logger.info((Object)(this.javaFilesCopied + " files copied "));
        logger.info((Object)(this.javaFilesSkipped + " files skipped "));
        logger.info((Object)(this.writingErrors + " writing errors "));
    }

    private void printDetail(String type) {
        if (this.detailAll || this.matches(type)) {
            String baseFolderPathString = this.baseFolderPath.toString();
            String tab = type.contains("/") ? "\t" : "";
            for (SmallFile sf : this.files.values()) {
                Charset charset = sf.getCharset();
                String extension = StringUtils.defaultIfBlank((String)sf.getExtension(), (String)"?");
                if (charset == null || !type.equals(String.valueOf(charset) + " / " + extension)) continue;
                logger.info((Object)(tab + "\t" + StringUtils.removeStartIgnoreCase((String)sf.getName(), (String)baseFolderPathString)));
            }
        }
    }

    private boolean matches(String type) {
        if (this.detailPatterns == null || this.detailPatterns.isEmpty()) {
            return false;
        }
        for (String regex : this.detailPatterns) {
            if (!type.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private IOFileFilter fileFilter() {
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        IOFileFilter[] ayes = new IOFileFilter[]{new RegexFileFilter("^.*\\.java$")};
        IOFileFilter ayesFileFilter = FileFilterUtils.or((IOFileFilter[])ayes);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, ayesFileFilter});
        return filter;
    }

    private IOFileFilter dirFilter() {
        IOFileFilter makeCVSSVNAware = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.makeSVNAware(null));
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^.*\\.git$"), new RegexFileFilter("^build$"), new RegexFileFilter("^dist$"), new RegexFileFilter("^target$")};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{makeCVSSVNAware, noesFileFilter});
        return filter;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Path getRootFolderPath() {
        return this.rootFolderPath;
    }

    public File getResourcesFolder() {
        return this.resourcesFolder;
    }

    public Path getResourcesFolderPath() {
        return this.resourcesFolderPath;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public Path getBaseFolderPath() {
        return this.baseFolderPath;
    }

    public int getReadingWarnings() {
        return this.readingWarnings;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public Map<Path, SmallFile> getFiles() {
        return this.files;
    }

    public Map<String, Integer> getFileTypes() {
        return this.fileTypes;
    }
}

