/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.util.Utility;
import adalid.util.io.SysCmd;
import adalid.util.io.SysCmdCommand;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SysCmdRunner
extends Utility {
    private static final Logger logger = Logger.getLogger(SysCmdRunner.class);
    private static final String MORE_INTERACTIVE = SysCmd.class.getSimpleName() + "=";
    private static final String LESS_INTERACTIVE = MORE_INTERACTIVE + SysCmd.class.getCanonicalName();
    private static final String RELEASE = "/resources/scripts/windows/release/";

    public static void main(String[] args) {
        SysCmdRunner.executeSystemCommand();
    }

    public static Process executeSystemCommand() {
        return SysCmdRunner.executeSystemCommand(null);
    }

    public static Process executeSystemCommand(String folder) {
        return SysCmdRunner.executeSystemCommand(folder, null);
    }

    public static Process executeSystemCommand(String folder, String command) {
        List<String> env = null;
        return SysCmdRunner.executeSystemCommand(folder, command, env);
    }

    public static Process executeSystemCommand(String folder, String command, String ... vars) {
        List<String> env = vars == null || vars.length == 0 ? null : Arrays.asList(vars);
        return SysCmdRunner.executeSystemCommand(folder, command, env);
    }

    public static Process executeSystemCommand(String folder, String command, List<String> env) {
        File dir = SysCmdRunner.directoryOf(folder);
        return SysCmdRunner.executeSystemCommand(dir, SysCmdRunner.commandOf(dir, command), env);
    }

    public static void log(Process process) {
        if (process != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.info((Object)line);
                }
            }
            catch (IOException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
    }

    public static void send(Process process, String string) {
        if (process != null) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));){
                writer.write(string);
            }
            catch (IOException ex) {
                logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            }
        }
    }

    private static File directoryOf(String folder) {
        File dir;
        File rootFolder = PropertiesHandler.getRootFolder();
        logger.info((Object)("root-folder=" + String.valueOf(rootFolder)));
        if (StringUtils.isBlank((String)folder)) {
            folder = rootFolder.getAbsolutePath();
        }
        if (!(dir = new File(folder)).isAbsolute()) {
            dir = new File(rootFolder, folder);
        }
        if (dir.isDirectory()) {
            logger.info((Object)("working-dir=" + String.valueOf(dir)));
        } else {
            logger.error((Object)(String.valueOf(dir) + " does not exist or it is not a directory; using the root folder instead"));
            dir = rootFolder;
            logger.warn((Object)("working-dir=" + String.valueOf(rootFolder)));
        }
        return dir;
    }

    private static String commandOf(File dir, String command) {
        if (StringUtils.isBlank((String)command)) {
            ArrayList<FileNameExtensionFilter> filters = new ArrayList<FileNameExtensionFilter>();
            if (WINDOWS) {
                filters.add(new FileNameExtensionFilter("*.bat", "bat"));
            }
            filters.add(new FileNameExtensionFilter("*.sh", "sh"));
            command = SysCmdRunner.chooseFile(dir.getAbsolutePath(), filters);
            if (StringUtils.isBlank((String)command)) {
                logger.warn((Object)"no file selected; execution cancelled");
                return null;
            }
        }
        return command;
    }

    private static Process executeSystemCommand(File dir, String command, List<String> env) {
        if (dir == null || command == null) {
            return null;
        }
        SysCmdCommand scc = new SysCmdCommand(command, env, dir);
        if (scc.exception != null) {
            logger.warn((Object)"execution aborted due to previous errors");
            return null;
        }
        if (SysCmdRunner.isNotReleaseScript(command)) {
            SysCmdRunner.addLessInteractiveEnvironmentVariable(scc.env);
        }
        try {
            SysCmdRunner.log(scc);
            Process process = SysCmdRunner.start(scc);
            logger.warn((Object)"a new window was opened to execute the command or batch script");
            SysCmdRunner.deleteOldFiles(scc);
            SysCmdRunner.updateProjectBuilderDictionary(SysCmdRunner.class);
            return process;
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return null;
        }
    }

    private static Process start(SysCmdCommand scc) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(scc.command());
        if (scc.env != null && !scc.env.isEmpty()) {
            Map<String, String> environment = processBuilder.environment();
            for (String var : scc.env) {
                String[] tokens = StringUtils.split((String)var, (char)'=');
                if (tokens == null || tokens.length != 2) continue;
                environment.put(tokens[0], tokens[1]);
            }
        }
        processBuilder.directory(scc.dir);
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    private static void log(SysCmdCommand scc) {
        logger.info((Object)("runtime-cmd=" + scc.command));
        logger.info((Object)("runtime-env=" + Arrays.toString(scc.env())));
        logger.info((Object)("runtime-dir=" + String.valueOf(scc.dir)));
        if (scc.run != null) {
            logger.info((Object)("runtime-bat=" + String.valueOf(scc.run)));
            for (String command : scc.commands) {
                if (command.startsWith("@echo") || command.startsWith("echo")) continue;
                logger.info((Object)command);
            }
        }
    }

    private static int deleteOldFiles(SysCmdCommand scc) {
        if (SysCmd.singleRuntimeFile) {
            return 0;
        }
        File[] batList = SysCmdRunner.batFileList(scc);
        if (batList == null || batList.length < 100) {
            return 0;
        }
        Timestamp someTimeAgo = TimeUtils.addTimestamp(TimeUtils.actualTimestamp(), -24, 'h');
        FileTime someFileTimeAgo = FileTime.fromMillis(someTimeAgo.getTime());
        logger.info((Object)("runtime-dir contains " + batList.length + " script files"));
        logger.info((Object)("script files in runtime-dir last modified before " + String.valueOf(someTimeAgo) + " will be deleted"));
        int deleted = 0;
        String runName = scc.run.getName();
        for (File file : batList) {
            String fileName = file.getName();
            if (StringUtils.equalsIgnoreCase((String)fileName, (String)runName)) continue;
            try {
                Path filePath = Paths.get(file.getAbsolutePath(), new String[0]);
                BasicFileAttributes fileAttributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                FileTime lastModified = fileAttributes.lastModifiedTime();
                if (someFileTimeAgo.compareTo(lastModified) <= 0) continue;
                FileUtils.deleteQuietly((File)file);
                ++deleted;
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
        }
        logger.info(deleted == 1 ? "Only one file was deleted" : deleted + " files were deleted");
        return deleted;
    }

    private static File[] batFileList(SysCmdCommand scc) {
        File dir = scc == null || scc.run == null ? null : scc.run.getParentFile();
        FileFilter filter = scc == null ? null : scc.filter;
        return dir == null || filter == null ? null : dir.listFiles(filter);
    }

    private static boolean isNotReleaseScript(String command) {
        return !SysCmdRunner.isReleaseScript(command);
    }

    private static boolean isReleaseScript(String command) {
        return StringUtils.containsIgnoreCase((String)command.replace('\\', '/'), (String)RELEASE);
    }

    private static boolean addLessInteractiveEnvironmentVariable(List<String> env) {
        if (env == null) {
            return false;
        }
        for (String var : env) {
            if (!StringUtils.startsWithIgnoreCase((String)var, (String)MORE_INTERACTIVE)) continue;
            return false;
        }
        env.add(LESS_INTERACTIVE);
        return true;
    }
}

