/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.map;

import adalid.core.interfaces.Entity;
import java.util.Objects;

public class EntityVertex
implements Comparable<EntityVertex> {
    private final String application;
    private final String entityClass;
    private final boolean defaultLocation;
    private final boolean displayAvailable;

    public EntityVertex(String application, Entity entity) {
        this.application = application;
        this.entityClass = entity.getClass().getSimpleName();
        this.defaultLocation = entity.isApplicationDefaultLocation();
        this.displayAvailable = entity.isDisplayAvailable();
    }

    public String getApplication() {
        return this.application;
    }

    public String getEntityClass() {
        return this.entityClass;
    }

    public boolean isDefaultLocation() {
        return this.defaultLocation;
    }

    public boolean isDisplayAvailable() {
        return this.displayAvailable;
    }

    @Override
    public int compareTo(EntityVertex that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object that) {
        return that instanceof EntityVertex && this.toString().equals(that.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.application);
        hash = 97 * hash + Objects.hashCode(this.entityClass);
        return hash;
    }

    public String toString() {
        return this.application + "/" + this.entityClass;
    }
}

