/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ModuleAssembler {
    private static final Logger logger = Logger.getLogger(ModuleAssembler.class);
    public boolean printTablesPerModule = true;
    public boolean printModulesPerTable = true;
    public boolean printManyToOneRelations = true;
    public boolean printOneToManyRelations = true;
    public boolean printImmutableModules = true;
    public boolean printTables = true;
    private final Map<String, Set<String>> tablesPerModule = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> modulesPerTable = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> childlessTablesPerModule = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> manyToOne = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> oneToMany = new TreeMap<String, Set<String>>();
    private final Set<String> immutableModules = new TreeSet<String>();
    private final Set<String> tables = new TreeSet<String>();
    private final Set<String> tablesWithoutModule = new TreeSet<String>();
    private final Set<String> tablesInJustOneModule = new TreeSet<String>();
    private final Set<String> tablesInMoreThanOneModule = new TreeSet<String>();
    public String orphanTablesModuleName;
    List<CrossModuleRelation> crossModuleRelations = new ArrayList<CrossModuleRelation>();
    private final List<CrossModulePath> crossModulePaths = new ArrayList<CrossModulePath>();

    public static void main(String[] args) {
        ModuleAssembler assembler = new ModuleAssembler();
        assembler.addModuleTables("CustomerModule", "Customer", "CustomerAddress");
        assembler.addChildlessModuleTables("CustomerModule", "CustomerOrder");
        assembler.addModuleTables("OrdersModule", "CustomerOrder", "CustomerOrderLine");
        assembler.addTableRelations("Customer", "State", "Gender", "Product");
        assembler.addTableRelations("CustomerOrder", "Customer");
        assembler.addTableRelations("CustomerAddress", "Customer", "State");
        assembler.addTableRelations("CustomerPhone", "Customer");
        assembler.addTableRelations("GenderDetail", "Gender");
        assembler.addTableRelations("CustomerMobilePhone", "CustomerPhone");
        assembler.addTableRelations("CustomerOrderLine", "CustomerOrder", "Product");
        assembler.addTableRelations("CustomerOrderLineDetail", "CustomerOrderLine");
        assembler.addTables("Profession");
        assembler.buildModules();
    }

    public void addModuleTables(String moduleName, String ... tableNames) {
        this.addModuleTables(moduleName, Arrays.asList(tableNames));
    }

    public void addModuleTables(String moduleName, Collection<String> tableNames) {
        this.tables.addAll(tableNames);
        Set<String> tpm = this.tablesPerModule.get(moduleName);
        if (tpm == null) {
            tpm = new TreeSet<String>();
        }
        tpm.addAll(tableNames);
        this.tablesPerModule.put(moduleName, tpm);
        for (String tableName : tableNames) {
            Set<String> mpt = this.modulesPerTable.get(tableName);
            if (mpt == null) {
                mpt = new TreeSet<String>();
            }
            mpt.add(moduleName);
            this.modulesPerTable.put(tableName, mpt);
        }
    }

    public void addChildlessModuleTables(String moduleName, String ... tableNames) {
        this.addChildlessModuleTables(moduleName, Arrays.asList(tableNames));
    }

    public void addChildlessModuleTables(String moduleName, Collection<String> tableNames) {
        this.addModuleTables(moduleName, tableNames);
        Set<String> tpm = this.childlessTablesPerModule.get(moduleName);
        if (tpm == null) {
            tpm = new TreeSet<String>();
        }
        tpm.addAll(tableNames);
        this.childlessTablesPerModule.put(moduleName, tpm);
    }

    public void addTableRelations(String tableName, String ... referencedTableNames) {
        this.addTableRelations(tableName, Arrays.asList(referencedTableNames));
    }

    public void addTableRelations(String tableName, Collection<String> referencedTableNames) {
        this.tables.add(tableName);
        this.tables.addAll(referencedTableNames);
        Set<String> mto = this.manyToOne.get(tableName);
        if (mto == null) {
            mto = new TreeSet<String>();
        }
        mto.addAll(referencedTableNames);
        this.manyToOne.put(tableName, mto);
        for (String referencedTableName : referencedTableNames) {
            Set<String> otm = this.oneToMany.get(referencedTableName);
            if (otm == null) {
                otm = new TreeSet<String>();
            }
            otm.add(tableName);
            this.oneToMany.put(referencedTableName, otm);
        }
    }

    public void addImmutableModules(String ... moduleNames) {
        this.addImmutableModules(Arrays.asList(moduleNames));
    }

    public void addImmutableModules(Collection<String> moduleNames) {
        this.immutableModules.addAll(moduleNames);
    }

    public void addTables(String ... tableNames) {
        this.addTables(Arrays.asList(tableNames));
    }

    public void addTables(Collection<String> tableNames) {
        this.tables.addAll(tableNames);
    }

    public void buildModules() {
        this.setupModulesPerTable();
        this.printInputCollections();
        this.buildOtherCollections("");
        int i = 0;
        do {
            boolean added = false;
            added |= this.phase1(++i);
        } while (added |= this.phase2(i));
        String moduleName = StringUtils.defaultIfBlank((String)this.orphanTablesModuleName, (String)"zymurgy");
        if (this.tablesWithoutModule.isEmpty()) {
            logger.info((Object)("The module " + moduleName + " was not defined because there are no orphan tables"));
        } else {
            this.addModuleTables(moduleName, this.tablesWithoutModule);
            this.phaseEpilogue(true);
            logger.info((Object)("The module " + moduleName + " contains the orphan tables"));
        }
        this.logCircularReferences();
    }

    private void setupModulesPerTable() {
        for (String tableName : this.tables) {
            Set<String> mpt = this.modulesPerTable.get(tableName);
            if (mpt != null) continue;
            this.modulesPerTable.put(tableName, new TreeSet());
        }
    }

    private void printInputCollections() {
        Set<String> childless;
        ArrayList<Object> ikq = new ArrayList<Object>();
        ArrayList<String> vdu = new ArrayList<String>();
        if (this.printTablesPerModule) {
            logger.info((Object)"Tables per Module");
            for (String moduleName : this.tablesPerModule.keySet()) {
                Set<String> tpm = this.tablesPerModule.get(moduleName);
                if (tpm == null || tpm.isEmpty()) continue;
                ikq.clear();
                vdu.clear();
                childless = this.childlessTablesPerModule.get(moduleName);
                for (String tableName : tpm) {
                    if (childless == null || !childless.contains(tableName)) {
                        ikq.add(tableName);
                        continue;
                    }
                    vdu.add(tableName);
                }
                if (!vdu.isEmpty()) {
                    ikq.add("(" + StringUtils.join(vdu, (String)", ") + ")");
                }
                logger.info((Object)("\t" + moduleName));
                logger.info((Object)("\t\t[" + StringUtils.join(ikq, (String)", ") + "]"));
            }
        }
        if (this.printModulesPerTable) {
            logger.info((Object)"Modules per Table");
            for (String tableName : this.modulesPerTable.keySet()) {
                Set<String> mpt = this.modulesPerTable.get(tableName);
                if (mpt == null || mpt.isEmpty()) continue;
                ikq.clear();
                vdu.clear();
                for (String moduleName : mpt) {
                    childless = this.childlessTablesPerModule.get(moduleName);
                    if (childless == null || !childless.contains(tableName)) {
                        ikq.add(moduleName);
                        continue;
                    }
                    vdu.add(moduleName);
                }
                if (!vdu.isEmpty()) {
                    ikq.add("(" + StringUtils.join(vdu, (String)", ") + ")");
                }
                logger.info((Object)("\t" + tableName));
                logger.info((Object)("\t\t[" + StringUtils.join(ikq, (String)", ") + "]"));
            }
        }
        if (this.printManyToOneRelations) {
            logger.info((Object)"Many-to-One relations");
            for (String tableName : this.manyToOne.keySet()) {
                logger.info((Object)("\t" + tableName));
                logger.info((Object)("\t\t" + String.valueOf(this.manyToOne.get(tableName))));
            }
        }
        if (this.printOneToManyRelations) {
            logger.info((Object)"One-to-Many relations");
            for (String referencedTableName : this.oneToMany.keySet()) {
                logger.info((Object)("\t" + referencedTableName));
                logger.info((Object)("\t\t" + String.valueOf(this.oneToMany.get(referencedTableName))));
            }
        }
        if (this.printImmutableModules) {
            TreeSet<String> mutableModules = new TreeSet<String>(this.tablesPerModule.keySet());
            mutableModules.removeAll(this.immutableModules);
            logger.info((Object)"Mutable Modules");
            logger.info((Object)("\t" + String.valueOf(mutableModules)));
            logger.info((Object)"Immutable Modules");
            logger.info((Object)("\t" + String.valueOf(this.immutableModules)));
        }
        if (this.printTables) {
            logger.info((Object)"Tables");
            logger.info((Object)("\t" + String.valueOf(this.tables)));
        }
    }

    private void buildOtherCollections(String tab) {
        this.tablesWithoutModule.clear();
        this.tablesInJustOneModule.clear();
        this.tablesInMoreThanOneModule.clear();
        for (String tableName : this.modulesPerTable.keySet()) {
            Set<String> mpt = this.modulesPerTable.get(tableName);
            if (mpt.isEmpty()) {
                this.tablesWithoutModule.add(tableName);
                continue;
            }
            if (mpt.size() == 1) {
                this.tablesInJustOneModule.add(tableName);
                continue;
            }
            this.tablesInMoreThanOneModule.add(tableName);
        }
        logger.info((Object)(tab + "Tables in more than one module"));
        logger.info((Object)(tab + "\t" + String.valueOf(this.tablesInMoreThanOneModule)));
        logger.info((Object)(tab + "Tables in just one module"));
        logger.info((Object)(tab + "\t" + String.valueOf(this.tablesInJustOneModule)));
        logger.info((Object)(tab + "Tables without module"));
        logger.info((Object)(tab + "\t" + String.valueOf(this.tablesWithoutModule)));
    }

    private boolean phase1(int i) {
        boolean added;
        logger.info((Object)("Iteration " + i + ", Phase 1"));
        boolean phase = false;
        int j = 1;
        int k = 0;
        do {
            String[] tablesWithoutModuleArray;
            ++k;
            added = false;
            for (String tableName : tablesWithoutModuleArray = (String[])this.tablesWithoutModule.toArray(String[]::new)) {
                Set<String> mto = this.manyToOne.get(tableName);
                if (mto == null) continue;
                for (String referencedTableName : mto) {
                    Set<String> mpt = this.modulesPerTable.get(referencedTableName);
                    if (mpt == null) continue;
                    for (String moduleName : mpt) {
                        if (this.immutableModules.contains(moduleName) || this.childlessTablesPerModule.containsKey(tableName)) continue;
                        this.add(tableName, moduleName);
                        logger.info((Object)(i + "." + j + "." + k + "\t" + tableName + " added to " + moduleName + " because it references " + referencedTableName));
                        added = true;
                        phase = true;
                    }
                }
            }
        } while (added);
        this.phaseEpilogue(phase);
        return phase;
    }

    private void add(String tableName, String moduleName) {
        Set<String> tpm = this.tablesPerModule.get(moduleName);
        tpm.add(tableName);
        Set<String> mpt = this.modulesPerTable.get(tableName);
        mpt.add(moduleName);
        this.tablesWithoutModule.remove(tableName);
    }

    private boolean phase2(int i) {
        boolean added;
        logger.info((Object)("Iteration " + i + ", Phase 2"));
        boolean phase = false;
        int j = 2;
        int k = 0;
        do {
            String[] tablesWithoutModuleArray;
            ++k;
            added = false;
            for (String tableName : tablesWithoutModuleArray = (String[])this.tablesWithoutModule.toArray(String[]::new)) {
                String moduleName;
                ArrayList<String> rml = new ArrayList<String>(this.referencingModules(tableName));
                if (rml.size() != 1 || this.immutableModules.contains(moduleName = (String)rml.get(0))) continue;
                this.add(tableName, moduleName);
                logger.info((Object)(i + "." + j + "." + k + "\t" + tableName + " added to " + moduleName + " because it is referenced only from tables in that module"));
                added = true;
                phase = true;
            }
        } while (added);
        this.phaseEpilogue(phase);
        return phase;
    }

    private Set<String> referencingModules(String tableName) {
        TreeSet<String> set = new TreeSet<String>();
        Set<String> otm = this.oneToMany.get(tableName);
        if (otm != null) {
            for (String referencingTable : otm) {
                set.addAll((Collection<String>)this.modulesPerTable.get(referencingTable));
            }
        }
        return set;
    }

    private void phaseEpilogue(boolean phase) {
        if (phase) {
            logger.info((Object)"\tModules");
            for (String key : this.tablesPerModule.keySet()) {
                logger.info((Object)("\t\t" + key));
                logger.info((Object)("\t\t\t" + String.valueOf(this.tablesPerModule.get(key))));
            }
            this.buildOtherCollections("\t");
        } else {
            logger.info((Object)"\tNo tables were added to any module in this iteration");
        }
    }

    private void logCircularReferences() {
        this.addCrossModuleRelations();
        this.addCrossModulePaths();
        this.logCrossModulePaths();
    }

    private List<CrossModuleRelation> addCrossModuleRelations() {
        for (String moduleName : this.tablesPerModule.keySet()) {
            Set<String> tpm = this.tablesPerModule.get(moduleName);
            for (String tableName : tpm) {
                Set<String> mto = this.manyToOne.get(tableName);
                if (mto == null || mto.isEmpty()) continue;
                TableAtModule source = new TableAtModule(this, tableName, moduleName);
                for (String referencedTableName : mto) {
                    Set<String> mpt;
                    if (tpm.contains(referencedTableName) || (mpt = this.modulesPerTable.get(referencedTableName)) == null || mpt.isEmpty()) continue;
                    for (String referencedModuleName : mpt) {
                        TableAtModule target = new TableAtModule(this, referencedTableName, referencedModuleName);
                        this.crossModuleRelations.add(new CrossModuleRelation(this, source, target));
                    }
                }
            }
        }
        return this.crossModuleRelations;
    }

    private void addCrossModulePaths() {
        for (CrossModuleRelation source : this.crossModuleRelations) {
            for (CrossModuleRelation target : this.crossModuleRelations) {
                if (!source.target.equals(target.source)) continue;
                CrossModulePath cmp = new CrossModulePath(this, source, target);
                this.crossModulePaths.add(cmp);
                this.addCrossModulePaths(cmp);
            }
        }
    }

    private void addCrossModulePaths(CrossModulePath cmp1) {
        if (cmp1.circular || cmp1.cyclical) {
            return;
        }
        TableAtModule lastTableAtModule = cmp1.nodes.get(cmp1.nodes.size() - 1);
        for (CrossModuleRelation target : this.crossModuleRelations) {
            if (!lastTableAtModule.equals(target.source)) continue;
            CrossModulePath cmp2 = new CrossModulePath(this, cmp1, target);
            this.crossModulePaths.add(cmp2);
            this.addCrossModulePaths(cmp2);
        }
    }

    private void logCrossModulePaths() {
        int i = 0;
        for (CrossModulePath cmp : this.crossModulePaths) {
            if (!cmp.circular && !cmp.cyclical) continue;
            logger.warn((Object)("CMP#" + ++i + "\t" + String.valueOf(cmp)));
        }
        if (i == 0) {
            logger.info((Object)"No cyclic or circular references between modules were found");
        }
    }

    private class TableAtModule {
        private final String table;
        private final String module;

        private TableAtModule(ModuleAssembler moduleAssembler, String table, String module) {
            this.table = table;
            this.module = module;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof TableAtModule)) return false;
            TableAtModule that = (TableAtModule)obj;
            if (!this.table.equals(that.table)) return false;
            if (!this.module.equals(that.module)) return false;
            return true;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.table);
            hash = 53 * hash + Objects.hashCode(this.module);
            return hash;
        }

        public String toString() {
            return this.table + " @ " + this.module;
        }
    }

    private class CrossModuleRelation {
        private final TableAtModule source;
        private final TableAtModule target;

        private CrossModuleRelation(ModuleAssembler moduleAssembler, TableAtModule source, TableAtModule target) {
            this.source = source;
            this.target = target;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CrossModuleRelation)) return false;
            CrossModuleRelation that = (CrossModuleRelation)obj;
            if (!this.source.equals(that.source)) return false;
            if (!this.target.equals(that.target)) return false;
            return true;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.source);
            hash = 97 * hash + Objects.hashCode(this.target);
            return hash;
        }

        public String toString() {
            return String.valueOf(this.source) + " --> " + String.valueOf(this.target);
        }
    }

    private class CrossModulePath {
        private final List<TableAtModule> nodes = new ArrayList<TableAtModule>();
        private boolean circular;
        private boolean cyclical;

        private CrossModulePath(ModuleAssembler moduleAssembler, CrossModuleRelation source, CrossModuleRelation target) {
            this.nodes.add(source.source);
            this.nodes.add(source.target);
            this.init(target);
        }

        private CrossModulePath(ModuleAssembler moduleAssembler, CrossModulePath path, CrossModuleRelation target) {
            this.nodes.addAll(path.nodes);
            this.init(target);
        }

        private void init(CrossModuleRelation target) {
            this.circular = this.nodes.get((int)0).module.equals(target.target.module);
            this.cyclical = this.nodes.contains(target.target);
            this.nodes.add(target.target);
        }

        public String toString() {
            return (this.circular ? "CIRCULAR" : "") + " " + (this.cyclical ? "CYCLICAL" : "") + " " + this.nodes.size() + "\n\t" + String.valueOf(this.nodes);
        }
    }
}

