/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.map;

import adalid.core.Project;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Property;
import adalid.core.jee.JavaModule;
import adalid.util.Utility;
import adalid.util.map.ModuleAssembler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ModuleBuilder
extends Utility {
    private static final Logger logger = Logger.getLogger(ModuleBuilder.class);
    public final ModuleAssembler assembler = new ModuleAssembler();
    private final Class<? extends Project> masterClass;
    private final Set<String> excludedModules = new TreeSet<String>();
    private boolean excludeConfigurationEntities;

    public ModuleBuilder(Class<? extends Project> masterClass) {
        this.masterClass = masterClass;
    }

    private boolean isExcludedModule(String moduleName) {
        for (String excludedModule : this.excludedModules) {
            if (!moduleName.endsWith(excludedModule)) continue;
            return true;
        }
        return false;
    }

    public boolean excludeModule(String moduleName) {
        return StringUtils.isNotBlank((String)moduleName) && this.excludedModules.add(moduleName);
    }

    public boolean isExcludeConfigurationEntities() {
        return this.excludeConfigurationEntities;
    }

    public void setExcludeConfigurationEntities(boolean excludeConfigurationEntities) {
        this.excludeConfigurationEntities = excludeConfigurationEntities;
    }

    public void build() throws Exception {
        Project project = ModuleBuilder.newInstance(this.masterClass);
        if (project != null) {
            project.build();
            Set<String> entities = this.getEntitySet(project);
            this.assembler.addTables(entities);
            Map<String, Project> moduleMap = project.getModulesMap();
            for (String moduleName : moduleMap.keySet()) {
                Set<String> set;
                if (this.isExcludedModule(moduleName)) continue;
                Project module = moduleMap.get(moduleName);
                assert (module != null);
                if (module instanceof JavaModule || (set = this.getEntitySet(module, this.excludeConfigurationEntities)).isEmpty()) continue;
                if (module.isImmutableModule()) {
                    this.assembler.addImmutableModules(moduleName);
                }
                this.assembler.addModuleTables(moduleName, set);
            }
            int e1 = 0;
            int e2 = 0;
            int er = 0;
            Map<String, Entity> entityMap = project.getEntitiesMap();
            for (String entityName : entities) {
                ++e1;
                Entity entity = entityMap.get(entityName);
                Set<String> references = this.getEntityReferences(entity);
                if (references.isEmpty()) continue;
                ++e2;
                for (String reference : references) {
                    ++er;
                    this.assembler.addTableRelations(entityName, reference);
                }
            }
            logger.info((Object)(e1 + " entities"));
            logger.info((Object)(e2 + " entities with references"));
            logger.info((Object)(er + " references"));
            this.beforeBuildModules();
            this.assembler.buildModules();
        }
    }

    public Set<String> getEntitySet(Project project) {
        return this.getEntitySet(project, false);
    }

    public Set<String> getEntitySet(Project project, boolean excludeConfigurationEntities) {
        TreeSet<String> entities = new TreeSet<String>();
        Map<String, Entity> map = project.getEntitiesMap();
        for (String entityName : map.keySet()) {
            Entity entity = map.get(entityName);
            if (excludeConfigurationEntities && project.isMutableModule() && entity.getResourceType().equals((Object)ResourceType.CONFIGURATION)) continue;
            entities.add(entityName);
        }
        return entities;
    }

    public Set<String> getEntityReferences(Entity entity) {
        String entityName = entity.getRoot().getName();
        TreeSet<String> references = new TreeSet<String>();
        List<Property> properties = entity.getRoot().getPropertiesList();
        for (Property property : properties) {
            EntityReference reference;
            String referenceName;
            if (!(property instanceof EntityReference) || (referenceName = (reference = (EntityReference)property).getRoot().getName()).equals(entityName)) continue;
            references.add(referenceName);
        }
        return references;
    }

    public void beforeBuildModules() {
    }
}

