/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.map;

import adalid.commons.util.ColUtils;
import adalid.core.Project;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Property;
import adalid.core.jee.JavaWebProject;
import adalid.core.predicates.IsProjectModule;
import adalid.util.Utility;
import adalid.util.map.EntityVertex;
import adalid.util.map.ReferenceArc;
import adalid.util.map.ReferencePath;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RoadMapper
extends Utility {
    private static final Logger logger = Logger.getLogger(RoadMapper.class);
    private final Set<String> applications = new TreeSet<String>();
    private final Map<String, Set<String>> appSources = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> appTargets = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> entityApps = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> entityRefs = new TreeMap<String, Set<String>>();
    private final Map<String, Set<EntityVertex>> vertices = new TreeMap<String, Set<EntityVertex>>();
    private final Map<EntityVertex, Set<ReferenceArc>> vertexArcs = new TreeMap<EntityVertex, Set<ReferenceArc>>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void map(Class<?> ... masterClasses) throws Exception {
        ArrayList<Project> masters = new ArrayList<Project>();
        for (Class<?> masterClass : masterClasses) {
            Object instance = masterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof Project)) throw new IllegalArgumentException(String.valueOf(instance) + " is not an instance of Project");
            Project project = (Project)instance;
            if (project.getMaster() != null) throw new IllegalArgumentException(String.valueOf(instance) + " is not a master project");
            JavaWebProject jwp = RoadMapper.jwp(project);
            if (jwp == null) {
                throw new IllegalArgumentException(String.valueOf(instance) + " is not an instance of JavaWebProject");
            }
            masters.add(project);
        }
        RoadMapper mapper = new RoadMapper();
        mapper.mapMasters(masters);
        RoadMapper.updateProjectBuilderDictionary(RoadMapper.class);
    }

    private static JavaWebProject jwp(Project project) {
        return project instanceof JavaWebProject ? (JavaWebProject)((Object)project) : null;
    }

    private void mapMasters(List<Project> masters) {
        for (Project master : masters) {
            this.mapMaster(master);
        }
        TreeSet<String> crossing = new TreeSet<String>();
        for (String string : this.applications) {
            Set<String> sources = this.appSources.get(string);
            Set<String> targets = this.appTargets.get(string);
            crossing.clear();
            crossing.addAll(sources);
            crossing.retainAll(targets);
            logger.info((Object)("map " + string + ", incoming=" + sources.size() + ", outgoing=" + targets.size() + ", crossing=" + crossing.size()));
            logger.info((Object)("\tincoming=" + String.valueOf(sources)));
            logger.info((Object)("\toutgoing=" + String.valueOf(targets)));
            if (crossing.isEmpty()) continue;
            logger.warn((Object)("\tcrossing=" + String.valueOf(crossing)));
        }
        ArrayList<CallSite> pdq = new ArrayList<CallSite>();
        for (String application : this.vertices.keySet()) {
            Set<EntityVertex> set = this.vertices.get(application);
            logger.info((Object)("map " + application + ", vertices=" + set.size()));
            pdq.clear();
            int exclusive = 0;
            for (EntityVertex vertex : set) {
                int easize;
                String entityClass = vertex.getEntityClass();
                Set<String> eas = this.entityApps.get(entityClass);
                int n = easize = eas == null ? 0 : eas.size();
                if (easize == 1) {
                    ++exclusive;
                }
                pdq.add((CallSite)((Object)(String.format("%04d", easize) + "\u00b7" + vertex.getEntityClass() + (String)(easize == 1 ? "" : " (" + easize + ")"))));
            }
            for (String string : ColUtils.sort(pdq)) {
                logger.info((Object)("\t" + StringUtils.substringAfter((String)string, (String)"\u00b7")));
            }
            logger.info((Object)("map " + application + ", vertices=" + set.size() + ", exclusive=" + exclusive));
        }
        pdq.clear();
        for (String entityClass : this.entityApps.keySet()) {
            Set<String> eas = this.entityApps.get(entityClass);
            int easize = eas == null ? 0 : eas.size();
            if (easize <= 1) continue;
            pdq.add((CallSite)((Object)(String.format("%04d", easize) + "\u00b7" + entityClass + ", applications=" + easize + " " + String.valueOf(eas))));
        }
        if (!pdq.isEmpty()) {
            logger.warn((Object)("the following " + pdq.size() + " entities that are included in several applications"));
            for (Object string : ColUtils.sort(pdq)) {
                logger.info((Object)("\t" + StringUtils.substringAfter((String)string, (String)"\u00b7")));
            }
        }
        pdq.clear();
        for (String entityClass : this.entityRefs.keySet()) {
            Set<String> exr = this.entityRefs.get(entityClass);
            int exrsize = exr == null ? 0 : exr.size();
            if (exrsize <= 0) continue;
            pdq.add((CallSite)((Object)(String.format("%04d", exrsize) + "\u00b7" + entityClass + ", applications=" + exrsize + " " + String.valueOf(exr))));
        }
        if (!pdq.isEmpty()) {
            logger.warn((Object)("the following " + pdq.size() + " entities that are referenced from another application"));
            for (Object string : ColUtils.sort(pdq)) {
                logger.info((Object)("\t" + StringUtils.substringAfter((String)string, (String)"\u00b7")));
            }
        }
        ArrayList<ReferencePath> arrayList = new ArrayList<ReferencePath>();
        for (String application : this.vertices.keySet()) {
            Set<EntityVertex> set = this.vertices.get(application);
            logger.info((Object)("processing " + set.size() + " vertices of " + application));
            for (EntityVertex vertex : set) {
                arrayList.addAll(this.expand(vertex, null));
            }
        }
        int cr = 0;
        for (ReferencePath rp : arrayList) {
            if (!rp.isCircular()) continue;
            ++cr;
            logger.info((Object)("CR " + String.valueOf(rp.getVertices())));
        }
        logger.info((Object)("reference-path-list=" + arrayList.size()));
        logger.info((Object)("circular-references=" + cr));
    }

    private List<ReferencePath> expand(EntityVertex vertex, ReferencePath incomingReferencePath) {
        ArrayList<ReferencePath> rpl = new ArrayList<ReferencePath>();
        Set<ReferenceArc> set = this.vertexArcs.get(vertex);
        if (set == null || set.isEmpty()) {
            if (incomingReferencePath != null) {
                incomingReferencePath.finalise();
            }
            return rpl;
        }
        for (ReferenceArc arc : set) {
            List<ReferencePath> expansion;
            EntityVertex target = arc.getTarget();
            ReferencePath outgoingReferencePath = incomingReferencePath == null ? new ReferencePath(arc) : new ReferencePath(incomingReferencePath, target);
            List<ReferencePath> list = expansion = outgoingReferencePath.isComplete() ? null : this.expand(target, outgoingReferencePath);
            if (expansion == null || expansion.isEmpty()) {
                rpl.add(outgoingReferencePath);
                continue;
            }
            rpl.addAll(expansion);
        }
        return rpl;
    }

    private void mapMaster(Project master) {
        if (master.build()) {
            master.configureGenerator();
            logger.info((Object)this.signature("map", master));
            String masterApplicationOrigin = StringUtils.trimToEmpty((String)master.getApplicationOrigin());
            String masterApplicationContextRoot = StringUtils.defaultIfBlank((String)master.getApplicationContextRoot(), (String)RoadMapper.jwp(master).getWebProjectName());
            String masterApplication = masterApplicationOrigin + "/" + masterApplicationContextRoot;
            this.addApplication(masterApplication);
            Collection<Project> modules = ColUtils.filter(master.getModulesList(), (Predicate)new IsProjectModule());
            logger.info((Object)("map " + master.getName() + ", modules=" + modules.size()));
            for (Project module : modules) {
                if (!module.isAnnotatedWithModule()) continue;
                this.mapModule(module, masterApplicationOrigin, masterApplicationContextRoot, masterApplication);
            }
        }
    }

    private void mapModule(Project module, String masterApplicationOrigin, String masterApplicationContextRoot, String masterApplication) {
        Object message = this.signature("map", module.getClass().getSimpleName());
        logger.trace(message);
        message = "map " + module.getName();
        message = (String)message + " {application=" + this.getApplication(module, masterApplicationOrigin, masterApplicationContextRoot);
        message = (String)message + "}";
        logger.trace(message);
        List<Entity> entities = module.getEntitiesList();
        message = "map " + module.getName() + ", entities=" + entities.size();
        message = (String)message + " " + String.valueOf(entities);
        logger.trace(message);
        for (Entity entity : entities) {
            this.mapEntity(entity, masterApplicationOrigin, masterApplicationContextRoot, masterApplication);
        }
    }

    private void mapEntity(Entity entity, String masterApplicationOrigin, String masterApplicationContextRoot, String masterApplication) {
        Object message = this.signature("map", entity.getClass().getSimpleName());
        logger.trace(message);
        List<Property> properties = entity.getPropertiesList();
        message = "map " + entity.getName() + ", application=" + this.getApplication(entity, masterApplicationOrigin, masterApplicationContextRoot);
        logger.trace(message);
        message = "map " + entity.getName() + ", properties=" + properties.size();
        message = (String)message + " " + String.valueOf(properties);
        logger.trace(message);
        String application = this.getApplication(entity, masterApplicationOrigin, masterApplicationContextRoot);
        if (masterApplication.equals(application) && entity.isDisplayAvailable()) {
            EntityVertex source = new EntityVertex(application, entity);
            this.put(source);
            for (Property property : properties) {
                Entity root;
                if (!property.isEntity() || !(root = ((Entity)((Object)property)).getRoot()).isDisplayAvailable()) continue;
                EntityVertex target = new EntityVertex(this.getApplication(root, masterApplicationOrigin, masterApplicationContextRoot), root);
                ReferenceArc reference = new ReferenceArc(source, target);
                this.put(reference);
            }
        }
    }

    private String signature(String method, Object ... parameters) {
        String pattern = "{0}({1})";
        return MessageFormat.format(pattern, method, StringUtils.join((Object[])parameters, (String)", "));
    }

    private String getApplication(Project project, String masterApplicationOrigin, String masterApplicationContextRoot) {
        String host = StringUtils.defaultIfBlank((String)project.getApplicationOrigin(), (String)masterApplicationOrigin);
        String root = StringUtils.defaultIfBlank((String)project.getApplicationContextRoot(), (String)masterApplicationContextRoot);
        return host + "/" + root;
    }

    private String getApplication(Entity entity, String masterApplicationOrigin, String masterApplicationContextRoot) {
        String host = StringUtils.defaultIfBlank((String)entity.getApplicationOrigin(), (String)masterApplicationOrigin);
        String root = StringUtils.defaultIfBlank((String)entity.getApplicationContextRoot(), (String)masterApplicationContextRoot);
        return host + "/" + root;
    }

    private void addApplication(String application) {
        if (!this.applications.contains(application)) {
            this.applications.add(application);
            this.appSources.put(application, new TreeSet());
            this.appTargets.put(application, new TreeSet());
        }
    }

    private void put(EntityVertex vertex) {
        String application = vertex.getApplication();
        String entityClass = vertex.getEntityClass();
        Set<EntityVertex> set = this.vertices.get(application);
        if (set == null) {
            set = new TreeSet<EntityVertex>();
            set.add(vertex);
            this.vertices.put(application, set);
        } else {
            set.add(vertex);
        }
        Set<String> eas = this.entityApps.get(entityClass);
        if (eas == null) {
            eas = new TreeSet<String>();
            eas.add(application);
            this.entityApps.put(entityClass, eas);
        } else {
            eas.add(application);
        }
    }

    private void put(ReferenceArc arc) {
        EntityVertex source = arc.getSource();
        Set<ReferenceArc> set = this.vertexArcs.get(source);
        if (set == null) {
            set = new TreeSet<ReferenceArc>();
            set.add(arc);
            this.vertexArcs.put(source, set);
        } else {
            set.add(arc);
        }
        if (arc.isAcross()) {
            EntityVertex target = arc.getTarget();
            String sourceApplication = source.getApplication();
            String targetApplication = target.getApplication();
            this.addApplication(sourceApplication);
            this.addApplication(targetApplication);
            this.appSources.get(targetApplication).add(sourceApplication);
            this.appTargets.get(sourceApplication).add(targetApplication);
            String entityClass = target.getEntityClass();
            Set<String> exr = this.entityRefs.get(entityClass);
            if (exr == null) {
                exr = new TreeSet<String>();
                exr.add(sourceApplication);
                this.entityRefs.put(entityClass, exr);
            } else {
                exr.add(sourceApplication);
            }
        }
    }
}

