/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.config;

import adalid.commons.util.FilUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.util.Utility;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CopyConfigFiles
extends Utility {
    static final String SOURCE_DIR = FilUtils.getUserDirPath("src", "main", "resources", "configuration");
    static final String TARGET_DIR = USER_DIR;
    private static final Logger logger = Logger.getLogger(CopyConfigFiles.class);
    private static final String COPY_MESSAGE = "\u00bfDesea copiar el archivo?";
    private static final String COPY_TITLE = "Copiar el archivo de ejemplo ";
    private static final String REPLACE_MESSAGE = " ya existe\n\u00bfDesea reemplazarlo?";
    private static final String REPLACE_TITLE = "Reemplazar el archivo de configuraci\u00f3n ";
    private static final String BACKUP_SUBDIR = "backups";

    public static void copyFile(String filename, String fromDir, String toDir, String message) {
        CopyConfigFiles.copyFile(filename, filename, fromDir, toDir, message);
    }

    public static void copyFile(String sourcefilename, String targetfilename, String fromDir, String toDir, String message) {
        block11: {
            String srce = StringUtils.defaultIfBlank((String)fromDir, (String)SOURCE_DIR);
            String trgt = StringUtils.defaultIfBlank((String)toDir, (String)TARGET_DIR);
            String back = CopyConfigFiles.backupFile(targetfilename);
            File source = new File(srce, sourcefilename);
            File target = new File(trgt, targetfilename);
            File backup = new File(trgt, back);
            logger.info((Object)("archivo = " + String.valueOf(source)));
            logger.info((Object)("destino = " + String.valueOf(target)));
            if (source.exists()) {
                boolean copy = CopyConfigFiles.showConfirmDialog(message + COPY_MESSAGE, COPY_TITLE + targetfilename);
                if (copy) {
                    boolean exists = target.exists();
                    if (exists) {
                        copy = CopyConfigFiles.showConfirmDialog(String.valueOf(target) + REPLACE_MESSAGE, REPLACE_TITLE + targetfilename, 2);
                    }
                    if (copy) {
                        try {
                            if (exists) {
                                FileUtils.copyFile((File)target, (File)backup);
                                logger.info((Object)("el archivo existente fue copiado como " + String.valueOf(backup)));
                            }
                            FileUtils.copyFile((File)source, (File)target);
                            if (exists) {
                                logger.warn((Object)"el archivo existente fue reemplazado en el directorio destino");
                                break block11;
                            }
                            logger.info((Object)"el archivo fue copiado al directorio destino");
                        }
                        catch (IOException ex) {
                            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
                        }
                    } else {
                        logger.info((Object)"el archivo no fue reemplazado en el directorio destino");
                    }
                } else {
                    logger.info((Object)"el archivo no fue copiado al directorio destino");
                }
            } else {
                logger.warn((Object)("el archivo " + String.valueOf(source) + " no existe"));
            }
        }
    }

    public static String backupFile(String filename) {
        int lastDot = filename.lastIndexOf(46);
        String sep = lastDot == 0 ? "" : "-";
        String stss = TimeUtils.simpleTimestampString();
        String back = lastDot < 0 ? filename + sep + stss : filename.substring(0, lastDot) + sep + stss + filename.substring(lastDot);
        return BACKUP_SUBDIR + File.separator + back;
    }
}

