/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.java;

import adalid.core.interfaces.Property;
import adalid.util.meta.java.MetaProperty;
import adalid.util.meta.java.MetaPropertyKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MetaEntity {
    final String name;
    final List<MetaProperty> properties = new ArrayList<MetaProperty>();
    final Set<String> steps = new TreeSet<String>();
    final Set<String> tabs = new TreeSet<String>();
    public int step = 0;

    public MetaEntity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<MetaProperty> getProperties() {
        return this.properties;
    }

    public List<String> getSteps() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.steps);
        return list;
    }

    public List<String> getTabs() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.tabs);
        return list;
    }

    public MetaProperty add(Class<? extends Property> type, String name) {
        return this.add(this.build(type, name, MetaPropertyKind.UNLINKED));
    }

    public MetaProperty add(Class<? extends Property> type, String name, MetaPropertyKind kind) {
        return this.add(this.build(type, name, kind));
    }

    private MetaProperty add(MetaProperty property) {
        this.properties.add(property);
        return property;
    }

    private MetaProperty build(Class<? extends Property> type, String name, MetaPropertyKind kind) {
        return new MetaProperty(this, type, name, kind);
    }
}

