/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.java;

import adalid.commons.util.StrUtils;
import adalid.core.interfaces.Property;
import adalid.util.meta.java.MetaEntity;
import adalid.util.meta.java.MetaPropertyKind;
import org.apache.commons.lang.StringUtils;

public class MetaProperty {
    final MetaEntity entity;
    final String step;
    final String tab;
    final Class<? extends Property> type;
    final String name;
    final MetaPropertyKind kind;
    public String wordyName;
    public String description;
    public String label;
    public String anchorLabel;

    public MetaProperty(MetaEntity entity, Class<? extends Property> type, String name, MetaPropertyKind kind) {
        this.entity = entity;
        if (entity.step > 0) {
            this.step = "step" + entity.step;
            this.entity.steps.add(this.step);
            this.tab = "tab" + entity.step;
            this.entity.tabs.add(this.tab);
        } else {
            this.step = null;
            this.tab = null;
        }
        this.type = type;
        this.name = name;
        this.kind = kind;
        this.wordyName = this.fixString(StrUtils.getWordyString(name));
    }

    public MetaEntity getEntity() {
        return this.entity;
    }

    public String getStep() {
        return this.step;
    }

    public String getTab() {
        return this.tab;
    }

    public Class<? extends Property> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public MetaPropertyKind getKind() {
        return this.kind;
    }

    public String getWordyName() {
        return this.wordyName;
    }

    public String getDescription() {
        return StringUtils.isNotBlank((String)this.description) ? this.fixString(this.description) : (MetaPropertyKind.ANCHOR.equals((Object)this.kind) ? "descripci\u00f3n del grupo de propiedades ancladas a " + this.wordyName : (MetaPropertyKind.ANCHORED.equals((Object)this.kind) ? "descripci\u00f3n de la propiedad anclada " + this.wordyName : null));
    }

    public String getLabel() {
        return StringUtils.isNotBlank((String)this.label) ? this.fixString(this.label) : this.wordyName;
    }

    public String getAnchorLabel() {
        return StringUtils.isNotBlank((String)this.anchorLabel) ? this.fixString(this.anchorLabel) : this.wordyName;
    }

    private String fixString(String string) {
        return StringUtils.isBlank((String)string) ? null : string.replaceAll("\\\"", "\\\\\"").replaceAll("\\bano\\b", "a\u00f1o").replaceAll("\\barea\\b", "\u00e1rea").replaceAll("(\\w+)ion\\b", "$1i\u00f3n");
    }
}

