/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.meta.sql;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.velocity.Writer;
import adalid.util.io.FileWrapper;
import adalid.util.io.FolderWrapper;
import adalid.util.io.RegexPathFilter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.log4j.Logger;

public class MetaFolderSql {
    private static final Logger logger = Logger.getLogger(MetaFolderSql.class);
    private static final String B = "^";
    private static final String E = "$";
    private static final String X = ".*";
    private static final String S = RegexPathFilter.SEPARATOR;
    private static final String D = "\\.";
    private static final long MAX_FILE_SIZE_BYTES = 0x500000L;
    private static final double MAX_FILE_SIZE_MEGAS = 5.0;
    private final File rootFolder;
    private final Path rootFolderPath;
    private final File metaFolder;
    private final Path metaFolderPath;
    private final FolderWrapper metaFolderWrapper;
    private final File baseFolder;
    private final Path baseFolderPath;
    private int readingWarnings;
    private int readingErrors;
    private final Map<Path, FileWrapper> files;
    private final Map<Path, FolderWrapper> folders;
    private final Map<String, Integer> fileTypes;

    public MetaFolderSql(String path) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(2);
        logger.info((Object)("max-file-size=" + nf.format(5.0) + "MB"));
        this.rootFolder = PropertiesHandler.getRootFolder();
        if (this.rootFolder == null) {
            throw new RuntimeException("root folder is missing or invalid");
        }
        this.rootFolderPath = Paths.get(this.rootFolder.getPath(), new String[0]);
        logger.info((Object)("root-folder=" + String.valueOf(this.rootFolderPath)));
        if (path == null) {
            throw new IllegalArgumentException("null folder path");
        }
        File file = new File(path);
        this.metaFolder = file.isAbsolute() ? file : new File(this.rootFolder.getAbsolutePath(), path);
        this.metaFolderPath = Paths.get(this.metaFolder.getPath(), new String[0]);
        logger.info((Object)("meta-folder=" + String.valueOf(this.metaFolderPath)));
        if (this.metaFolder.isDirectory()) {
            if (this.metaFolder.isHidden()) {
                throw new IllegalArgumentException(String.valueOf(this.metaFolderPath) + " is a hidden directory");
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(this.metaFolderPath) + " is not a directory");
        }
        this.baseFolder = this.metaFolder.getParentFile();
        this.baseFolderPath = Paths.get(this.baseFolder.getPath(), new String[0]);
        logger.info((Object)("base-folder=" + String.valueOf(this.baseFolderPath)));
        this.files = new TreeMap<Path, FileWrapper>();
        this.folders = new TreeMap<Path, FolderWrapper>();
        this.fileTypes = new TreeMap<String, Integer>();
        this.metaFolderWrapper = new FolderWrapper(this.metaFolder);
        this.folders.put(this.getRelativeToBasePath(this.metaFolder), this.metaFolderWrapper);
    }

    public boolean read() {
        logger.info((Object)"read");
        this.init();
        this.readFiles();
        this.printSummary();
        return this.readingErrors == 0;
    }

    private void init() {
        this.readingWarnings = 0;
        this.readingErrors = 0;
    }

    private boolean readFiles() {
        Path base = this.metaFolderPath.getParent();
        Collection list = FileUtils.listFiles((File)this.metaFolder, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.dirFilter());
        for (File file : list) {
            FileWrapper wrapper = new FileWrapper(file);
            wrapper.read();
            long bytes = wrapper.getBytes();
            long lines = wrapper.getLines();
            if (wrapper.isNotEmpty()) {
                this.files.put(wrapper.getPath(), wrapper);
                String type = wrapper.getType();
                this.updateFileTypes(type);
                this.updateFolders(wrapper);
            }
            this.readingWarnings += wrapper.getReadingWarnings();
            this.readingErrors += wrapper.getReadingErrors();
            logger.debug((Object)("file=" + String.valueOf(wrapper.getRelativePath(base)) + ", " + String.valueOf(wrapper.getCharset()) + ", " + bytes + ", " + lines));
        }
        this.updateFolders();
        return true;
    }

    private void updateFileTypes(String type) {
        if (this.fileTypes.containsKey(type)) {
            int count = this.fileTypes.get(type);
            this.fileTypes.put(type, ++count);
        } else {
            this.fileTypes.put(type, 1);
        }
    }

    private void updateFolders(FileWrapper fileWrapper) {
        File parent = fileWrapper.getFile().getParentFile();
        if (parent != null) {
            FolderWrapper parentWrapper;
            Path parentPath = this.getRelativeToBasePath(parent);
            if (this.folders.containsKey(parentPath)) {
                parentWrapper = this.folders.get(parentPath);
            } else {
                parentWrapper = new FolderWrapper(parent);
                this.folders.put(parentPath, parentWrapper);
            }
            parentWrapper.getBytesSizes().get((Object)fileWrapper.getBytesSize()).next();
            parentWrapper.getLinesSizes().get((Object)fileWrapper.getLinesSize()).next();
            parentWrapper.setLocalFiles(parentWrapper.getLocalFiles() + 1L);
            parentWrapper.setLocalBytes(parentWrapper.getLocalBytes() + fileWrapper.getBytes());
            parentWrapper.setLocalLines(parentWrapper.getLocalLines() + (long)fileWrapper.getLines());
            parentWrapper.setTotalFiles(parentWrapper.getTotalFiles() + 1L);
            parentWrapper.setTotalBytes(parentWrapper.getTotalBytes() + fileWrapper.getBytes());
            parentWrapper.setTotalLines(parentWrapper.getTotalLines() + (long)fileWrapper.getLines());
            if (!parent.equals(this.metaFolder)) {
                this.updateFolders(fileWrapper, parent);
            }
        }
    }

    private void updateFolders(FileWrapper fileWrapper, File folder) {
        File parent = folder.getParentFile();
        if (parent != null) {
            FolderWrapper parentWrapper;
            Path parentPath = this.getRelativeToBasePath(parent);
            if (this.folders.containsKey(parentPath)) {
                parentWrapper = this.folders.get(parentPath);
            } else {
                parentWrapper = new FolderWrapper(parent);
                this.folders.put(parentPath, parentWrapper);
            }
            parentWrapper.getBytesSizes().get((Object)fileWrapper.getBytesSize()).next();
            parentWrapper.getLinesSizes().get((Object)fileWrapper.getLinesSize()).next();
            parentWrapper.setTotalFiles(parentWrapper.getTotalFiles() + 1L);
            parentWrapper.setTotalBytes(parentWrapper.getTotalBytes() + fileWrapper.getBytes());
            parentWrapper.setTotalLines(parentWrapper.getTotalLines() + (long)fileWrapper.getLines());
            if (!parent.equals(this.metaFolder)) {
                this.updateFolders(fileWrapper, parent);
            }
        }
    }

    private void updateFolders() {
        double totalFiles = this.metaFolderWrapper.getTotalFiles();
        double totalBytes = this.metaFolderWrapper.getTotalBytes();
        double totalLines = this.metaFolderWrapper.getTotalLines();
        for (FolderWrapper wrapper : this.folders.values()) {
            double filesShare = totalFiles == 0.0 ? 0.0 : (double)wrapper.getTotalFiles() / totalFiles;
            double bytesShare = totalBytes == 0.0 ? 0.0 : (double)wrapper.getTotalBytes() / totalBytes;
            double linesShare = totalLines == 0.0 ? 0.0 : (double)wrapper.getTotalLines() / totalLines;
            wrapper.setFilesShare(filesShare);
            wrapper.setBytesShare(bytesShare);
            wrapper.setLinesShare(linesShare);
        }
    }

    private Path getRelativeToBasePath(File file) {
        Path path = Paths.get(file.getPath(), new String[0]);
        if (path.startsWith(this.baseFolderPath)) {
            try {
                return this.baseFolderPath.relativize(path);
            }
            catch (IllegalArgumentException ex) {
                return path;
            }
        }
        return path;
    }

    private void printSummary() {
        logger.info((Object)(this.files.size() + " files "));
        logger.info((Object)(this.folders.size() + " folders "));
        logger.info((Object)(this.fileTypes.size() + " file types "));
        logger.info((Object)(this.readingWarnings + " reading warnings "));
        logger.info((Object)(this.readingErrors + " reading errors "));
    }

    private IOFileFilter fileFilter() {
        IOFileFilter sizeFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.sizeFileFilter((long)0x500000L));
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^.*\\.[0-9]*$"), new RegexFileFilter("^.*\\.arial$"), new RegexFileFilter("^.*\\.class$"), new RegexFileFilter("^.*\\.cli$"), new RegexFileFilter("^.*\\.conf$"), new RegexFileFilter("^.*\\.db$"), new RegexFileFilter("^.*\\.doc$"), new RegexFileFilter("^.*\\.docx$"), new RegexFileFilter("^.*\\.ear$"), new RegexFileFilter("^.*\\.err$"), new RegexFileFilter("^.*\\.gif$"), new RegexFileFilter("^.*\\.jar$"), new RegexFileFilter("^.*\\.jasper$"), new RegexFileFilter("^.*\\.jpg$"), new RegexFileFilter("^.*\\.key$"), new RegexFileFilter("^.*\\.lnk$"), new RegexFileFilter("^.*\\.log$"), new RegexFileFilter("^.*\\.lst$"), new RegexFileFilter("^.*\\.out$"), new RegexFileFilter("^.*\\.pdf$"), new RegexFileFilter("^.*\\.png$"), new RegexFileFilter("^.*\\.ppt$"), new RegexFileFilter("^.*\\.pptx$"), new RegexFileFilter("^.*\\.war$"), new RegexFileFilter("^.*\\.xls$"), new RegexFileFilter("^.*\\.xlsx$"), new RegexFileFilter("^.*\\.zip$"), new RegexFileFilter("^\\..*$")};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{sizeFileFilter, noesFileFilter});
        return filter;
    }

    private IOFileFilter dirFilter() {
        IOFileFilter makeFileFilter = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.makeSVNAware(null));
        RegexPathFilter metaFileFilter = new RegexPathFilter("^.*" + S + "velocity" + S + "templates" + S + "meta" + S + ".*$");
        IOFileFilter mesaFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)metaFileFilter);
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^\\.git$"), new RegexFileFilter("^\\.settings$"), new RegexFileFilter("^backup$"), new RegexFileFilter("^build$"), new RegexFileFilter("^dist$"), new RegexFileFilter("^logs$"), new RegexFileFilter("^nbproject$"), new RegexFileFilter("^private$"), new RegexFileFilter("^target$"), new RegexFileFilter("^test$")};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{makeFileFilter, mesaFileFilter, noesFileFilter});
        return filter;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Path getRootFolderPath() {
        return this.rootFolderPath;
    }

    public File getMetaFolder() {
        return this.metaFolder;
    }

    public Path getMetaFolderPath() {
        return this.metaFolderPath;
    }

    public FolderWrapper getMetaFolderWrapper() {
        return this.metaFolderWrapper;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public Path getBaseFolderPath() {
        return this.baseFolderPath;
    }

    public int getReadingWarnings() {
        return this.readingWarnings;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public Map<Path, FileWrapper> getFiles() {
        return this.files;
    }

    public Map<Path, FolderWrapper> getFolders() {
        return this.folders;
    }

    public Map<String, Integer> getFileTypes() {
        return this.fileTypes;
    }

    public void write() {
        logger.info((Object)"write");
        Writer writer = new Writer(this, "root");
        writer.write("meta-folder-sql");
    }
}

